/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.helper;

import com.lothrazar.simpletomb.ConfigTomb;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;

public class WorldHelper {
    public static float getRandom(Random rand, double min, double max) {
        return (float)(rand.nextDouble() * (max - min) + min);
    }

    public static String dimensionToString(Level w) {
        return w.m_46472_().m_135782_().toString();
    }

    public static boolean isValidPlacement(Level world, BlockPos myPos) {
        if (myPos.m_123342_() < 1 || world.m_151570_(myPos)) {
            return false;
        }
        BlockState blockState = world.m_8055_(myPos);
        return blockState.m_60734_() == Blocks.f_50016_ || blockState.m_60734_() == Blocks.f_49990_;
    }

    public static LocationBlockPos findGraveSpawn(Player player, BlockPos initPos) {
        int xRange = (Integer)ConfigTomb.HSEARCHRANGE.get();
        int yRange = (Integer)ConfigTomb.VSEARCHRANGE.get();
        int zRange = (Integer)ConfigTomb.HSEARCHRANGE.get();
        Level world = player.f_19853_;
        if (WorldHelper.isValidPlacement(player.f_19853_, initPos) && WorldHelper.isValidSolid(player.f_19853_, initPos)) {
            return new LocationBlockPos(initPos, world);
        }
        ArrayList<BlockPos> positionsWithSolidBelow = new ArrayList<BlockPos>();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = initPos.m_123341_() - xRange; x < initPos.m_123341_() + xRange; ++x) {
            for (int y = initPos.m_123342_() - yRange; y < initPos.m_123342_() + yRange; ++y) {
                for (int z = initPos.m_123343_() - zRange; z < initPos.m_123343_() + zRange; ++z) {
                    BlockPos myPos = new BlockPos(x, y, z);
                    boolean isValid = WorldHelper.isValidPlacement(world, myPos);
                    if (!isValid) continue;
                    if (WorldHelper.isValidSolid(world, myPos)) {
                        positionsWithSolidBelow.add(myPos);
                        continue;
                    }
                    positions.add(myPos);
                }
            }
        }
        BlockPos found = null;
        if (positionsWithSolidBelow.size() > 0) {
            WorldHelper.sortByDistance(initPos, positionsWithSolidBelow);
            found = (BlockPos)positionsWithSolidBelow.get(0);
        } else if (positions.size() > 0) {
            WorldHelper.sortByDistance(initPos, positions);
            found = (BlockPos)positions.get(0);
        } else {
            return null;
        }
        return new LocationBlockPos(found, world);
    }

    private static boolean isValidSolid(Level world, BlockPos myPos) {
        return world.m_8055_(myPos.m_7495_()).m_60815_();
    }

    private static void sortByDistance(BlockPos initPos, List<BlockPos> positions) {
        positions.sort((pos0, pos1) -> {
            double dist0 = Math.sqrt(pos0.m_123331_((Vec3i)initPos));
            double dist1 = Math.sqrt(pos1.m_123331_((Vec3i)initPos));
            return Double.valueOf(dist0).compareTo(dist1);
        });
    }

    public static BlockPos getInitialPos(Level world, BlockPos pos) {
        boolean validY;
        WorldBorder border = world.m_6857_();
        boolean validXZ = border.m_61937_(pos);
        boolean bl = validY = !world.m_151570_(pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (!validXZ) {
            x = Math.min(Math.max(pos.m_123341_(), (int)border.m_61955_()), (int)border.m_61957_());
            z = Math.min(Math.max(pos.m_123343_(), (int)border.m_61956_()), (int)border.m_61958_());
        }
        if (!validY) {
            if (y < 1) {
                y = 1;
            }
            if (y > world.m_151558_()) {
                y = world.m_151558_() - 1;
            }
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isRuleKeepInventory(Player player) {
        return WorldHelper.isRuleKeepInventory(player.f_19853_);
    }

    public static boolean isRuleKeepInventory(Level world) {
        return world.m_46469_().m_46207_(GameRules.f_46133_);
    }

    public static void removeNoEvent(Level world, BlockPos pos) {
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    public static boolean placeGrave(Level world, BlockPos pos, BlockState state) {
        return world.m_7731_(pos, state, 2);
    }

    public static boolean isNight(Level world) {
        float angle = world.m_46490_(0.0f);
        return angle >= 0.245f && angle <= 0.755f;
    }

    public static float[] getRGBColor3F(int color) {
        return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }
}

