/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.item;

import com.lothrazar.simpletomb.ConfigTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.BlockTomb;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.NBTHelper;
import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.proxy.ClientUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class GraveKeyItem
extends SwordItem {
    private static final String TOMB_POS = "tombPos";

    public GraveKeyItem(Item.Properties properties) {
        super((Tier)Tiers.STONE, 3, -2.4f, properties.m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_41466_() {
        return new TranslatableComponent(this.m_5524_()).m_130940_(ChatFormatting.GOLD);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LocationBlockPos location = this.getTombPos(stack);
            if (location == null || location.isOrigin() || !location.dim.equalsIgnoreCase(WorldHelper.dimensionToString(player.f_19853_))) {
                return;
            }
            double distance = location.getDistance(player.m_142538_());
            boolean canTp = false;
            if (player.m_7500_()) {
                canTp = (Boolean)ConfigTomb.TPCREATIVE.get();
            } else {
                boolean bl = canTp = (Integer)ConfigTomb.TPSURVIVAL.get() > 0 && distance < (double)((Integer)ConfigTomb.TPSURVIVAL.get()).intValue() || (Integer)ConfigTomb.TPSURVIVAL.get() == -1;
            }
            if (canTp) {
                if (timeLeft <= 1) {
                    BlockPos pos = location.toBlockPos();
                    player.m_6021_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                } else if (entity.f_19853_.f_46443_) {
                    ClientUtils.produceParticleCasting(entity, p -> !p.m_6117_());
                }
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        return 86;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (((Boolean)ConfigTomb.KEYOPENONUSE.get()).booleanValue()) {
            BlockState state;
            BlockPos pos = context.m_8083_();
            Player player = context.m_43723_();
            if (player.m_21120_(context.m_43724_()).m_41720_() == TombRegistry.GRAVE_KEY && (state = context.m_43725_().m_8055_(pos)).m_60734_() instanceof BlockTomb) {
                BlockTomb.activatePlayerGrave(player.f_19853_, pos, state, player);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            LocationBlockPos location = this.getTombPos(stack);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && !location.isOrigin()) {
                BlockPos pos = player.m_142538_();
                int distance = (int)location.getDistance(pos);
                list.add((Component)new TranslatableComponent(MessageType.MESSAGE_DISTANCE.getKey(), new Object[]{distance, location.x, location.y, location.z, location.dim}).m_130940_(ChatFormatting.DARK_PURPLE));
            }
        }
        super.m_7373_(stack, world, list, flag);
    }

    public boolean setTombPos(ItemStack stack, LocationBlockPos location) {
        if (stack.m_41720_() == this && !location.isOrigin()) {
            NBTHelper.setLocation(stack, TOMB_POS, location);
            return true;
        }
        return false;
    }

    public LocationBlockPos getTombPos(ItemStack stack) {
        return stack.m_41720_() == this ? NBTHelper.getLocation(stack, TOMB_POS) : LocationBlockPos.ORIGIN;
    }

    public boolean removeKeyForGraveInInventory(Player player, LocationBlockPos graveLoc) {
        IItemHandler itemHandler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.m_41720_() != TombRegistry.GRAVE_KEY || !TombRegistry.GRAVE_KEY.getTombPos(stack).equals(graveLoc)) continue;
                itemHandler.extractItem(i, 1, false);
                return true;
            }
        }
        return false;
    }

    public int countKeyInInventory(Player player) {
        return (int)player.m_150109_().f_35974_.stream().filter(stack -> stack.m_41720_() == TombRegistry.GRAVE_KEY).count();
    }
}

