/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.talhanation.smallships.init.SoundInit;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.client.CSteerBoatPacket;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractGalleyEntity
extends BoatEntity {
    private static final DataParameter<Boolean> LEFT_PADDLE = EntityDataManager.func_187226_a(AbstractGalleyEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RIGHT_PADDLE = EntityDataManager.func_187226_a(AbstractGalleyEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private LazyOptional<ItemStackHandler> itemHandler = LazyOptional.of(() -> this.inventory);
    private final float[] paddlePositions = new float[2];
    public float field_184472_g;
    public float field_184474_h;
    public float field_184475_as;
    private int lerpSteps;
    private double lerpX;
    public boolean field_70128_L;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    public boolean field_184480_az;
    public boolean field_184459_aA;
    private boolean forwardInputDown;
    private boolean backInputDown;
    private double waterLevel;
    private float boatGlide;
    private BoatEntity.Status status;
    private BoatEntity.Status previousStatus;
    private double lastYd;
    private boolean rocking;
    private boolean downwards;
    private float rockingIntensity;
    private float rockingAngle;
    private float prevRockingAngle;
    public ItemStackHandler inventory = this.initInventory();
    public int passengerwaittime;
    public int controltimer;
    public float passengerfaktor;
    public int playFirstSailSoundcounter;
    public int playLastSailSoundcounter;
    public boolean leftsteer;
    public boolean rightsteer;

    protected abstract ItemStackHandler initInventory();

    public AbstractGalleyEntity(EntityType<? extends AbstractGalleyEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LEFT_PADDLE, (Object)false);
        this.field_70180_af.func_187214_a(RIGHT_PADDLE, (Object)false);
    }

    public void func_70071_h_() {
        --this.passengerwaittime;
        --this.playFirstSailSoundcounter;
        --this.playLastSailSoundcounter;
        this.previousStatus = this.status;
        this.status = this.func_184449_t();
        this.field_184474_h = this.status != BoatEntity.Status.UNDER_WATER && this.status != BoatEntity.Status.UNDER_FLOWING_WATER ? 0.0f : (this.field_184474_h += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.field_184474_h >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.func_70268_h() > 0) {
            this.func_70265_b(this.func_70268_h() - 1);
        }
        super.func_70071_h_();
        this.func_184447_s();
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof PlayerEntity)) {
                this.func_184445_a(false, false);
            }
            this.func_184450_w();
            if (this.field_70170_p.field_72995_K) {
                this.func_184443_x();
                this.field_70170_p.func_184135_a((IPacket)new CSteerBoatPacket(this.func_184457_a(0), this.func_184457_a(1)));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        for (int i = 0; i <= 1; ++i) {
            if (this.func_184457_a(i)) {
                SoundEvent soundevent;
                if (!this.func_174814_R() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.paddlePositions[i] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (soundevent = this.func_193047_k()) != null) {
                    Vector3d vector3d = this.func_70676_i(1.0f);
                    double d0 = i == 1 ? -vector3d.field_72449_c : vector3d.field_72449_c;
                    double d1 = i == 1 ? vector3d.field_72450_a : -vector3d.field_72450_a;
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_() + d0, this.func_226278_cu_(), this.func_226281_cx_() + d1, soundevent, this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_() + d0, this.func_226278_cu_(), this.func_226281_cx_() + d1, soundevent, this.func_184176_by(), 1.0f, 0.2f + 0.4f * this.field_70146_Z.nextFloat());
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_() + d0, this.func_226278_cu_(), this.func_226281_cx_() + d1, soundevent, this.func_184176_by(), 1.0f, 0.3f + 0.4f * this.field_70146_Z.nextFloat());
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_() + d0, this.func_226278_cu_(), this.func_226281_cx_() + d1, soundevent, this.func_184176_by(), 1.0f, 0.6f + 0.4f * this.field_70146_Z.nextFloat());
                }
                this.paddlePositions[i] = (float)((double)this.paddlePositions[i] + (double)0.3926991f);
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        if (this.playFirstSailSoundcounter == 0) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)SoundInit.SHIP_SAIL_0.get(), this.func_184176_by(), 10.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat(), false);
        }
        if (this.playLastSailSoundcounter == 0) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)SoundInit.SHIP_SAIL_1.get(), this.func_184176_by(), 8.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat(), false);
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof PlayerEntity);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.func_184196_w((Entity)this)) continue;
                if (flag && this.func_184188_bt().size() < 8 && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof LivingEntity && !(entity instanceof WaterMobEntity) && !(entity instanceof PlayerEntity)) {
                    if (this.passengerwaittime >= 0) continue;
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    public void func_184447_s() {
        if (this.func_184186_bw()) {
            this.lerpSteps = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public BoatEntity.Status func_184449_t() {
        BoatEntity.Status boatentity$status = this.getUnderwaterStatus();
        if (boatentity$status != null) {
            this.waterLevel = this.func_174813_aQ().field_72337_e;
            return boatentity$status;
        }
        if (this.checkInWater()) {
            return BoatEntity.Status.IN_WATER;
        }
        float f = this.func_184441_l();
        if (f > 0.0f) {
            this.boatGlide = 0.0f;
            return BoatEntity.Status.ON_LAND;
        }
        return BoatEntity.Status.IN_AIR;
    }

    public void func_184450_w() {
        double d0 = -0.03;
        double d1 = this.func_189652_ae() ? 0.0 : d0;
        double d2 = 0.0;
        this.field_184472_g = 1.0f;
        this.passengerfaktor = 0.0f;
        if (this.previousStatus == BoatEntity.Status.IN_AIR && this.status != BoatEntity.Status.IN_AIR && this.status != BoatEntity.Status.ON_LAND) {
            this.waterLevel = this.func_174813_aQ().field_72338_b + (double)this.func_213302_cg();
            this.func_70107_b(this.func_226277_ct_(), (double)(this.func_184451_k() - this.func_213302_cg()) + 0.101, this.func_226281_cx_());
            this.func_213317_d(this.func_213322_ci().func_216372_d(10.0, 0.0, 10.0));
            this.lastYd = 0.0;
            this.status = BoatEntity.Status.IN_WATER;
        } else {
            if (this.status == BoatEntity.Status.IN_WATER) {
                d2 = (this.waterLevel - this.func_174813_aQ().field_72338_b + 0.1) / (double)this.func_213302_cg();
                this.field_184472_g = 0.9f;
            } else if (this.status == BoatEntity.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.field_184472_g = 0.9f;
            } else if (this.status == BoatEntity.Status.UNDER_WATER) {
                d2 = 0.01f;
                this.field_184472_g = 0.45f;
            } else if (this.status == BoatEntity.Status.IN_AIR) {
                this.field_184472_g = 0.9f;
            } else if (this.status == BoatEntity.Status.ON_LAND) {
                this.field_184472_g = this.boatGlide * 0.001f;
                if (this.func_184179_bs() instanceof PlayerEntity) {
                    this.boatGlide /= 1.0f;
                }
            }
            Vector3d vec3d = this.func_213322_ci();
            this.func_213293_j(vec3d.field_72450_a * (double)(this.field_184472_g - this.passengerfaktor), vec3d.field_72448_b + d1, vec3d.field_72449_c * (double)(this.field_184472_g - this.passengerfaktor));
            this.field_184475_as = (float)((double)this.field_184475_as * ((double)(this.field_184472_g - this.passengerfaktor) * 0.5));
            if (d2 > 0.0) {
                Vector3d vec3d1 = this.func_213322_ci();
                this.func_213293_j(vec3d1.field_72450_a, (vec3d1.field_72448_b + d2 * 0.06) * 0.75, vec3d1.field_72449_c);
            }
        }
    }

    public double func_70042_X() {
        return 0.75;
    }

    protected void func_184443_x() {
        if (this.func_184207_aI()) {
            float f = 0.0f;
            if (this.field_184480_az) {
                this.field_184475_as -= 1.0f;
            }
            if (this.field_184459_aA) {
                this.field_184475_as += 1.0f;
            }
            if (this.field_184459_aA != this.field_184480_az && !this.forwardInputDown && !this.backInputDown) {
                f += 0.005f;
            }
            this.field_70177_z += this.field_184475_as;
            if (this.forwardInputDown) {
                f += 0.06f;
            }
            if (this.backInputDown) {
                f -= 0.005f;
            }
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f)));
            this.func_184445_a(this.field_184459_aA && !this.field_184480_az || this.forwardInputDown, this.field_184480_az && !this.field_184459_aA || this.forwardInputDown);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    private BoatEntity.Status getUnderwaterStatus() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) || !(d0 < (double)((float)blockpos$mutable.func_177956_o() + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.func_206889_d()) {
                        return BoatEntity.Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? BoatEntity.Status.UNDER_WATER : null;
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof BoatEntity) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b && !(entityIn instanceof WaterMobEntity)) {
            super.func_70108_f(entityIn);
        }
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (inventorySlot >= 0 && inventorySlot < this.inventory.getSlots()) {
            this.inventory.setStackInSlot(inventorySlot, itemStackIn);
            return true;
        }
        return false;
    }

    public void onDestroyedAndDoDrops(DamageSource source) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (ItemStack)this.inventory.getStackInSlot(i));
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("Items"));
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData && this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            boolean flag;
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source instanceof IndirectEntityDamageSource && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.func_70269_c(-this.func_70267_i());
            this.func_70265_b(3);
            this.func_70266_a(this.func_70271_g() + amount * 10.0f);
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.func_70271_g() > 600.0f) {
                this.onDestroyed(source, flag);
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public void onDestroyed(DamageSource source, boolean byCreativePlayer) {
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            if (!byCreativePlayer) {
                this.func_199703_a((IItemProvider)this.func_184455_j());
            }
            this.onDestroyedAndDoDrops(source);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184442_a(boolean leftInputDown, boolean rightInputDown, boolean forwardInputDown, boolean backInputDown) {
        this.field_184480_az = leftInputDown;
        this.field_184459_aA = rightInputDown;
        this.forwardInputDown = forwardInputDown;
        this.backInputDown = backInputDown;
    }

    public boolean isSailDown() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            this.playLastSailSoundcounter = 5;
            return true;
        }
        return false;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184179_bs() instanceof PlayerEntity) {
            this.playFirstSailSoundcounter = 5;
        }
    }

    @Nullable
    protected SoundEvent func_193047_k() {
        switch (this.func_184449_t()) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return SoundEvents.field_193779_I;
            }
            case ON_LAND: {
                return SoundEvents.field_193778_H;
            }
        }
        return null;
    }

    public void func_184445_a(boolean left, boolean right) {
        this.field_70180_af.func_187227_b(LEFT_PADDLE, (Object)left);
        this.field_70180_af.func_187227_b(RIGHT_PADDLE, (Object)right);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_184448_a(int side, float limbSwing) {
        return this.func_184457_a(side) ? (float)MathHelper.func_151238_b((double)((double)this.paddlePositions[side] - (double)0.3926991f), (double)this.paddlePositions[side], (double)limbSwing) : 0.0f;
    }

    public boolean func_184457_a(int side) {
        return (Boolean)this.field_70180_af.func_187225_a(side == 0 ? LEFT_PADDLE : RIGHT_PADDLE) != false && this.func_184179_bs() != null;
    }

    public Vector3d func_230268_c_(LivingEntity rider) {
        float[] fArray;
        if (rider.func_184591_cq() == HandSide.RIGHT) {
            float[] fArray2 = new float[2];
            fArray2[0] = 90.0f;
            fArray = fArray2;
            fArray2[1] = -90.0f;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = -90.0f;
            fArray = fArray3;
            fArray3[1] = 90.0f;
        }
        for (float angle : fArray) {
            Vector3d pos = this.dismount(AbstractGalleyEntity.func_233559_a_((double)this.func_213311_cf(), (double)rider.func_213311_cf(), (float)(this.field_70177_z + angle)), rider);
            if (pos == null) continue;
            return pos;
        }
        return this.func_213303_ch();
    }

    private Vector3d dismount(Vector3d dir, LivingEntity rider) {
        double x = this.func_226277_ct_() + dir.field_72450_a;
        double y = this.func_174813_aQ().field_72338_b;
        double z = this.func_226281_cx_() + dir.field_72449_c;
        double limit = this.func_174813_aQ().field_72337_e + 0.75;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        block0: for (Pose pose : rider.func_230297_ef_()) {
            blockPos.func_189532_c(x, y, z);
            while ((double)blockPos.func_177956_o() < limit) {
                double ground = this.field_70170_p.func_242403_h((BlockPos)blockPos);
                if ((double)blockPos.func_177956_o() + ground > limit) continue block0;
                if (TransportationHelper.func_234630_a_((double)ground)) {
                    Vector3d pos = new Vector3d(x, (double)blockPos.func_177956_o() + ground, z);
                    if (TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)rider, (AxisAlignedBB)rider.func_233648_f_(pose).func_191194_a(pos))) {
                        rider.func_213301_b(pose);
                        return pos;
                    }
                }
                blockPos.func_189536_c(Direction.UP);
            }
        }
        return null;
    }
}

