/*
 * Decompiled with CFR 0.152.
 */
package com.sirdizarm.tablechair.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.sirdizarm.tablechair.Main;
import com.sirdizarm.tablechair.config.BirthdayCake;
import com.sirdizarm.tablechair.config.ChickenModel;
import com.sirdizarm.tablechair.config.FlowerPot;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Config {
    private static final ForgeConfigSpec.Builder server_builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec server_config;
    private static final ForgeConfigSpec.Builder client_builder;
    public static final ForgeConfigSpec client_config;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        Main.LOGGER.info("Loading config: " + path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        Main.LOGGER.info("Built config: " + path);
        file.load();
        Main.LOGGER.info("Loaded congig: " + path);
        config.setConfig((CommentedConfig)file);
    }

    static {
        client_builder = new ForgeConfigSpec.Builder();
        BirthdayCake.init(server_builder, client_builder);
        FlowerPot.init(server_builder, client_builder);
        ChickenModel.init(server_builder, client_builder);
        server_config = server_builder.build();
        client_config = client_builder.build();
    }
}

