/*
 * Decompiled with CFR 0.152.
 */
package com.sirdizarm.tablechair.objects.blocks;

import com.google.common.collect.Sets;
import com.sirdizarm.tablechair.entities.SeatEntity;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockChair
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final IntegerProperty CUSHION = IntegerProperty.func_177719_a((String)"cushion", (int)0, (int)16);
    private static final VoxelShape LOWER_SHAPE_S = Stream.of(Block.func_208617_a((double)12.0, (double)0.0, (double)2.0, (double)15.0, (double)7.0, (double)5.0), Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)16.0, (double)15.0), Block.func_208617_a((double)4.0, (double)7.0, (double)13.0, (double)12.0, (double)16.0, (double)14.0), Block.func_208617_a((double)1.0, (double)0.0, (double)2.0, (double)4.0, (double)7.0, (double)5.0), Block.func_208617_a((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)15.0), Block.func_208617_a((double)1.0, (double)7.0, (double)1.0, (double)15.0, (double)10.0, (double)12.0), Block.func_208617_a((double)3.0, (double)0.0, (double)5.0, (double)3.0, (double)7.0, (double)9.0), Block.func_208617_a((double)13.0, (double)0.0, (double)5.0, (double)13.0, (double)7.0, (double)9.0), Block.func_208617_a((double)13.0, (double)0.0, (double)9.0, (double)13.0, (double)7.0, (double)12.0), Block.func_208617_a((double)3.0, (double)0.0, (double)9.0, (double)3.0, (double)7.0, (double)12.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape LOWER_SHAPE_W = Stream.of(Block.func_208617_a((double)11.0, (double)0.0, (double)12.0, (double)14.0, (double)7.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)15.0), Block.func_208617_a((double)2.0, (double)7.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0), Block.func_208617_a((double)11.0, (double)0.0, (double)1.0, (double)14.0, (double)7.0, (double)4.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)16.0, (double)4.0), Block.func_208617_a((double)4.0, (double)7.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0), Block.func_208617_a((double)7.0, (double)0.0, (double)3.0, (double)11.0, (double)7.0, (double)3.0), Block.func_208617_a((double)7.0, (double)0.0, (double)13.0, (double)11.0, (double)7.0, (double)13.0), Block.func_208617_a((double)4.0, (double)0.0, (double)13.0, (double)7.0, (double)7.0, (double)13.0), Block.func_208617_a((double)4.0, (double)0.0, (double)3.0, (double)7.0, (double)7.0, (double)3.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape LOWER_SHAPE_N = Stream.of(Block.func_208617_a((double)1.0, (double)0.0, (double)11.0, (double)4.0, (double)7.0, (double)14.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)16.0, (double)4.0), Block.func_208617_a((double)4.0, (double)7.0, (double)2.0, (double)12.0, (double)16.0, (double)3.0), Block.func_208617_a((double)12.0, (double)0.0, (double)11.0, (double)15.0, (double)7.0, (double)14.0), Block.func_208617_a((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)4.0), Block.func_208617_a((double)1.0, (double)7.0, (double)4.0, (double)15.0, (double)10.0, (double)15.0), Block.func_208617_a((double)13.0, (double)0.0, (double)7.0, (double)13.0, (double)7.0, (double)11.0), Block.func_208617_a((double)3.0, (double)0.0, (double)7.0, (double)3.0, (double)7.0, (double)11.0), Block.func_208617_a((double)3.0, (double)0.0, (double)4.0, (double)3.0, (double)7.0, (double)7.0), Block.func_208617_a((double)13.0, (double)0.0, (double)4.0, (double)13.0, (double)7.0, (double)7.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape LOWER_SHAPE_E = Stream.of(Block.func_208617_a((double)2.0, (double)0.0, (double)1.0, (double)5.0, (double)7.0, (double)4.0), Block.func_208617_a((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)4.0), Block.func_208617_a((double)13.0, (double)7.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0), Block.func_208617_a((double)2.0, (double)0.0, (double)12.0, (double)5.0, (double)7.0, (double)15.0), Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)16.0, (double)15.0), Block.func_208617_a((double)1.0, (double)7.0, (double)1.0, (double)12.0, (double)10.0, (double)15.0), Block.func_208617_a((double)5.0, (double)0.0, (double)13.0, (double)9.0, (double)7.0, (double)13.0), Block.func_208617_a((double)5.0, (double)0.0, (double)3.0, (double)9.0, (double)7.0, (double)3.0), Block.func_208617_a((double)9.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)3.0), Block.func_208617_a((double)9.0, (double)0.0, (double)13.0, (double)12.0, (double)7.0, (double)13.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape UPPER_SHAPE_S = Stream.of(Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)4.0, (double)0.0, (double)13.0, (double)12.0, (double)7.0, (double)14.0), Block.func_208617_a((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)15.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape UPPER_SHAPE_W = Stream.of(Block.func_208617_a((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)15.0), Block.func_208617_a((double)2.0, (double)0.0, (double)4.0, (double)3.0, (double)7.0, (double)12.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)8.0, (double)4.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape UPPER_SHAPE_N = Stream.of(Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)8.0, (double)4.0), Block.func_208617_a((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)7.0, (double)3.0), Block.func_208617_a((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)4.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape UPPER_SHAPE_E = Stream.of(Block.func_208617_a((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)4.0), Block.func_208617_a((double)13.0, (double)0.0, (double)4.0, (double)14.0, (double)7.0, (double)12.0), Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)8.0, (double)15.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static Set<Item> validItems = Sets.newHashSet((Object[])new Item[]{Items.field_221618_aT, Items.field_221614_aP, Items.field_221615_aQ, Items.field_221612_aN, Items.field_221610_aL, Items.field_221616_aR, Items.field_221606_aH, Items.field_221611_aM, Items.field_221608_aJ, Items.field_221605_aG, Items.field_221604_aF, Items.field_221609_aK, Items.field_221613_aO, Items.field_221617_aS, Items.field_221603_aE, Items.field_221607_aI});

    public BlockChair(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)CUSHION, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE_N : LOWER_SHAPE_N;
            }
            case SOUTH: {
                return state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE_S : LOWER_SHAPE_S;
            }
            case EAST: {
                return state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE_E : LOWER_SHAPE_E;
            }
            case WEST: {
                return state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE_W : LOWER_SHAPE_W;
            }
        }
        return state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE_N : LOWER_SHAPE_N;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player.func_225608_bj_()) {
            return (BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
        }
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        BlockPos blockpos = doubleblockhalf == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b(HALF) != doubleblockhalf) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP);
        }
        return blockstate.func_177230_c() == this;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{HALF, FACING, CUSHION});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack helditem = player.func_184586_b(handIn);
        if (validItems.contains(helditem.func_77973_b())) {
            if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
                int wool = 0;
                if (helditem.func_77973_b() == Items.field_221618_aT) {
                    wool = 1;
                }
                if (helditem.func_77973_b() == Items.field_221614_aP) {
                    wool = 2;
                }
                if (helditem.func_77973_b() == Items.field_221615_aQ) {
                    wool = 3;
                }
                if (helditem.func_77973_b() == Items.field_221612_aN) {
                    wool = 4;
                }
                if (helditem.func_77973_b() == Items.field_221610_aL) {
                    wool = 5;
                }
                if (helditem.func_77973_b() == Items.field_221616_aR) {
                    wool = 6;
                }
                if (helditem.func_77973_b() == Items.field_221606_aH) {
                    wool = 7;
                }
                if (helditem.func_77973_b() == Items.field_221611_aM) {
                    wool = 8;
                }
                if (helditem.func_77973_b() == Items.field_221608_aJ) {
                    wool = 9;
                }
                if (helditem.func_77973_b() == Items.field_221605_aG) {
                    wool = 10;
                }
                if (helditem.func_77973_b() == Items.field_221604_aF) {
                    wool = 11;
                }
                if (helditem.func_77973_b() == Items.field_221609_aK) {
                    wool = 12;
                }
                if (helditem.func_77973_b() == Items.field_221613_aO) {
                    wool = 13;
                }
                if (helditem.func_77973_b() == Items.field_221617_aS) {
                    wool = 14;
                }
                if (helditem.func_77973_b() == Items.field_221603_aE) {
                    wool = 15;
                }
                if (helditem.func_77973_b() == Items.field_221607_aI) {
                    wool = 16;
                }
                BlockState blockstate = (BlockState)state.func_206870_a((Property)CUSHION, (Comparable)Integer.valueOf(wool));
                worldIn.func_180501_a(pos, blockstate, 16);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        if (helditem.func_77973_b() == Items.field_151097_aZ) {
            BlockState blockstate = (BlockState)state.func_206870_a((Property)CUSHION, (Comparable)Integer.valueOf(0));
            worldIn.func_180501_a(pos, blockstate, 16);
            return ActionResultType.SUCCESS;
        }
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            return SeatEntity.create(worldIn, pos.func_177977_b(), 0.4, player);
        }
        return SeatEntity.create(worldIn, pos, 0.4, player);
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("\u00a79Add Cushion with Wool"));
        tooltip.add((ITextComponent)new StringTextComponent("\u00a7cRemove with Shears"));
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

