/*
 * Decompiled with CFR 0.152.
 */
package com.sirdizarm.tablechair.objects.blocks;

import com.sirdizarm.tablechair.init.BlockInit;
import com.sirdizarm.tablechair.init.ItemInit;
import com.sirdizarm.tablechair.objects.blocks.BlockSawdust;
import java.util.List;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockLogCutting
extends RotatedPillarBlock {
    public static final IntegerProperty LAYERS = IntegerProperty.func_177719_a((String)"layers", (int)1, (int)8);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208148_A;
    protected static final VoxelShape[] SHAPES_Y = new VoxelShape[]{VoxelShapes.func_197880_a(), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    protected static final VoxelShape[] SHAPES_Z = new VoxelShape[]{VoxelShapes.func_197880_a(), Block.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0), Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0), Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0), Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0), Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0), Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    protected static final VoxelShape[] SHAPES_X = new VoxelShape[]{VoxelShapes.func_197880_a(), Block.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0), Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    protected static final VoxelShape FULLBLOCK = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockLogCutting(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.Y)).func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(8)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT compoundnbt = stack.func_179543_a("BlockStateTag");
        if (compoundnbt != null) {
            String layers = compoundnbt.func_74779_i("layers");
            int i = Integer.parseInt(layers);
            if (i != 0) {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a7e" + layers + " x " + layers));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a7e8 x 8"));
            }
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a7e8 x 8"));
        }
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    public void onRightClickThingy(World worldIn, BlockPos pos, BlockState state) {
        BlockState thisState = worldIn.func_180495_p(pos);
        if (thisState.func_177230_c() == this && (Integer)thisState.func_177229_b((IProperty)LAYERS) != 1) {
            int layers = (Integer)thisState.func_177229_b((IProperty)LAYERS) - 1;
            worldIn.func_180501_a(pos, (BlockState)thisState.func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(layers)), 2);
        } else if ((Integer)thisState.func_177229_b((IProperty)LAYERS) == 1) {
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184614_ca();
        if (player.func_175142_cm() && stack.func_77973_b() == ItemInit.PLANE.get()) {
            if (worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            Direction direction = player.func_174811_aO();
            int random = worldIn.field_73012_v.nextInt(5);
            switch (random) {
                case 1: {
                    direction = player.func_174811_aO().func_176735_f();
                    break;
                }
                case 2: {
                    direction = player.func_174811_aO().func_176746_e();
                    break;
                }
                case 3: {
                    direction = player.func_174811_aO().func_176735_f();
                    break;
                }
                case 4: {
                    direction = player.func_174811_aO();
                    break;
                }
                default: {
                    direction = player.func_174811_aO().func_176746_e();
                }
            }
            BlockPos dust_pos = pos.func_177972_a(direction);
            BlockState other = worldIn.func_180495_p(dust_pos);
            Block block = other.func_177230_c();
            BlockPos down_pos = pos.func_177977_b().func_177972_a(direction);
            BlockState down_other = worldIn.func_180495_p(down_pos);
            Block down_block = down_other.func_177230_c();
            if (other == Blocks.field_150350_a.func_176223_P() && (Integer)state.func_177229_b((IProperty)LAYERS) != 0) {
                if (down_block instanceof BlockSawdust || down_block instanceof AirBlock && (Integer)state.func_177229_b((IProperty)LAYERS) != 0) {
                    this.onRightClickThingy(worldIn, pos, state);
                    BlockLogCutting.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)ItemInit.SAWDUST.get(), 1));
                } else {
                    this.onRightClickThingy(worldIn, pos, state);
                    worldIn.func_175656_a(dust_pos, (BlockState)((Block)BlockInit.SAWDUST_LAYER.get()).func_176223_P().func_206870_a((IProperty)BlockSawdust.LAYERS, (Comparable)Integer.valueOf(1)));
                }
                return ActionResultType.SUCCESS;
            }
            if (block == BlockInit.SAWDUST_LAYER.get() && (Integer)other.func_177229_b((IProperty)BlockSawdust.LAYERS) != 8) {
                this.onRightClickThingy(worldIn, pos, state);
                worldIn.func_175656_a(dust_pos, (BlockState)((Block)BlockInit.SAWDUST_LAYER.get()).func_176223_P().func_206870_a((IProperty)BlockSawdust.LAYERS, (Comparable)Integer.valueOf((Integer)other.func_177229_b((IProperty)BlockSawdust.LAYERS) + 1)));
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(AXIS, (Comparable)context.func_196000_l().func_176740_k())).func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(8));
    }

    private VoxelShape getShapeFromState(BlockState state) {
        if (state.func_177229_b(AXIS) == Direction.Axis.X) {
            return SHAPES_X[(Integer)state.func_177229_b((IProperty)LAYERS)];
        }
        if (state.func_177229_b(AXIS) == Direction.Axis.Y) {
            return SHAPES_Y[(Integer)state.func_177229_b((IProperty)LAYERS)];
        }
        if (state.func_177229_b(AXIS) == Direction.Axis.Z) {
            return SHAPES_Z[(Integer)state.func_177229_b((IProperty)LAYERS)];
        }
        return SHAPES_X[(Integer)state.func_177229_b((IProperty)LAYERS)];
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShapeFromState(state);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShapeFromState(state);
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AXIS, LAYERS});
    }
}

