/*
 * Decompiled with CFR 0.152.
 */
package com.sirdizarm.tablechair.objects.blocks;

import com.google.common.collect.Sets;
import com.sirdizarm.tablechair.init.ItemInit;
import com.sirdizarm.tablechair.init.TileEntityTypes;
import com.sirdizarm.tablechair.objects.items.ItemPlate;
import com.sirdizarm.tablechair.objects.items.ItemTablecloth;
import com.sirdizarm.tablechair.tileentity.TableTileEntity;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockTable
extends Block {
    public static final IntegerProperty VARIANTS = IntegerProperty.func_177719_a((String)"variants", (int)0, (int)18);
    public static final IntegerProperty TABLECLOTH = IntegerProperty.func_177719_a((String)"tablecloth", (int)0, (int)33);
    public static final BooleanProperty LIT = BooleanProperty.func_177716_a((String)"lit");
    public static final BooleanProperty MISC = BooleanProperty.func_177716_a((String)"misc");
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static Set<Item> tabletype = Sets.newHashSet((Object[])new Item[]{Items.field_221590_r, Items.field_221588_p, Items.field_221591_s, Items.field_221589_q, Items.field_221586_n, Items.field_221587_o, Items.field_221698_bk, Items.field_221696_bj, Items.field_221732_cb, Items.field_221739_dF, Items.field_221858_em, Items.field_221654_ao, Items.field_221558_K, Items.field_221556_I, Items.field_221559_L, Items.field_221557_J, Items.field_221554_G, Items.field_221555_H});
    private static Set<Item> woolcolors = Sets.newHashSet((Object[])new Item[]{Items.field_221618_aT, Items.field_221614_aP, Items.field_221615_aQ, Items.field_221612_aN, Items.field_221610_aL, Items.field_221616_aR, Items.field_221606_aH, Items.field_221611_aM, Items.field_221608_aJ, Items.field_221605_aG, Items.field_221604_aF, Items.field_221609_aK, Items.field_221613_aO, Items.field_221617_aS, Items.field_221603_aE, Items.field_221607_aI});
    private static Set<Item> flowers = Sets.newHashSet((Object[])new Item[]{Items.field_221619_aU, Items.field_221620_aV, Items.field_221621_aW, Items.field_221622_aX, Items.field_221623_aY, Items.field_221624_aZ, Items.field_221678_ba, Items.field_221682_bc, Items.field_221680_bb, Items.field_221684_bd, Items.field_221686_be, Items.field_221688_bf, Items.field_221690_bg, Items.field_221599_aA, Items.field_221694_bi, Items.field_221692_bh});
    private static Set<Item> blacklist = Sets.newHashSet((Object[])new Item[]{Items.field_151097_aZ});

    public BlockTable(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)VARIANTS, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)TABLECLOTH, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)MISC, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityTypes.TABLE_TE.get()).func_200968_a();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public int func_149750_m(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? super.func_149750_m(state) : 0;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        ItemStack stack = player.func_184614_ca();
        boolean ctrl = player.func_225608_bj_();
        Direction i = player.func_174811_aO().func_176734_d();
        if (tileentity instanceof TableTileEntity) {
            TableTileEntity tabletileentity = (TableTileEntity)tileentity;
            boolean plate0 = tabletileentity.getInventory().getStackInSlot(4).func_77973_b() instanceof ItemPlate;
            boolean plate1 = tabletileentity.getInventory().getStackInSlot(5).func_77973_b() instanceof ItemPlate;
            boolean plate2 = tabletileentity.getInventory().getStackInSlot(6).func_77973_b() instanceof ItemPlate;
            boolean plate3 = tabletileentity.getInventory().getStackInSlot(7).func_77973_b() instanceof ItemPlate;
            ItemStack helditem = player.func_184586_b(handIn);
            boolean plates = helditem.func_77973_b() instanceof ItemPlate;
            if (!worldIn.field_72995_K) {
                if (flowers.contains(helditem.func_77973_b())) {
                    if (i == Direction.NORTH && !ctrl && tabletileentity.getInventory().getStackInSlot(0).func_190926_b() && tabletileentity.getInventory().getStackInSlot(4).func_190926_b()) {
                        ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 4);
                        helditem.func_190918_g(1);
                        return ActionResultType.SUCCESS;
                    }
                    if (i == Direction.SOUTH && !ctrl && tabletileentity.getInventory().getStackInSlot(1).func_190926_b() && tabletileentity.getInventory().getStackInSlot(5).func_190926_b()) {
                        ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 5);
                        helditem.func_190918_g(1);
                        return ActionResultType.SUCCESS;
                    }
                    if (i == Direction.WEST && !ctrl && tabletileentity.getInventory().getStackInSlot(2).func_190926_b() && tabletileentity.getInventory().getStackInSlot(6).func_190926_b()) {
                        ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 6);
                        helditem.func_190918_g(1);
                        return ActionResultType.SUCCESS;
                    }
                    if (i == Direction.EAST && !ctrl && tabletileentity.getInventory().getStackInSlot(3).func_190926_b() && tabletileentity.getInventory().getStackInSlot(7).func_190926_b()) {
                        ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 7);
                        helditem.func_190918_g(1);
                        return ActionResultType.SUCCESS;
                    }
                } else {
                    if (tabletype.contains(helditem.func_77973_b()) && (Integer)state.func_177229_b((IProperty)VARIANTS) == 0) {
                        int tabletype = 0;
                        if (helditem.func_77973_b() == Items.field_221590_r) {
                            tabletype = 1;
                        }
                        if (helditem.func_77973_b() == Items.field_221588_p) {
                            tabletype = 2;
                        }
                        if (helditem.func_77973_b() == Items.field_221591_s) {
                            tabletype = 3;
                        }
                        if (helditem.func_77973_b() == Items.field_221589_q) {
                            tabletype = 4;
                        }
                        if (helditem.func_77973_b() == Items.field_221586_n) {
                            tabletype = 5;
                        }
                        if (helditem.func_77973_b() == Items.field_221587_o) {
                            tabletype = 6;
                        }
                        if (helditem.func_77973_b() == Items.field_221698_bk) {
                            tabletype = 7;
                        }
                        if (helditem.func_77973_b() == Items.field_221696_bj) {
                            tabletype = 8;
                        }
                        if (helditem.func_77973_b() == Items.field_221732_cb) {
                            tabletype = 9;
                        }
                        if (helditem.func_77973_b() == Items.field_221739_dF) {
                            tabletype = 10;
                        }
                        if (helditem.func_77973_b() == Items.field_221858_em) {
                            tabletype = 11;
                        }
                        if (helditem.func_77973_b() == Items.field_221654_ao) {
                            tabletype = 12;
                        }
                        if (helditem.func_77973_b() == Items.field_221558_K) {
                            tabletype = 13;
                        }
                        if (helditem.func_77973_b() == Items.field_221556_I) {
                            tabletype = 14;
                        }
                        if (helditem.func_77973_b() == Items.field_221559_L) {
                            tabletype = 15;
                        }
                        if (helditem.func_77973_b() == Items.field_221557_J) {
                            tabletype = 16;
                        }
                        if (helditem.func_77973_b() == Items.field_221554_G) {
                            tabletype = 17;
                        }
                        if (helditem.func_77973_b() == Items.field_221555_H) {
                            tabletype = 18;
                        }
                        BlockState blockstate = (BlockState)state.func_206870_a((IProperty)VARIANTS, (Comparable)Integer.valueOf(tabletype));
                        ((TableTileEntity)tileentity).variant(tabletype);
                        worldIn.func_180501_a(pos, blockstate, 16);
                        return ActionResultType.SUCCESS;
                    }
                    if (helditem.func_77973_b() == Items.field_222111_pQ) {
                        if (i == Direction.NORTH && !ctrl && tabletileentity.getInventory().getStackInSlot(0).func_190926_b() && tabletileentity.getInventory().getStackInSlot(4).func_190926_b()) {
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 4);
                            ((TableTileEntity)tileentity).checkLantern();
                            helditem.func_190918_g(1);
                            return ActionResultType.SUCCESS;
                        }
                        if (i == Direction.SOUTH && !ctrl && tabletileentity.getInventory().getStackInSlot(1).func_190926_b() && tabletileentity.getInventory().getStackInSlot(5).func_190926_b()) {
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 5);
                            ((TableTileEntity)tileentity).checkLantern();
                            helditem.func_190918_g(1);
                            return ActionResultType.SUCCESS;
                        }
                        if (i == Direction.WEST && !ctrl && tabletileentity.getInventory().getStackInSlot(2).func_190926_b() && tabletileentity.getInventory().getStackInSlot(6).func_190926_b()) {
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 6);
                            ((TableTileEntity)tileentity).checkLantern();
                            helditem.func_190918_g(1);
                            return ActionResultType.SUCCESS;
                        }
                        if (i == Direction.EAST && !ctrl && tabletileentity.getInventory().getStackInSlot(3).func_190926_b() && tabletileentity.getInventory().getStackInSlot(7).func_190926_b()) {
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 7);
                            ((TableTileEntity)tileentity).checkLantern();
                            helditem.func_190918_g(1);
                            return ActionResultType.SUCCESS;
                        }
                    } else {
                        if (!(i != Direction.NORTH || ctrl || !plate0 || helditem.func_190926_b() || woolcolors.contains(helditem.func_77973_b()) || blacklist.contains(helditem.func_77973_b()) || !tabletileentity.getInventory().getStackInSlot(0).func_190926_b() || plates)) {
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 0);
                            helditem.func_190918_g(1);
                            return ActionResultType.SUCCESS;
                        }
                        if (!(i != Direction.SOUTH || ctrl || !plate1 || helditem.func_190926_b() || woolcolors.contains(helditem.func_77973_b()) || blacklist.contains(helditem.func_77973_b()) || !tabletileentity.getInventory().getStackInSlot(1).func_190926_b() || plates)) {
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 1);
                            helditem.func_190918_g(1);
                            return ActionResultType.SUCCESS;
                        }
                        if (!(i != Direction.WEST || ctrl || !plate2 || helditem.func_190926_b() || woolcolors.contains(helditem.func_77973_b()) || blacklist.contains(helditem.func_77973_b()) || !tabletileentity.getInventory().getStackInSlot(2).func_190926_b() || plates)) {
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 2);
                            helditem.func_190918_g(1);
                            return ActionResultType.SUCCESS;
                        }
                        if (!(i != Direction.EAST || ctrl || !plate3 || helditem.func_190926_b() || woolcolors.contains(helditem.func_77973_b()) || blacklist.contains(helditem.func_77973_b()) || !tabletileentity.getInventory().getStackInSlot(3).func_190926_b() || plates)) {
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 3);
                            helditem.func_190918_g(1);
                            return ActionResultType.SUCCESS;
                        }
                    }
                }
                if (stack.func_77973_b() instanceof ItemPlate && !ctrl) {
                    switch (i) {
                        case NORTH: {
                            if (plate0 || !tabletileentity.getInventory().getStackInSlot(4).func_190926_b()) break;
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 4);
                            stack.func_190918_g(1);
                            break;
                        }
                        case SOUTH: {
                            if (plate1 || !tabletileentity.getInventory().getStackInSlot(5).func_190926_b()) break;
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 5);
                            stack.func_190918_g(1);
                            break;
                        }
                        case WEST: {
                            if (plate2 || !tabletileentity.getInventory().getStackInSlot(6).func_190926_b()) break;
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 6);
                            stack.func_190918_g(1);
                            break;
                        }
                        case EAST: {
                            if (plate3 || !tabletileentity.getInventory().getStackInSlot(7).func_190926_b()) break;
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 7);
                            stack.func_190918_g(1);
                        }
                    }
                    return ActionResultType.SUCCESS;
                }
                if (flowers.contains(stack.func_77973_b()) && !ctrl) {
                    switch (i) {
                        case NORTH: {
                            if (plate0 || !tabletileentity.getInventory().getStackInSlot(4).func_190926_b()) break;
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 4);
                            stack.func_190918_g(1);
                            break;
                        }
                        case SOUTH: {
                            if (plate1 || !tabletileentity.getInventory().getStackInSlot(5).func_190926_b()) break;
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 5);
                            stack.func_190918_g(1);
                            break;
                        }
                        case WEST: {
                            if (plate2 || !tabletileentity.getInventory().getStackInSlot(6).func_190926_b()) break;
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 6);
                            stack.func_190918_g(1);
                            break;
                        }
                        case EAST: {
                            if (plate3 || !tabletileentity.getInventory().getStackInSlot(7).func_190926_b()) break;
                            ((TableTileEntity)tileentity).addItem(helditem.func_77946_l(), 7);
                            stack.func_190918_g(1);
                        }
                    }
                    return ActionResultType.SUCCESS;
                }
                if (woolcolors.contains(stack.func_77973_b()) && !ctrl) {
                    int wool = 0;
                    if (helditem.func_77973_b() == Items.field_221618_aT) {
                        wool = 1;
                    }
                    if (helditem.func_77973_b() == Items.field_221614_aP) {
                        wool = 2;
                    }
                    if (helditem.func_77973_b() == Items.field_221615_aQ) {
                        wool = 3;
                    }
                    if (helditem.func_77973_b() == Items.field_221612_aN) {
                        wool = 4;
                    }
                    if (helditem.func_77973_b() == Items.field_221610_aL) {
                        wool = 5;
                    }
                    if (helditem.func_77973_b() == Items.field_221616_aR) {
                        wool = 6;
                    }
                    if (helditem.func_77973_b() == Items.field_221606_aH) {
                        wool = 7;
                    }
                    if (helditem.func_77973_b() == Items.field_221611_aM) {
                        wool = 8;
                    }
                    if (helditem.func_77973_b() == Items.field_221608_aJ) {
                        wool = 9;
                    }
                    if (helditem.func_77973_b() == Items.field_221605_aG) {
                        wool = 10;
                    }
                    if (helditem.func_77973_b() == Items.field_221604_aF) {
                        wool = 11;
                    }
                    if (helditem.func_77973_b() == Items.field_221609_aK) {
                        wool = 12;
                    }
                    if (helditem.func_77973_b() == Items.field_221613_aO) {
                        wool = 13;
                    }
                    if (helditem.func_77973_b() == Items.field_221617_aS) {
                        wool = 14;
                    }
                    if (helditem.func_77973_b() == Items.field_221603_aE) {
                        wool = 15;
                    }
                    if (helditem.func_77973_b() == Items.field_221607_aI) {
                        wool = 16;
                    }
                    BlockState blockstate = (BlockState)state.func_206870_a((IProperty)TABLECLOTH, (Comparable)Integer.valueOf(wool));
                    ((TableTileEntity)tileentity).addTablecloth(wool);
                    worldIn.func_180501_a(pos, blockstate, 16);
                    return ActionResultType.SUCCESS;
                }
                if (stack.func_77973_b() instanceof ItemTablecloth && player.func_184592_cb().func_190926_b()) {
                    int wool = 0;
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_BLACK.get()).getItem()) {
                        wool = 17;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_BLUE.get()).getItem()) {
                        wool = 18;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_BROWN.get()).getItem()) {
                        wool = 19;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_CYAN.get()).getItem()) {
                        wool = 20;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_GRAY.get()).getItem()) {
                        wool = 21;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_GREEN.get()).getItem()) {
                        wool = 22;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_LIGHT_BLUE.get()).getItem()) {
                        wool = 23;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_LIGHT_GRAY.get()).getItem()) {
                        wool = 24;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_LIME.get()).getItem()) {
                        wool = 25;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_MAGENTA.get()).getItem()) {
                        wool = 26;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_ORANGE.get()).getItem()) {
                        wool = 27;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_PINK.get()).getItem()) {
                        wool = 28;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_PURPLE.get()).getItem()) {
                        wool = 29;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_RED.get()).getItem()) {
                        wool = 30;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_WHITE.get()).getItem()) {
                        wool = 31;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_YELLOW.get()).getItem()) {
                        wool = 32;
                    }
                    if (helditem.func_77973_b() == ((Item)ItemInit.TABLECLOTH_TRADERS.get()).getItem()) {
                        wool = 33;
                    }
                    ((TableTileEntity)tileentity).addTablecloth(wool);
                    worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)TABLECLOTH, (Comparable)Integer.valueOf(wool)), 16);
                    return ActionResultType.SUCCESS;
                }
                if (player.func_184592_cb().func_77973_b() == Items.field_151055_y) {
                    worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)MISC, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)MISC) == false)), 16);
                    return ActionResultType.SUCCESS;
                }
                if (helditem.func_77973_b() == Items.field_151097_aZ) {
                    BlockState blockstate = (BlockState)state.func_206870_a((IProperty)TABLECLOTH, (Comparable)Integer.valueOf(0));
                    ((TableTileEntity)tileentity).addTablecloth(0);
                    worldIn.func_180501_a(pos, blockstate, 16);
                    return ActionResultType.SUCCESS;
                }
                if (player.func_184614_ca().func_190926_b() && player.func_184218_aH()) {
                    switch (i) {
                        case NORTH: {
                            if (!plate0 || tabletileentity.getInventory().getStackInSlot(0).func_190926_b()) break;
                            ((TableTileEntity)tileentity).checkInv(player, 0);
                            break;
                        }
                        case SOUTH: {
                            if (!plate1 || tabletileentity.getInventory().getStackInSlot(1).func_190926_b()) break;
                            ((TableTileEntity)tileentity).checkInv(player, 1);
                            break;
                        }
                        case WEST: {
                            if (!plate2 || tabletileentity.getInventory().getStackInSlot(2).func_190926_b()) break;
                            ((TableTileEntity)tileentity).checkInv(player, 2);
                            break;
                        }
                        case EAST: {
                            if (!plate3 || tabletileentity.getInventory().getStackInSlot(3).func_190926_b()) break;
                            ((TableTileEntity)tileentity).checkInv(player, 3);
                            break;
                        }
                    }
                }
                if (ctrl && player.func_184614_ca().func_190926_b() && !player.func_184218_aH()) {
                    switch (i) {
                        case NORTH: {
                            if (!tabletileentity.getInventory().getStackInSlot(0).func_190926_b()) {
                                ((TableTileEntity)tileentity).checkInv(player, 0);
                            }
                            if (tabletileentity.getInventory().getStackInSlot(4).func_190926_b()) break;
                            ((TableTileEntity)tileentity).checkInv(player, 4);
                            ((TableTileEntity)tileentity).checkLantern();
                            break;
                        }
                        case SOUTH: {
                            if (!tabletileentity.getInventory().getStackInSlot(1).func_190926_b()) {
                                ((TableTileEntity)tileentity).checkInv(player, 1);
                            }
                            if (tabletileentity.getInventory().getStackInSlot(5).func_190926_b()) break;
                            ((TableTileEntity)tileentity).checkInv(player, 5);
                            ((TableTileEntity)tileentity).checkLantern();
                            break;
                        }
                        case WEST: {
                            if (!tabletileentity.getInventory().getStackInSlot(2).func_190926_b()) {
                                ((TableTileEntity)tileentity).checkInv(player, 2);
                            }
                            if (tabletileentity.getInventory().getStackInSlot(6).func_190926_b()) break;
                            ((TableTileEntity)tileentity).checkInv(player, 6);
                            ((TableTileEntity)tileentity).checkLantern();
                            break;
                        }
                        case EAST: {
                            if (!tabletileentity.getInventory().getStackInSlot(3).func_190926_b()) {
                                ((TableTileEntity)tileentity).checkInv(player, 3);
                            }
                            if (tabletileentity.getInventory().getStackInSlot(7).func_190926_b()) break;
                            ((TableTileEntity)tileentity).checkInv(player, 7);
                            ((TableTileEntity)tileentity).checkLantern();
                            break;
                        }
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TableTileEntity) {
                for (int i = 0; i < ((TableTileEntity)tileentity).getInventory().getSlots(); ++i) {
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)((TableTileEntity)tileentity).getInventory().getStackInSlot(i));
                }
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TableTileEntity) {
            ((TableTileEntity)tileentity).addTablecloth(this.getWoolVariant(stack));
            ((TableTileEntity)tileentity).variant(this.getTableVariant(stack));
        }
        worldIn.func_180501_a(pos, (BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)VARIANTS, (Comparable)Integer.valueOf(this.getTableVariant(stack)))).func_206870_a((IProperty)TABLECLOTH, (Comparable)Integer.valueOf(this.getWoolVariant(stack)))).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(this.getLit(stack))), 3);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{VARIANTS, TABLECLOTH, LIT, MISC});
    }

    public int getTableVariant(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        CompoundNBT nbt2 = stack.func_179543_a("BlockEntityTag");
        CompoundNBT tag = stack.func_77978_p();
        String variants = "0";
        int switch_output = 0;
        if (nbt2 != null) {
            if (nbt2.func_74762_e("variants") != 0) {
                switch_output = nbt2.func_74762_e("variants");
            }
        } else if (tag != null) {
            if (nbt.func_74762_e("variants") != 0) {
                switch_output = nbt.func_74762_e("variants");
            } else {
                switch (variants = tag.func_74775_l("BlockStateTag").func_74779_i("variants")) {
                    case "1": {
                        switch_output = 1;
                        break;
                    }
                    case "2": {
                        switch_output = 2;
                        break;
                    }
                    case "3": {
                        switch_output = 3;
                        break;
                    }
                    case "4": {
                        switch_output = 4;
                        break;
                    }
                    case "5": {
                        switch_output = 5;
                        break;
                    }
                    case "6": {
                        switch_output = 6;
                        break;
                    }
                    case "7": {
                        switch_output = 7;
                        break;
                    }
                    case "8": {
                        switch_output = 8;
                        break;
                    }
                    case "9": {
                        switch_output = 9;
                        break;
                    }
                    case "10": {
                        switch_output = 10;
                        break;
                    }
                    case "11": {
                        switch_output = 11;
                        break;
                    }
                    case "12": {
                        switch_output = 12;
                        break;
                    }
                    case "13": {
                        switch_output = 13;
                        break;
                    }
                    case "14": {
                        switch_output = 14;
                        break;
                    }
                    case "15": {
                        switch_output = 15;
                        break;
                    }
                    case "16": {
                        switch_output = 16;
                        break;
                    }
                    case "17": {
                        switch_output = 17;
                        break;
                    }
                    case "18": {
                        switch_output = 18;
                        break;
                    }
                    default: {
                        switch_output = 0;
                    }
                }
            }
        }
        return switch_output;
    }

    public int getWoolVariant(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        CompoundNBT nbt2 = stack.func_179543_a("BlockEntityTag");
        CompoundNBT tag = stack.func_77978_p();
        String variants = "0";
        int switch_output = 0;
        if (nbt2 != null) {
            if (nbt2.func_74762_e("tablecloth") != 0) {
                switch_output = nbt2.func_74762_e("tablecloth");
            }
        } else if (tag != null) {
            if (nbt.func_74762_e("tablecloth") != 0) {
                switch_output = nbt.func_74762_e("tablecloth");
            } else {
                switch (variants = tag.func_74775_l("BlockStateTag").func_74779_i("tablecloth")) {
                    case "1": {
                        switch_output = 1;
                        break;
                    }
                    case "2": {
                        switch_output = 2;
                        break;
                    }
                    case "3": {
                        switch_output = 3;
                        break;
                    }
                    case "4": {
                        switch_output = 4;
                        break;
                    }
                    case "5": {
                        switch_output = 5;
                        break;
                    }
                    case "6": {
                        switch_output = 6;
                        break;
                    }
                    case "7": {
                        switch_output = 7;
                        break;
                    }
                    case "8": {
                        switch_output = 8;
                        break;
                    }
                    case "9": {
                        switch_output = 9;
                        break;
                    }
                    case "10": {
                        switch_output = 10;
                        break;
                    }
                    case "11": {
                        switch_output = 11;
                        break;
                    }
                    case "12": {
                        switch_output = 12;
                        break;
                    }
                    case "13": {
                        switch_output = 13;
                        break;
                    }
                    case "14": {
                        switch_output = 14;
                        break;
                    }
                    case "15": {
                        switch_output = 15;
                        break;
                    }
                    case "16": {
                        switch_output = 16;
                        break;
                    }
                    case "17": {
                        switch_output = 17;
                        break;
                    }
                    case "18": {
                        switch_output = 18;
                        break;
                    }
                    case "19": {
                        switch_output = 19;
                        break;
                    }
                    case "20": {
                        switch_output = 20;
                        break;
                    }
                    case "21": {
                        switch_output = 21;
                        break;
                    }
                    case "22": {
                        switch_output = 22;
                        break;
                    }
                    case "23": {
                        switch_output = 23;
                        break;
                    }
                    case "24": {
                        switch_output = 24;
                        break;
                    }
                    case "25": {
                        switch_output = 25;
                        break;
                    }
                    case "26": {
                        switch_output = 26;
                        break;
                    }
                    case "27": {
                        switch_output = 27;
                        break;
                    }
                    case "28": {
                        switch_output = 28;
                        break;
                    }
                    case "29": {
                        switch_output = 29;
                        break;
                    }
                    case "30": {
                        switch_output = 30;
                        break;
                    }
                    case "31": {
                        switch_output = 31;
                        break;
                    }
                    case "32": {
                        switch_output = 32;
                        break;
                    }
                    case "33": {
                        switch_output = 33;
                        break;
                    }
                    default: {
                        switch_output = 0;
                    }
                }
            }
        }
        return switch_output;
    }

    public boolean getLit(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        CompoundNBT nbt2 = stack.func_179543_a("BlockEntityTag");
        CompoundNBT tag = stack.func_77978_p();
        String variants = "lit";
        boolean switch_output = false;
        if (nbt2 != null) {
            if (nbt2.func_74767_n("lit")) {
                switch_output = nbt2.func_74767_n("lit");
            }
        } else if (tag != null) {
            if (nbt.func_74767_n("lit")) {
                switch_output = nbt.func_74767_n("lit");
            } else {
                switch (variants = tag.func_74775_l("BlockStateTag").func_74779_i("lit")) {
                    case "true": {
                        switch_output = true;
                        break;
                    }
                    case "false": {
                        switch_output = false;
                        break;
                    }
                    default: {
                        switch_output = false;
                    }
                }
            }
        }
        return switch_output;
    }
}

