/*
 * Decompiled with CFR 0.152.
 */
package com.sirdizarm.tablechair.tileentity;

import com.sirdizarm.tablechair.init.TileEntityTypes;
import com.sirdizarm.tablechair.objects.blocks.BlockTable;
import com.sirdizarm.tablechair.util.CustomItemHandler;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class TableTileEntity
extends TileEntity {
    private int tableCloth;
    private int variant;
    private boolean lit = false;
    private CustomItemHandler inventory = new CustomItemHandler(8, new ItemStack[0]);

    public TableTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TableTileEntity() {
        this((TileEntityType)TileEntityTypes.TABLE_TE.get());
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.tableCloth = compound.func_74762_e("tablecloth");
        this.variant = compound.func_74762_e("variants");
        this.lit = compound.func_74767_n("lit");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        compound.func_74768_a("tablecloth", this.tableCloth);
        compound.func_74768_a("variants", this.variant);
        compound.func_74757_a("lit", this.lit);
        return compound;
    }

    public final CustomItemHandler getInventory() {
        return this.inventory;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundNBT nbt) {
        this.func_145839_a(nbt);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.inventory));
    }

    public void checkInv(PlayerEntity player, int slot) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (!player.field_71071_by.func_70441_a(stack)) {
                player.func_71019_a(stack, false);
            }
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public void addTablecloth(int tableclothColor) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.tableCloth = tableclothColor;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public void variant(int tableVariant) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.variant = tableVariant;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public void removeTablecloth() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.tableCloth = 0;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public void checkLantern() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            boolean lit = false;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack inSlot = this.inventory.getStackInSlot(i);
                if (inSlot.func_77973_b() != Items.field_222111_pQ) continue;
                lit = true;
            }
            this.lit = lit;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)BlockTable.LIT, (Comparable)Boolean.valueOf(lit)));
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public boolean addItem(ItemStack itemStackIn, int slot) {
        ItemStack itemstack;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && (itemstack = this.inventory.getStackInSlot(slot)).func_190926_b()) {
            this.inventory.setStackInSlot(slot, itemStackIn.func_77979_a(1));
            this.checkLantern();
            return true;
        }
        return false;
    }

    public void removeItem(int slot) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
            this.checkLantern();
        }
    }

    public int checkTableCloth() {
        return this.tableCloth;
    }

    public int checkTableVariant() {
        return this.variant;
    }
}

