/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.corruption;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.corruption.CorruptionMod;
import net.mcreator.corruption.CorruptionModVariables;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class CorruptionModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public CorruptionModElements() {
        sounds.put(new ResourceLocation("corruption", "sound_silent"), new SoundEvent(new ResourceLocation("corruption", "sound_silent")));
        sounds.put(new ResourceLocation("corruption", "sound_corruptor_idle"), new SoundEvent(new ResourceLocation("corruption", "sound_corruptor_idle")));
        sounds.put(new ResourceLocation("corruption", "sound_wraith_idle"), new SoundEvent(new ResourceLocation("corruption", "sound_wraith_idle")));
        sounds.put(new ResourceLocation("corruption", "sound_demon_eye_shoot"), new SoundEvent(new ResourceLocation("corruption", "sound_demon_eye_shoot")));
        sounds.put(new ResourceLocation("corruption", "sound_powder_main"), new SoundEvent(new ResourceLocation("corruption", "sound_powder_main")));
        sounds.put(new ResourceLocation("corruption", "sound_abyss_watcher_summon"), new SoundEvent(new ResourceLocation("corruption", "sound_abyss_watcher_summon")));
        sounds.put(new ResourceLocation("corruption", "sound_eye_of_flesh_summon"), new SoundEvent(new ResourceLocation("corruption", "sound_eye_of_flesh_summon")));
        sounds.put(new ResourceLocation("corruption", "sound_holy_protection"), new SoundEvent(new ResourceLocation("corruption", "sound_holy_protection")));
        sounds.put(new ResourceLocation("corruption", "sound_abyss_watcher_death"), new SoundEvent(new ResourceLocation("corruption", "sound_abyss_watcher_death")));
        sounds.put(new ResourceLocation("corruption", "sound_abyss_watcher_idle"), new SoundEvent(new ResourceLocation("corruption", "sound_abyss_watcher_idle")));
        sounds.put(new ResourceLocation("corruption", "sound_eye_of_flesh_death"), new SoundEvent(new ResourceLocation("corruption", "sound_eye_of_flesh_death")));
        sounds.put(new ResourceLocation("corruption", "sound_eye_of_flesh_idle"), new SoundEvent(new ResourceLocation("corruption", "sound_eye_of_flesh_idle")));
        sounds.put(new ResourceLocation("corruption", "sound_musket_shoot"), new SoundEvent(new ResourceLocation("corruption", "sound_musket_shoot")));
        sounds.put(new ResourceLocation("corruption", "sound_demon_eye_idle"), new SoundEvent(new ResourceLocation("corruption", "sound_demon_eye_idle")));
        sounds.put(new ResourceLocation("corruption", "sound_hell_wraith_idle"), new SoundEvent(new ResourceLocation("corruption", "sound_hell_wraith_idle")));
        sounds.put(new ResourceLocation("corruption", "sound_corrupt_worm_idle"), new SoundEvent(new ResourceLocation("corruption", "sound_corrupt_worm_idle")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("corruption").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
        MinecraftForge.EVENT_BUS.register((Object)new CorruptionModVariables(this));
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        CorruptionMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final CorruptionModElements elements;
        protected final int sortid;

        public ModElement(CorruptionModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

