/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.corruption.block;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class ChunkLoaderData
extends WorldSavedData {
    private static final String DATA_ID = "corruption_chunkLoaderData";
    private static final int MAX_CHUNKS = 32;
    private static final int MAX_BUFFER_SIZE = 1024;
    private boolean initialized;
    private Long2IntMap loadersPerChunkCount = new Long2IntOpenHashMap();
    private LinkedList<Long> loaderPositions;
    private LinkedList<Long> positionBuffer;

    public ChunkLoaderData() {
        this(DATA_ID);
    }

    public ChunkLoaderData(String name) {
        super(name);
        this.loadersPerChunkCount.defaultReturnValue(0);
        this.loaderPositions = new LinkedList();
        this.positionBuffer = new LinkedList();
        this.initialized = false;
    }

    public static ChunkLoaderData get(ServerWorld world) {
        return (ChunkLoaderData)world.func_217481_x().func_215752_a(ChunkLoaderData::new, DATA_ID);
    }

    public void init(ServerWorld world) {
        if (!this.initialized) {
            this.initialized = true;
            LongIterator longIterator = this.loadersPerChunkCount.keySet().iterator();
            while (longIterator.hasNext()) {
                long chunkL = (Long)longIterator.next();
                world.func_217458_b(ChunkPos.func_212578_a((long)chunkL), ChunkPos.func_212579_b((long)chunkL), true);
            }
        }
    }

    public void add(ServerWorld world, BlockPos pos) {
        long posL = pos.func_218275_a();
        if (!this.loaderPositions.contains(posL) && !this.positionBuffer.contains(posL)) {
            int chunkZ;
            int chunkX;
            long chunkL;
            int count;
            if (this.loaderPositions.size() >= 32) {
                this.remove(world, BlockPos.func_218283_e((long)this.loaderPositions.getFirst()), false);
            }
            if (this.positionBuffer.size() >= 1024) {
                this.positionBuffer.removeFirst();
            }
            if ((count = this.loadersPerChunkCount.get(chunkL = ChunkPos.func_77272_a((int)(chunkX = pos.func_177958_n() >> 4), (int)(chunkZ = pos.func_177952_p() >> 4)))) == 0) {
                world.func_217458_b(chunkX, chunkZ, true);
            }
            this.loadersPerChunkCount.put(chunkL, ++count);
            this.loaderPositions.add(posL);
            this.positionBuffer.add(posL);
            this.func_76185_a();
        }
    }

    public void remove(ServerWorld world, BlockPos pos, boolean clearBuffer) {
        long posL = pos.func_218275_a();
        if (clearBuffer) {
            this.positionBuffer.remove(posL);
        }
        if (this.loaderPositions.remove(posL)) {
            int chunkX = pos.func_177958_n() >> 4;
            int chunkZ = pos.func_177952_p() >> 4;
            long chunkL = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
            int count = this.loadersPerChunkCount.get(chunkL);
            if (--count <= 0) {
                world.func_217458_b(chunkX, chunkZ, false);
                this.loadersPerChunkCount.remove(chunkL);
            } else {
                this.loadersPerChunkCount.put(chunkL, count);
            }
            this.func_76185_a();
        } else if (clearBuffer) {
            this.func_76185_a();
        }
    }

    public LongSet getChunks() {
        return this.loadersPerChunkCount.keySet();
    }

    public void func_76184_a(@Nonnull CompoundNBT tag) {
        long[] loaderPositions;
        for (long loaderPosition : loaderPositions = tag.func_197645_o("loaderPositions")) {
            this.loaderPositions.add(loaderPosition);
            BlockPos pos = BlockPos.func_218283_e((long)loaderPosition);
            long chunkL = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
            this.loadersPerChunkCount.put(chunkL, this.loadersPerChunkCount.get(chunkL) + 1);
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT tag) {
        LongArrayNBT loaderPositions = new LongArrayNBT(this.loaderPositions);
        tag.func_218657_a("loaderPositions", (INBT)loaderPositions);
        return tag;
    }
}

