/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.corruption.block;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.mcreator.corruption.block.ChunkLoaderData;
import net.minecraft.block.BlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="corruption", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    @SubscribeEvent
    public static void on(TickEvent.WorldTickEvent event) {
        if (!(event.world instanceof ServerWorld)) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            ServerWorld world = (ServerWorld)event.world;
            ChunkLoaderData data = ChunkLoaderData.get(world);
            data.init(world);
        } else if (event.phase == TickEvent.Phase.END) {
            ServerWorld world = (ServerWorld)event.world;
            ChunkLoaderData data = ChunkLoaderData.get(world);
            LongSet chunks = data.getChunks();
            int tickSpeed = event.world.func_82736_K().func_223592_c(GameRules.field_223610_m);
            ChunkPos chunkPos = null;
            if (tickSpeed > 0 && !chunks.isEmpty()) {
                try {
                    ServerChunkProvider chunkProvider = world.func_72863_F();
                    List players = world.func_217369_A();
                    LongIterator longIterator = chunks.iterator();
                    while (longIterator.hasNext()) {
                        long chunkL = (Long)longIterator.next();
                        chunkPos = new ChunkPos(chunkL);
                        if (!chunkProvider.func_222865_a(chunkPos) || !EventHandler.isOutsideSpawningRadius(chunkPos, players)) continue;
                        EventHandler.tickChunk(world, chunkPos, tickSpeed);
                    }
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)("Exception ticking world in chunk " + chunkPos));
                    world.func_72914_a(crashreport);
                    throw new ReportedException(crashreport);
                }
            }
        }
    }

    private static boolean isOutsideSpawningRadius(ChunkPos chunkPos, List<ServerPlayerEntity> players) {
        return players.isEmpty() || players.stream().noneMatch(player -> !player.func_175149_v() && EventHandler.getDistanceSquaredToChunk(chunkPos, (Entity)player) < 16384.0);
    }

    private static double getDistanceSquaredToChunk(ChunkPos chunkPos, Entity entity) {
        double x = chunkPos.field_77276_a * 16 + 8;
        double z = chunkPos.field_77275_b * 16 + 8;
        double dx = x - entity.func_226277_ct_();
        double dz = z - entity.func_226281_cx_();
        return dx * dx + dz * dz;
    }

    private static void tickChunk(ServerWorld world, ChunkPos chunkPos, int tickSpeed) {
        int xStart = chunkPos.func_180334_c();
        int zStart = chunkPos.func_180333_d();
        for (ChunkSection chunksection : world.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b).func_76587_i()) {
            if (chunksection == Chunk.field_186036_a || !chunksection.func_206915_b()) continue;
            int yStart = chunksection.func_222632_g();
            for (int i = 0; i < tickSpeed; ++i) {
                BlockPos blockPos = world.func_217383_a(xStart, yStart, zStart, 15);
                BlockState blockState = chunksection.func_177485_a(blockPos.func_177958_n() - xStart, blockPos.func_177956_o() - yStart, blockPos.func_177952_p() - zStart);
                if (!blockState.func_204519_t()) continue;
                blockState.func_227034_b_(world, blockPos, world.field_73012_v);
            }
        }
    }
}

