/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.corruption.block;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.mcreator.corruption.CorruptionModElements;
import net.mcreator.corruption.block.ChunkLoaderData;
import net.mcreator.corruption.procedures.RootOfCorruptionAdditionalGenerationConditionProcedure;
import net.mcreator.corruption.procedures.RootOfCorruptionUpdateTickProcedure;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.IRuleTestType;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ObjectHolder;

@CorruptionModElements.ModElement.Tag
public class RootOfCorruptionBlock
extends CorruptionModElements.ModElement {
    @ObjectHolder(value="corruption:root_of_corruption")
    public static final Block block = null;

    public RootOfCorruptionBlock(CorruptionModElements instance) {
        super(instance, 30);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        this.elements.blocks.add(() -> new CustomBlock());
        this.elements.items.add(() -> (Item)new BlockItem(block, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName(block.getRegistryName()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientLoad(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228643_e_());
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)new OreFeature(OreFeatureConfig.field_236566_a_){

            public boolean func_241855_a(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, OreFeatureConfig config) {
                RegistryKey dimensionType = world.func_201672_e().func_234923_W_();
                boolean dimensionCriteria = false;
                if (dimensionType == World.field_234918_g_) {
                    dimensionCriteria = true;
                }
                if (!dimensionCriteria) {
                    return false;
                }
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                if (!RootOfCorruptionAdditionalGenerationConditionProcedure.executeProcedure((Map<String, Object>)ImmutableMap.of((Object)"x", (Object)x, (Object)"y", (Object)y, (Object)"z", (Object)z, (Object)"world", (Object)world))) {
                    return false;
                }
                return super.func_241855_a(world, generator, rand, pos, config);
            }
        }.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)new BlockMatchRuleTest(Blocks.field_201941_jj.func_176223_P().func_177230_c()){

            public boolean func_215181_a(BlockState blockAt, Random random) {
                boolean blockCriteria = false;
                if (blockAt.func_177230_c() == Blocks.field_201941_jj.func_176223_P().func_177230_c()) {
                    blockCriteria = true;
                }
                return blockCriteria;
            }

            protected IRuleTestType<?> func_215180_a() {
                return IRuleTestType.field_214912_c;
            }
        }, block.func_176223_P(), 1)).func_242733_d(85)).func_242728_a()).func_242731_b(1));
    }

    public static class CustomBlock
    extends Block {
        public CustomBlock() {
            super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(1.0f, 10.0f).func_235838_a_(s -> 0).harvestLevel(0).harvestTool(ToolType.PICKAXE).func_200942_a().func_226896_b_().func_200944_c().func_235828_a_((bs, br, bp) -> false));
            this.setRegistryName("root_of_corruption");
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_190948_a(ItemStack itemstack, IBlockReader world, List<ITextComponent> list, ITooltipFlag flag) {
            super.func_190948_a(itemstack, world, list, flag);
            list.add((ITextComponent)new StringTextComponent("Spreads Corruption in the Overworld"));
        }

        public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
            return true;
        }

        public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, MobEntity entity) {
            return PathNodeType.OPEN;
        }

        public PushReaction func_149656_h(BlockState state) {
            return PushReaction.DESTROY;
        }

        public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
            List dropsOriginal = super.func_220076_a(state, builder);
            if (!dropsOriginal.isEmpty()) {
                return dropsOriginal;
            }
            return Collections.singletonList(new ItemStack((IItemProvider)Blocks.field_150350_a, 1));
        }

        public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
            super.func_225534_a_(state, world, pos, random);
            if (!world.field_72995_K) {
                ChunkLoaderData data = ChunkLoaderData.get(world);
                data.add(world, pos);
            }
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", world);
            RootOfCorruptionUpdateTickProcedure.executeProcedure($_dependencies);
        }

        public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
            if (!world.field_72995_K) {
                ServerWorld serverWorld = (ServerWorld)world;
                ChunkLoaderData data = ChunkLoaderData.get(serverWorld);
                data.add(serverWorld, pos);
            }
        }

        public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (!world.field_72995_K) {
                ServerWorld serverWorld = (ServerWorld)world;
                ChunkLoaderData data = ChunkLoaderData.get(serverWorld);
                data.remove(serverWorld, pos, true);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
            super.func_180655_c(state, world, pos, random);
            ClientPlayerEntity entity = Minecraft.func_71410_x().field_71439_g;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int l = 0; l < 2; ++l) {
                double d0 = (float)x + random.nextFloat();
                double d1 = (float)y + random.nextFloat();
                double d2 = (float)z + random.nextFloat();
                int i1 = random.nextInt(2) * 2 - 1;
                double d3 = ((double)random.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)random.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)random.nextFloat() - 0.5) * 0.5;
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, d3, d4, d5);
            }
        }
    }
}

