/*
 * Decompiled with CFR 0.152.
 */
package info.dimensionsintime.torchplacemod.handlers;

import info.dimensionsintime.torchplacemod.utils.Settings;
import java.io.File;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;

public class ModConfigurationHandler {
    public static Configuration configuration;
    public static String blockBlacklist;
    public static String itemBlacklist;
    public static String itemWhitelist;
    public static String itemMethodBlacklist;
    public static String farmingTools;
    public static String farmingBlocks;
    public static String torchWhitelist;

    public static void init(String configPath) {
        File configFile = new File(configPath + "/TorchPlaceMod/torchplacemod.cfg");
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ModConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        Settings.DEBUG = configuration.getBoolean("debug", "general", false, "True to log debug messages, false to disable");
        Settings.DESTROY_OFFSET = configuration.getBoolean("destroyOffset", "general", true, "True to destroy any offset block, ie ladder or other torch, when placing a new torch, false to disallow placement and leave offset intact");
        blockBlacklist = configuration.getString("blockBlacklist", "general", "bag,bed,chest,corn,crop,door,farm,furnace,plant,rubber,table,te,wheat", "List of terms for blacklisted blocks");
        Settings.BLOCK_BLACKLIST = Arrays.asList(blockBlacklist.split(","));
        itemBlacklist = configuration.getString("itemBlacklist", "general", "andesite,air,banner,bars,beacon,bed,bedrock,beetroot,book,bottle,bow,brick,bucket,bundle,bush,button,cable,cactus,cake,carpet,carrot,cart,cauldron,chest,clay,clock,coal,cobblestone,command,concrete,dandelion,diamond,diorite,dirt,disc,dispenser,door,egg,excavator,eye,farm,fence,fern,fire,flesh,flint,flower,frame,furnace,gate,glowstone,granite,glass,gold,grass,gravel,hammer,hay,hoe,hook,horn,horse,ice,iron,kelp,ladder,lantern,lapis,lava,lead,leaves,lever,lilypad,map,mattock,meal,melon,mushroom,mycelium,netherrack,note,observer,obsidian,ore,painting,pane,piston,plank,plate,podzal,potato,portal,prismarine,puffer,pumpkin,purpur,quartz,rail,redstone,rod,saddle,sand,sapling,shears,shulker,scythe,shield,shovel,sign,slab,slime,spyglass,soulsand,snow,spade,spawner,stair,stand,stone,sugar,table,tag,terracotta,tnt,torch,trident,vine,wall,wand,wart,water,wire,wood,wool", "List of blacklisted terms in item name that will not place a torch when right clicking.");
        Settings.ITEM_BLACKLIST = Arrays.asList(itemBlacklist.split(","));
        itemWhitelist = configuration.getString("itemWhitelist", "general", "axe,compass,hoe,pick,shovel,spade,sword", "List of whitelisted terms in item name that will place a torch when right clicking. Whitelist overrides blacklist.");
        Settings.ITEM_WHITELIST = Arrays.asList(itemWhitelist.split(","));
        itemMethodBlacklist = configuration.getString("itemMethodTerms", "general", "getPlant,isIC2,openGui,placeBlockAt", "List of blacklisted methods for items that should not be allowed to place torches, typically items that can be placed in the world, or open a gui");
        Settings.ITEM_METHOD_BLACKLIST = Arrays.asList(itemMethodBlacklist.split(","));
        farmingTools = configuration.getString("farmingTools", "general", "hoe", "List of terms for farming tools, essentially blacklisted from right clicking on the blocks in the list below");
        Settings.FARMING_TOOLS = Arrays.asList(farmingTools.split(","));
        farmingBlocks = configuration.getString("farmingBlocks", "general", "dirt,grass", "List of terms for blocks that will accept crops, essentially blacklisted from being right clicked");
        Settings.FARMING_BLOCKS = Arrays.asList(farmingBlocks.split(","));
        torchWhitelist = configuration.getString("torchTerms", "general", "torch", "List of terms to look for when finding torches in inventory");
        Settings.TORCH_WHITELIST = Arrays.asList(torchWhitelist.split(","));
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }
}

