/*
 * Decompiled with CFR 0.152.
 */
package info.dimensionsintime.torchplacemod.handlers;

import info.dimensionsintime.torchplacemod.utils.Log;
import info.dimensionsintime.torchplacemod.utils.Settings;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModEventsHandler {
    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EnumFacing facing;
        EntityPlayer player = event.getEntityPlayer();
        EnumHand hand = event.getHand();
        World world = event.getWorld();
        EnumFacing enumFacing = facing = event.getFace() == null ? EnumFacing.DOWN : event.getFace();
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND && facing != EnumFacing.DOWN) {
            Log.info("*****************************");
            Log.info("*** Analyzing right click ***");
            Log.info("*****************************");
            Log.debug("*** Analyzing item in main hand ***");
            Item heldItem = player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
            BlockPos clickedPos = event.getPos();
            Block clickedBlock = world.func_180495_p(clickedPos).func_177230_c();
            Log.info("Block " + clickedBlock.func_149732_F() + " at " + clickedPos + " was clicked with " + hand + " holding " + heldItem.func_77658_a());
            boolean okToContinue = true;
            int torchInventorySlot = -1;
            Log.debug("*** Searching for torches in inventory ***");
            block0: for (int i = 0; i < 36; ++i) {
                Method[] stack = player.field_71071_by.func_70301_a(i);
                Log.debug("Slot " + i + " has " + stack.func_77973_b().func_77658_a());
                for (String torchTerm : Settings.TORCH_WHITELIST) {
                    if (torchTerm.length() <= 0 || !stack.func_77973_b().func_77658_a().contains(torchTerm)) continue;
                    torchInventorySlot = i;
                    Log.debug("Match detected. Torches found in slot: " + i + " as " + stack.func_77973_b().func_77658_a());
                    break block0;
                }
            }
            if (torchInventorySlot == -1) {
                okToContinue = false;
                Log.debug("No torches found in inventory");
            }
            if (heldItem instanceof ItemFood) {
                okToContinue = false;
                Log.debug("Held item is ItemFood. Cannot place torch.");
            }
            if (okToContinue) {
                boolean holdingDamageableItem = heldItem.func_77645_m();
                Log.debug("Holding damageable item? " + holdingDamageableItem);
                Log.debug("*** Checking if item is whitelisted ***");
                Log.debug("*** Checking if item methods are blacklisted ***");
                block2: for (Method method : heldItem.getClass().getDeclaredMethods()) {
                    for (String blackListTerm : Settings.ITEM_METHOD_BLACKLIST) {
                        Log.debug("Item method: " + method.getName() + " matched against " + blackListTerm);
                        if (!method.getName().toLowerCase().contains(blackListTerm.toLowerCase())) continue;
                        okToContinue = false;
                        Log.debug("Match detected, method " + method.getName() + " is blacklisted using term " + blackListTerm + ". Cannot place torch.");
                        break block2;
                    }
                }
                if (okToContinue) {
                    Log.debug("*** Checking if item is blacklisted ***");
                    for (String itemTerm : Settings.ITEM_BLACKLIST) {
                        Log.debug("Term: " + itemTerm + " being matched against " + heldItem.func_77658_a());
                        if (itemTerm.length() <= 0 || !heldItem.func_77658_a().toLowerCase().contains(itemTerm.toLowerCase())) continue;
                        Log.debug("Match detected, item " + heldItem.func_77658_a() + " is blacklisted using term " + itemTerm + ". Cannot place torch.");
                        okToContinue = false;
                        break;
                    }
                }
                for (String itemTerm : Settings.ITEM_WHITELIST) {
                    Log.debug("*** Checking if item is whitelisted ***");
                    Log.debug("Term: " + itemTerm + " being matched against " + heldItem.func_77658_a());
                    if (!heldItem.func_77658_a().toLowerCase().contains(itemTerm.toLowerCase())) continue;
                    Log.debug("Match detected, item " + heldItem.func_77658_a() + " is whitelisted using term " + itemTerm);
                    okToContinue = true;
                    break;
                }
            }
            if (okToContinue) {
                Log.debug("*** Checking if block is blacklisted against torch placement ***");
                for (String blockTerm : Settings.BLOCK_BLACKLIST) {
                    Log.debug("Term: " + blockTerm + " being matched against " + clickedBlock.func_149739_a());
                    if (blockTerm.length() <= 0 || !clickedBlock.func_149739_a().toLowerCase().contains(blockTerm.toLowerCase())) continue;
                    okToContinue = false;
                    Log.debug("Match detected. " + blockTerm + ". Cannot place torch.");
                    break;
                }
            }
            Log.debug("*** Checking if farming in play ***");
            if (okToContinue) {
                boolean blockOK = true;
                boolean toolOK = true;
                for (String farmingBlockTerm : Settings.FARMING_BLOCKS) {
                    Log.debug("Block: " + clickedBlock.func_149739_a() + " matched against " + farmingBlockTerm.toLowerCase());
                    if (!clickedBlock.func_149739_a().toLowerCase().contains(farmingBlockTerm.toLowerCase())) continue;
                    blockOK = false;
                    Log.debug("Match detected, block " + clickedBlock.func_149739_a().toLowerCase() + " is blacklisted using term " + farmingBlockTerm + ".");
                    break;
                }
                for (String farmingToolTerm : Settings.FARMING_TOOLS) {
                    Log.debug("Tool: " + heldItem.func_77658_a().toLowerCase() + " matched against " + farmingToolTerm.toLowerCase());
                    if (!heldItem.func_77658_a().toLowerCase().contains(farmingToolTerm.toLowerCase())) continue;
                    toolOK = false;
                    Log.debug("Match detected, tool " + heldItem.func_77658_a().toLowerCase() + " is blacklisted using term " + farmingToolTerm + ".");
                    break;
                }
                if (!blockOK && !toolOK) {
                    okToContinue = false;
                    Log.debug("Cannot place tool due to farming restriction.");
                }
            }
            if (okToContinue) {
                ItemStack stack = player.field_71071_by.func_70301_a(torchInventorySlot);
                Block torchBlock = Block.func_149634_a((Item)stack.func_77973_b());
                IBlockState state = torchBlock.func_176194_O().func_177621_b();
                Block blockAtOffsetPosition = world.func_180495_p(clickedPos.func_177972_a(facing)).func_177230_c();
                Log.debug("Block currently at the offset position is: " + blockAtOffsetPosition.func_149732_F());
                boolean canPlayerDestroyOffset = blockAtOffsetPosition.canEntityDestroy(state, (IBlockAccess)world, clickedPos.func_177972_a(facing), (Entity)player);
                Log.debug("Can player destroy the offset block? " + canPlayerDestroyOffset);
                if (Settings.DESTROY_OFFSET && canPlayerDestroyOffset && blockAtOffsetPosition != Blocks.field_150350_a) {
                    Log.debug("Destroying the offset block per settings");
                    FMLClientHandler.instance().getServer().func_71218_a(player.field_71093_bK).func_175655_b(clickedPos.func_177972_a(facing), true);
                }
                boolean canBePlaced = clickedBlock.func_176198_a(world, clickedPos, facing);
                Log.debug("Can block be placed on side of clicked block? " + canBePlaced);
                Log.debug("Placing block");
                boolean torchPlaced = world.func_180501_a(clickedPos.func_177972_a(facing), state.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing), 2);
                Log.debug("Placed: " + torchPlaced);
                if (torchPlaced) {
                    Log.debug("Torch placed, playing sound");
                    SoundType soundType = torchBlock.getSoundType(state, world, clickedPos, (Entity)player);
                    world.func_184133_a(null, clickedPos, soundType.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.8f);
                    Log.debug("Removing torch from inventory stack");
                    player.field_71071_by.func_70298_a(torchInventorySlot, 1);
                    if (ModEventsHandler.countTorchesInInventory(player) == 0) {
                        Log.debug("Torches depleted in inventory, displaying warning message");
                        player.func_146105_b((ITextComponent)new TextComponentString("You have run out of torches in inventory"), true);
                    }
                }
            }
        }
    }

    private static int countTorchesInInventory(EntityPlayer player) {
        int torchCount = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            for (String torchTerm : Settings.TORCH_WHITELIST) {
                if (torchTerm.length() <= 0 || !stack.func_77973_b().func_77658_a().contains(torchTerm)) continue;
                torchCount += stack.func_190916_E();
            }
        }
        Log.debug("Torches in inventory: " + torchCount);
        return torchCount;
    }
}

