/*
 * Decompiled with CFR 0.152.
 */
package info.dimensionsintime.torchplacemod.events;

import info.dimensionsintime.torchplacemod.util.Log;
import info.dimensionsintime.torchplacemod.util.Settings;
import java.lang.reflect.Method;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="torchplacemod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModClientEvents {
    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        World world = event.getWorld();
        Direction facing = event.getFace();
        if (!player.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND && facing != Direction.DOWN) {
            Log.debug("*****************************");
            Log.debug("*** Analyzing right click ***");
            Log.debug("*****************************");
            Log.debug("*** Analyzing item in main hand ***");
            Item heldItem = player.func_184586_b(Hand.MAIN_HAND).func_77973_b();
            String heldItemName = String.valueOf(heldItem.getRegistryName());
            String heldItemNameLower = heldItemName.toLowerCase();
            BlockPos clickedPos = event.getPos();
            Block clickedBlock = world.func_180495_p(clickedPos).func_177230_c();
            String clickedBlockName = String.valueOf(clickedBlock).toLowerCase();
            Log.debug("Block " + clickedBlock.getRegistryName() + " facing " + facing + " at " + clickedPos + " was clicked with " + hand + " holding " + heldItemName);
            boolean okToContinue = true;
            int torchInventorySlot = -1;
            block0: for (int i = 0; i < 36; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                Iterator<String> itemInSlot = String.valueOf(stack.func_77973_b().getRegistryName());
                Log.debug("Slot " + i + " has registry name of " + (String)((Object)itemInSlot));
                for (String string : Settings.TORCH_WHITELIST) {
                    if (string.length() <= 0 || !((String)((Object)itemInSlot)).contains(string)) continue;
                    torchInventorySlot = i;
                    Log.debug("Torches found in slot " + i + " as " + itemInSlot);
                    break block0;
                }
            }
            if (torchInventorySlot == -1) {
                okToContinue = false;
                Log.debug("No torches found in inventory!");
            }
            if (heldItem.func_219971_r()) {
                okToContinue = false;
                Log.debug("Held item is food. Cannot place torch.");
            }
            if (okToContinue && Settings.ONLY_TOOLS_WEAPONS) {
                boolean holdingDamageableItem = heldItem.func_77645_m();
                Log.debug("Holding damageable item? " + holdingDamageableItem);
                if (!holdingDamageableItem) {
                    okToContinue = false;
                    Log.debug("Not holding a tool or weapon!");
                }
            }
            if (okToContinue) {
                Log.debug("*** Checking if item methods are blacklisted ***");
                block2: for (Method method : heldItem.getClass().getDeclaredMethods()) {
                    for (String blackListTerm : Settings.ITEM_METHOD_BLACKLIST) {
                        Log.debug("Item method: " + method.getName() + " matched against " + blackListTerm);
                        if (!method.getName().toLowerCase().contains(blackListTerm.toLowerCase())) continue;
                        okToContinue = false;
                        Log.debug("Match detected, method " + method.getName() + " is blacklisted using term " + blackListTerm + ". Cannot place torch.");
                        break block2;
                    }
                }
                if (okToContinue) {
                    Log.debug("*** Checking if item is blacklisted ***");
                    for (String itemTerm : Settings.ITEM_BLACKLIST) {
                        Log.debug("Term: " + itemTerm + " being matched against " + heldItemName);
                        if (itemTerm.length() <= 0 || !heldItemNameLower.contains(itemTerm.toLowerCase())) continue;
                        Log.debug("Match detected, item " + heldItem.getRegistryName() + " is blacklisted using term " + itemTerm + ". Cannot place torch.");
                        okToContinue = false;
                        break;
                    }
                }
                Log.debug("*** Checking if item is whitelisted ***");
                for (String itemTerm : Settings.ITEM_WHITELIST) {
                    Log.debug("Term: " + itemTerm + " being matched against " + heldItem.getRegistryName());
                    if (!heldItemNameLower.contains(itemTerm.toLowerCase())) continue;
                    Log.debug("Match detected, item " + heldItemNameLower + " is whitelisted using term " + itemTerm);
                    okToContinue = true;
                    break;
                }
            }
            if (okToContinue) {
                Log.debug("*** Checking if block is blacklisted against torch placement ***");
                for (String blockTerm : Settings.BLOCK_BLACKLIST) {
                    Log.debug("Term: " + blockTerm + " being matched against " + clickedBlock.getRegistryName());
                    if (blockTerm.length() <= 0 || !String.valueOf(clickedBlock.getRegistryName()).toLowerCase().contains(blockTerm.toLowerCase())) continue;
                    okToContinue = false;
                    Log.debug("Match detected. " + blockTerm + ". Cannot place torch.");
                    break;
                }
            }
            if (okToContinue) {
                Log.debug("*** Checking if farming in play ***");
                boolean blockOK = true;
                boolean toolOK = true;
                for (String farmingBlockTerm : Settings.FARMING_BLOCKS) {
                    Log.debug("Block: " + clickedBlock.getRegistryName() + " is being matched against " + farmingBlockTerm.toLowerCase());
                    if (!clickedBlockName.contains(farmingBlockTerm.toLowerCase())) continue;
                    blockOK = false;
                    Log.debug("Match detected, block " + clickedBlockName + " is blacklisted using term " + farmingBlockTerm + ".");
                    break;
                }
                for (String farmingToolTerm : Settings.FARMING_TOOLS) {
                    Log.debug("Tool: " + heldItemName + " is being matched against " + farmingToolTerm.toLowerCase());
                    if (!heldItemNameLower.contains(farmingToolTerm.toLowerCase())) continue;
                    toolOK = false;
                    Log.debug("Match detected, tool " + heldItemNameLower + " is blacklisted using term " + farmingToolTerm + ".");
                    break;
                }
                if (!blockOK && !toolOK) {
                    okToContinue = false;
                    Log.debug("Cannot place tool due to farming restriction.");
                }
            }
            if (okToContinue && facing != null) {
                ItemStack stack = player.field_71071_by.func_70301_a(torchInventorySlot);
                Block torchBlock = Block.func_149634_a((Item)stack.func_77973_b());
                String torchBlockName = String.valueOf(torchBlock.getRegistryName()).toLowerCase();
                Block torchToSet = Blocks.field_150478_aa;
                Block block = Blocks.field_196591_bQ;
                if (torchBlockName.equals("minecraft:redstone_torch")) {
                    torchToSet = Blocks.field_150429_aA;
                    Block block2 = Blocks.field_196677_cy;
                }
                if (torchBlockName.equals("minecraft:soul_torch")) {
                    torchToSet = Blocks.field_235339_cQ_;
                    Block block3 = Blocks.field_235340_cR_;
                }
                Log.debug("Torch block found is " + torchBlock.getRegistryName());
                BlockState state = torchBlock.func_176223_P();
                Block blockAtOffsetPosition = world.func_180495_p(clickedPos.func_177972_a(facing)).func_177230_c();
                Log.debug("Block currently at the offset position is: " + blockAtOffsetPosition.getRegistryName());
                Log.debug("Block clicked on is: " + clickedBlockName);
                BlockPos whereToPlaceTorch = clickedPos.func_177972_a(facing);
                if (clickedBlockName.equals("block{minecraft:grass}") || clickedBlockName.equals("block{minecraft:tall_grass}")) {
                    world.func_175656_a(clickedPos, Blocks.field_150350_a.func_176223_P());
                    whereToPlaceTorch = clickedPos;
                    facing = Direction.UP;
                }
                Log.debug("Placing block");
                if (facing == Direction.UP) {
                    world.func_175656_a(whereToPlaceTorch, torchToSet.func_176223_P());
                } else {
                    void var17_34;
                    world.func_175656_a(whereToPlaceTorch, (BlockState)var17_34.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)facing));
                }
                Log.debug("Torch placed, playing sound");
                SoundType soundType = torchBlock.getSoundType(state, (IWorldReader)world, clickedPos, (Entity)player);
                world.func_184133_a(null, clickedPos, soundType.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.8f);
                Log.debug("Removing torch from inventory stack");
                player.field_71071_by.func_70298_a(torchInventorySlot, 1);
                if (ModClientEvents.countTorchesInInventory(player) == 0) {
                    Log.debug("Torches depleted in inventory, displaying warning message");
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("You have run out of torches in inventory"), true);
                }
            }
        }
    }

    private static int countTorchesInInventory(PlayerEntity player) {
        int torchCount = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            for (String torchTerm : Settings.TORCH_WHITELIST) {
                if (torchTerm.length() <= 0 || !String.valueOf(stack.func_77973_b().getRegistryName()).contains(torchTerm)) continue;
                torchCount += stack.func_190916_E();
            }
        }
        Log.debug("Torches in inventory: " + torchCount);
        return torchCount;
    }
}

