/*
 * Decompiled with CFR 0.152.
 */
package info.dimensionsintime.torchplacemod.handler;

import info.dimensionsintime.torchplacemod.util.Settings;
import java.util.Arrays;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="torchplacemod", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ConfigHandler {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getSpec() == CLIENT_SPEC) {
            ConfigHandler.bakeConfig();
        }
    }

    public static void bakeConfig() {
        Settings.DEBUG = (Boolean)ConfigHandler.CLIENT.debug.get();
        Settings.ONLY_TOOLS_WEAPONS = (Boolean)ConfigHandler.CLIENT.onlyToolsWeapons.get();
        Settings.TORCH_WHITELIST = Arrays.asList(((String)ConfigHandler.CLIENT.torchWhitelist.get()).split(","));
        Settings.BLOCK_BLACKLIST = Arrays.asList(((String)ConfigHandler.CLIENT.blockBlacklist.get()).split(","));
        Settings.ITEM_BLACKLIST = Arrays.asList(((String)ConfigHandler.CLIENT.itemBlacklist.get()).split(","));
        Settings.ITEM_WHITELIST = Arrays.asList(((String)ConfigHandler.CLIENT.itemWhitelist.get()).split(","));
        Settings.ITEM_METHOD_BLACKLIST = Arrays.asList(((String)ConfigHandler.CLIENT.itemMethodBlacklist.get()).split(","));
        Settings.FARMING_TOOLS = Arrays.asList(((String)ConfigHandler.CLIENT.farmingTools.get()).split(","));
        Settings.FARMING_BLOCKS = Arrays.asList(((String)ConfigHandler.CLIENT.farmingBlocks.get()).split(","));
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue debug;
        public final ForgeConfigSpec.BooleanValue onlyToolsWeapons;
        public final ForgeConfigSpec.ConfigValue<String> torchWhitelist;
        public final ForgeConfigSpec.ConfigValue<String> blockBlacklist;
        public final ForgeConfigSpec.ConfigValue<String> itemBlacklist;
        public final ForgeConfigSpec.ConfigValue<String> itemWhitelist;
        public final ForgeConfigSpec.ConfigValue<String> itemMethodBlacklist;
        public final ForgeConfigSpec.ConfigValue<String> farmingTools;
        public final ForgeConfigSpec.ConfigValue<String> farmingBlocks;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.debug = builder.comment("Turn debug log entries on and off.").translation("torchplacemod.config.debug").define("debug", false);
            this.onlyToolsWeapons = builder.comment("Only place torches when holding tools or weapons.").translation("torchplacemod.config.onlyToolsWeapons").define("onlyToolsWeapons", true);
            this.torchWhitelist = builder.comment("A list of terms to look for when finding torches in inventory.").translation("torchplacemod.config.torchWhitelist").define("torchWhitelist", (Object)"torch");
            this.blockBlacklist = builder.comment("A list of terms for blacklisted blocks.").translation("torchplacemod.config.blockBlacklist").define("blockBlacklist", (Object)"bag,bed,chest,composter,corn,crop,door,farm,furnace,plant,rubber,table,wheat");
            this.itemBlacklist = builder.comment("List of blacklisted terms in item name that will not place a torch when right clicking.").translation("torchplacemod.config.itemBlacklist").define("itemBlacklist", (Object)"allium,andesite,air,anvil,banner,barrel,bars,basalt,beacon,bed,bedrock,beehive,beetroot,bee_nest,bell,bluet,boat,bone,book,bottle,bow,brick,bucket,bundle,bush,button,cable,cactus,cake,campfire,carpet,carrot,cart,cauldron,chain,chest,clay,clock,coal,cobblestone,cobweb,command,comparator,composter,concrete,conduit,coral,creeper_head,daisy,dandelion,daylight_detector,debris,diamond,diorite,dirt,disc,dispenser,door,dragon_head,dropper,egg,excavator,eye,farm,fence,fern,fire,flesh,flint,flower,frame,fungus,furnace,gate,glowstone,granite,glass,gold,grass,gravel,hammer,hay,hoe,honey,hook,hopper,horn,horse,hyphae,ice,iron,jukebox,kelp,ladder,lantern,lapis,lava,lead,leaves,lectern,lever,lilac,lily,loom,map,mattock,meal,melon,mushroom,mycelium,netherite,netherrack,note,observer,obsidian,orchid,ore,painting,pane,peony,piston,plank,plate,player_head,podzal,poppy,potato,portal,prismarine,puffer,pumpkin,purpur,quartz,rail,redstone,respawn_anchor,repeater,rod,roots,rose,saddle,sand,sapling,scaffold,sea_pickle,shears,shulker,scythe,shield,shovel,shroomlight,sign,skeleton_skull,slab,slime,smoker,sponge,sprouts,spyglass,soulsand,snow,spade,spawner,stair,stand,stem,stone,sugar,table,tag,target,terracotta,tnt,torch,trident,tulip,vine,wall,wand,wart,water,wire,wood,wool,zombie_head");
            this.itemWhitelist = builder.comment("List of whitelisted terms in item name that will place a torch when right clicking. Whitelist overrides blacklist.").translation("torchplacemod.config.itemWhitelist").define("itemWhitelist", (Object)"axe,compass,hoe,pick,shovel,spade,sword");
            this.itemMethodBlacklist = builder.comment("List of blacklisted methods for items that should not be allowed to place torches, typically items that can be placed in the world, or open a gui").translation("torchplacemod.config.itemMethodBlacklist").define("itemMethodBlacklist", (Object)"getPlant,isIC2,openGui,placeBlockAt");
            this.farmingTools = builder.comment("List of terms for farming tools that will never place a torch.").translation("torchplacemod.config.farmingTools").define("farmingTools", (Object)"hoe");
            this.farmingBlocks = builder.comment("List of terms for blocks that will accept crops, essentially blacklisted from being right clicked.").translation("torchplacemod.config.farmingBlocks").define("farmingBlocks", (Object)"dirt,grass");
        }
    }
}

