/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block.tileentity;

import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.server.ServerWorld;
import trapcraft.TrapcraftTileEntityTypes;

public class BearTrapTileEntity
extends TileEntity
implements ITickableTileEntity {
    private final DamageSource damageSource = new DamageSource("trapcraft.bear_trap").func_76348_h();
    @Nullable
    private MobEntity entityliving;
    private Goal doNothingGoal;
    private UUID id;
    private int nextDamageTick;

    public BearTrapTileEntity() {
        super((TileEntityType)TrapcraftTileEntityTypes.BEAR_TRAP.get());
    }

    public void func_73660_a() {
        MobEntity trapped = this.getTrappedEntity();
        if (!this.field_145850_b.field_72995_K && trapped != null) {
            if (!trapped.func_174813_aQ().func_72326_a(new AxisAlignedBB(this.field_174879_c)) || !trapped.func_70089_S()) {
                this.setTrappedEntity(null);
            } else {
                if (this.nextDamageTick == 0) {
                    trapped.func_70097_a(this.damageSource, 1.0f);
                    this.nextDamageTick = 15 + this.field_145850_b.field_73012_v.nextInt(20);
                }
                if (this.nextDamageTick > 0) {
                    --this.nextDamageTick;
                }
            }
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_186855_b("trapped_entity")) {
            this.id = nbt.func_186857_a("trapped_entity");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.entityliving != null && this.entityliving.func_70089_S()) {
            compound.func_186854_a("trapped_entity", this.entityliving.func_110124_au());
        }
        return compound;
    }

    public boolean setTrappedEntity(@Nullable MobEntity livingEntity) {
        if (this.hasTrappedEntity() && livingEntity != null) {
            return false;
        }
        if (livingEntity == null) {
            if (this.entityliving != null) {
                this.entityliving.field_70714_bg.func_85156_a(this.doNothingGoal);
            }
            this.id = null;
            this.doNothingGoal = null;
            this.nextDamageTick = 0;
        } else {
            livingEntity.field_70714_bg.func_220888_c().filter(PrioritizedGoal::func_220773_g).forEach(PrioritizedGoal::func_75251_c);
            this.doNothingGoal = new DoNothingGoal(livingEntity, this);
            livingEntity.field_70714_bg.func_75776_a(0, this.doNothingGoal);
        }
        this.entityliving = livingEntity;
        return true;
    }

    public MobEntity getTrappedEntity() {
        if (this.id != null && this.field_145850_b instanceof ServerWorld) {
            Entity entity = ((ServerWorld)this.field_145850_b).func_217461_a(this.id);
            this.id = null;
            if (entity instanceof MobEntity) {
                this.setTrappedEntity((MobEntity)entity);
            }
        }
        return this.entityliving;
    }

    public boolean hasTrappedEntity() {
        return this.getTrappedEntity() != null;
    }

    public boolean isEntityTrapped(MobEntity trappedEntity) {
        return this.getTrappedEntity() == trappedEntity;
    }

    class DoNothingGoal
    extends Goal {
        private MobEntity trappedEntity;
        private BearTrapTileEntity trap;

        public DoNothingGoal(MobEntity trappedEntity, BearTrapTileEntity trap) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.trappedEntity = trappedEntity;
            this.trap = trap;
        }

        public boolean func_75250_a() {
            return this.trap.isEntityTrapped(this.trappedEntity);
        }
    }
}

