/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import trapcraft.TrapcraftTileEntityTypes;
import trapcraft.api.ConfigValues;
import trapcraft.block.FanBlock;

public class FanTileEntity
extends TileEntity
implements ITickableTileEntity {
    public float speed = 1.0f;
    public double extraRange = 0.0;

    public FanTileEntity() {
        super((TileEntityType)TrapcraftTileEntityTypes.FAN.get());
    }

    public void func_73660_a() {
        if (!((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)FanBlock.POWERED)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)FanBlock.FACING);
        if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
            FanTileEntity.spawnParticles(this.field_145850_b, this.field_174879_c);
        }
        List list = this.field_145850_b.func_217357_a(Entity.class, this.getDirection());
        for (Entity entity : list) {
            if (!this.isPathClear(entity, facing)) continue;
            double velocity = ConfigValues.FAN_ACCELERATION;
            double threshholdVelocity = ConfigValues.FAN_MAX_SPEED;
            velocity *= (double)this.speed;
            if (entity instanceof ItemEntity) {
                threshholdVelocity *= 1.8;
                velocity *= 1.3;
            }
            if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75100_b) continue;
            if (entity instanceof MinecartEntity) {
                velocity *= 0.5;
            }
            if (entity instanceof FallingBlockEntity && facing == Direction.UP) {
                velocity = 0.0;
            }
            if (facing == Direction.UP) {
                threshholdVelocity *= 0.5;
            }
            if (!(Math.abs(entity.func_213322_ci().func_216370_a(facing.func_176740_k())) < threshholdVelocity)) continue;
            entity.func_213317_d(entity.func_213322_ci().func_72441_c((double)facing.func_82601_c() * velocity, (double)facing.func_96559_d() * velocity, (double)facing.func_82599_e() * velocity));
        }
    }

    public boolean isPathClear(Entity entity, Direction facing) {
        int x = facing.func_82601_c() * (MathHelper.func_76128_c((double)entity.func_226277_ct_()) - this.field_174879_c.func_177958_n());
        int y = facing.func_96559_d() * (MathHelper.func_76128_c((double)entity.func_226278_cu_()) - this.field_174879_c.func_177956_o());
        int z = facing.func_82599_e() * (MathHelper.func_76128_c((double)entity.func_226281_cx_()) - this.field_174879_c.func_177952_p());
        boolean flag = true;
        for (int l2 = 1; l2 < Math.abs(x + y + z); ++l2) {
            if (!Block.func_220055_a((IWorldReader)this.field_145850_b, (BlockPos)this.field_174879_c.func_177967_a(facing, l2), (Direction)facing.func_176734_d())) continue;
            flag = false;
        }
        return flag;
    }

    public String getSliderDisplay() {
        float f = this.speed;
        f *= 100.0f;
        f = (float)Math.round(f) / 100.0f;
        return String.valueOf(f);
    }

    public AxisAlignedBB getDirection() {
        Direction facing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)FanBlock.FACING);
        BlockPos endPos = this.field_174879_c.func_177967_a(facing, MathHelper.func_76128_c((double)((double)ConfigValues.FAN_RANGE + this.extraRange)));
        if (facing == Direction.WEST) {
            endPos = endPos.func_177982_a(0, 1, 1);
        } else if (facing == Direction.NORTH) {
            endPos = endPos.func_177982_a(1, 1, 0);
        }
        if (facing == Direction.EAST) {
            endPos = endPos.func_177982_a(1, 1, 1);
        } else if (facing == Direction.SOUTH) {
            endPos = endPos.func_177982_a(1, 1, 1);
        }
        if (facing == Direction.UP) {
            endPos = endPos.func_177982_a(1, 1, 1);
        } else if (facing == Direction.DOWN) {
            endPos = endPos.func_177982_a(1, 0, 1);
        }
        return new AxisAlignedBB(this.field_174879_c, endPos);
    }

    public static void spawnParticles(World world, BlockPos pos) {
        double x = (float)pos.func_177958_n() + world.field_73012_v.nextFloat();
        double y = (float)pos.func_177956_o() + world.field_73012_v.nextFloat();
        double z = (float)pos.func_177952_p() + world.field_73012_v.nextFloat();
        Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((Property)FanBlock.FACING);
        double velocity = 0.2f + world.field_73012_v.nextFloat() * 0.4f;
        double velX = (double)facing.func_82601_c() * velocity;
        double velY = (double)facing.func_96559_d() * velocity;
        double velZ = (double)facing.func_82599_e() * velocity;
        world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, velX, velY, velZ);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.speed = nbt.func_74760_g("speed");
        this.extraRange = nbt.func_74769_h("extraRange");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("speed", this.speed);
        compound.func_74780_a("extraRange", this.extraRange);
        return compound;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = new CompoundNBT();
        return this.func_189515_b(tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        this.func_230337_a_(null, packet.func_148857_g());
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }
}

