/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block.tileentity;

import java.util.List;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import trapcraft.TrapcraftTileEntityTypes;

public class MagneticChestTileEntity
extends ChestTileEntity
implements ITickableTileEntity {
    public MagneticChestTileEntity() {
        super((TileEntityType)TrapcraftTileEntityTypes.MAGNETIC_CHEST.get());
    }

    public void func_73660_a() {
        super.func_73660_a();
        this.pullItemsIn();
    }

    public void pullItemsIn() {
        List entities = this.field_145850_b.func_175647_a(ItemEntity.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g(50.0), item -> item.func_70092_e((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()) < 10.0);
        for (ItemEntity itemEntity : entities) {
            double centreX = (double)this.field_174879_c.func_177958_n() + 0.5;
            double centreY = (double)this.field_174879_c.func_177956_o() + 0.5;
            double centreZ = (double)this.field_174879_c.func_177952_p() + 0.5;
            double diffX = -itemEntity.func_226277_ct_() + centreX;
            double diffY = -itemEntity.func_226278_cu_() + centreY;
            double diffZ = -itemEntity.func_226281_cx_() + centreZ;
            double speedMultiper = 0.05;
            double d11 = itemEntity.func_226277_ct_() - centreX;
            double d12 = itemEntity.func_226281_cx_() - centreZ;
            double horizDiffSq = MathHelper.func_76133_a((double)(diffX * diffX + diffZ * diffZ));
            double angle = Math.asin(diffX / horizDiffSq);
            double d15 = Math.abs((double)MathHelper.func_76126_a((float)((float)angle)) * 0.05);
            double d16 = Math.abs((double)MathHelper.func_76134_b((float)((float)angle)) * 0.05);
            d15 = diffX <= 0.0 ? -d15 : d15;
            double d = d16 = diffZ <= 0.0 ? -d16 : d16;
            if (itemEntity.func_213322_ci().func_72430_b(itemEntity.func_213322_ci()) >= 0.2) continue;
            itemEntity.func_213293_j(d15, diffY >= 0.7 ? 0.1 : itemEntity.func_213322_ci().func_82617_b(), d16);
        }
    }

    public boolean insertStackFromEntity(ItemEntity entityItem) {
        boolean succesful = false;
        if (entityItem == null || !entityItem.func_70089_S()) {
            return false;
        }
        ItemStack itemstack = entityItem.func_92059_d().func_77946_l();
        ItemStack itemstack1 = this.addItem(itemstack);
        if (!itemstack1.func_190926_b()) {
            entityItem.func_92058_a(itemstack1);
        } else {
            succesful = true;
            entityItem.func_70106_y();
        }
        return succesful;
    }

    public ItemStack addItem(ItemStack stack) {
        ItemStack itemstack = stack.func_77946_l();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack1 = this.func_70301_a(i);
            if (itemstack1.func_190926_b()) {
                this.func_70299_a(i, itemstack);
                this.func_70296_d();
                return ItemStack.field_190927_a;
            }
            if (!ItemStack.func_179545_c((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            int j = Math.min(this.func_70297_j_(), itemstack1.func_77976_d());
            int k = Math.min(itemstack.func_190916_E(), j - itemstack1.func_190916_E());
            if (k <= 0) continue;
            itemstack1.func_190917_f(k);
            itemstack.func_190918_g(k);
            if (!itemstack.func_190926_b()) continue;
            this.func_70296_d();
            return ItemStack.field_190927_a;
        }
        if (itemstack.func_190916_E() != stack.func_190916_E()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.trapcraft.magnetic_chest");
    }
}

