/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.data;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import trapcraft.TrapcraftBlocks;
import trapcraft.TrapcraftItems;

public class TrapcraftItemModelProvider
extends ItemModelProvider {
    public TrapcraftItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "trapcraft", existingFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "Trapcraft Item Models";
    }

    protected void registerModels() {
        this.generated((Supplier<? extends IItemProvider>)TrapcraftItems.IGNITER_RANGE, "_upgrade");
        this.blockSprite((Supplier<? extends Block>)TrapcraftBlocks.SPIKES);
        this.blockItem((Supplier<? extends Block>)TrapcraftBlocks.FAN);
        this.blockItem((Supplier<? extends Block>)TrapcraftBlocks.IGNITER);
        this.blockItem((Supplier<? extends Block>)TrapcraftBlocks.BEAR_TRAP, "_open");
        this.blockItem((Supplier<? extends Block>)TrapcraftBlocks.GRASS_COVERING);
        this.chest((Supplier<? extends IItemProvider>)TrapcraftBlocks.MAGNETIC_CHEST, (Supplier<? extends Block>)Blocks.field_196662_n.delegate);
    }

    private ResourceLocation itemTexture(Supplier<? extends IItemProvider> item) {
        return this.modLoc("item/" + this.name(item));
    }

    private ResourceLocation blockTexture(Supplier<? extends Block> block) {
        ResourceLocation base = block.get().getRegistryName();
        return new ResourceLocation(base.func_110624_b(), "block/" + base.func_110623_a());
    }

    private String name(Supplier<? extends IItemProvider> item) {
        return item.get().func_199767_j().getRegistryName().func_110623_a();
    }

    private ItemModelBuilder blockSprite(Supplier<? extends Block> block) {
        return this.generated(block, this.blockTexture(block));
    }

    private ItemModelBuilder blockItem(Supplier<? extends Block> block) {
        return this.blockItem(block, "");
    }

    private ItemModelBuilder generated(Supplier<? extends IItemProvider> item) {
        return this.generated(item, this.itemTexture(item));
    }

    private ItemModelBuilder generated(Supplier<? extends IItemProvider> item, String suffix) {
        return this.generated(item, this.extend(this.itemTexture(item), suffix));
    }

    private ItemModelBuilder generated(Supplier<? extends IItemProvider> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.name(item))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
    }

    private ItemModelBuilder chest(Supplier<? extends IItemProvider> item, Supplier<? extends Block> particle) {
        return this.chest(item, this.blockTexture(particle));
    }

    private ItemModelBuilder chest(Supplier<? extends IItemProvider> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.name(item))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/chest"))).texture("particle", texture);
    }

    private ItemModelBuilder blockItem(Supplier<? extends Block> block, String suffix) {
        return (ItemModelBuilder)this.withExistingParent(this.name(block), this.modLoc("block/" + this.name(block) + suffix));
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.func_110624_b(), rl.func_110623_a() + suffix);
    }
}

