/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.RandomChanceWithLooting;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import trapcraft.TrapcraftBlocks;
import trapcraft.TrapcraftEntityTypes;

public class TrapcraftLootTableProvider
extends LootTableProvider {
    public TrapcraftLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Nonnull
    public String func_200397_b() {
        return "Trapcraft LootTables";
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new Blocks(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new Entities(), (Object)LootParameterSets.field_216263_d));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationTracker) {
    }

    private static class Entities
    extends EntityLootTables {
        private Entities() {
        }

        protected void addTables() {
            this.registerLootTable((Supplier<? extends EntityType<?>>)TrapcraftEntityTypes.DUMMY, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_190930_cZ)).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.5f, (float)0.0625f))));
        }

        protected void registerLootTable(Supplier<? extends EntityType<?>> type, LootTable.Builder table) {
            this.func_218585_a(type.get().func_220348_g(), table);
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return TrapcraftEntityTypes.ENTITIES.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }

    private static class Blocks
    extends BlockLootTables {
        private Blocks() {
        }

        protected void addTables() {
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.FAN);
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.MAGNETIC_CHEST);
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.BEAR_TRAP);
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.SPIKES);
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.IGNITER);
            this.droppingWithSilkTouchOrItemInRange((Supplier<? extends Block>)TrapcraftBlocks.GRASS_COVERING, (Supplier<? extends IItemProvider>)Items.field_151055_y.delegate, (IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f));
        }

        private void dropsSelf(Supplier<? extends Block> block) {
            this.func_218492_c(block.get());
        }

        private void droppingWithSilkTouchOrItemInRange(Supplier<? extends Block> block, Supplier<? extends IItemProvider> dropItem, IRandomRange range) {
            this.func_218522_a(block.get(), b -> Blocks.func_218530_a((Block)b, (IItemProvider)((IItemProvider)dropItem.get()), (IRandomRange)range));
        }

        protected Iterable<Block> getKnownBlocks() {
            return TrapcraftBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

