/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block.tileentity;

import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import trapcraft.TrapcraftTileEntityTypes;

public class BearTrapTileEntity
extends BlockEntity {
    private static final DamageSource damageSource = new DamageSource("trapcraft.bear_trap").m_19380_();
    @Nullable
    private Mob entityliving;
    private Goal doNothingGoal;
    private UUID id;
    private int nextDamageTick;

    public BearTrapTileEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)TrapcraftTileEntityTypes.BEAR_TRAP.get(), p_155229_, p_155230_);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
        BlockEntity blockEntity2 = blockEntity;
        if (!(blockEntity2 instanceof BearTrapTileEntity)) {
            return;
        }
        BearTrapTileEntity e = (BearTrapTileEntity)blockEntity2;
        Mob trapped = e.getTrappedEntity();
        if (!level.f_46443_ && trapped != null) {
            if (!trapped.m_142469_().m_82381_(new AABB(blockPos)) || !trapped.m_6084_()) {
                e.setTrappedEntity(null);
            } else {
                if (e.nextDamageTick == 0) {
                    trapped.m_6469_(damageSource, 1.0f);
                    e.nextDamageTick = 15 + level.f_46441_.nextInt(20);
                }
                if (e.nextDamageTick > 0) {
                    --e.nextDamageTick;
                }
            }
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128403_("trapped_entity")) {
            this.id = nbt.m_128342_("trapped_entity");
        }
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        if (this.entityliving != null && this.entityliving.m_6084_()) {
            compound.m_128362_("trapped_entity", this.entityliving.m_142081_());
        }
        return compound;
    }

    public boolean setTrappedEntity(@Nullable Mob livingEntity) {
        if (this.hasTrappedEntity() && livingEntity != null) {
            return false;
        }
        if (livingEntity == null) {
            if (this.entityliving != null) {
                this.entityliving.f_21345_.m_25363_(this.doNothingGoal);
            }
            this.id = null;
            this.doNothingGoal = null;
            this.nextDamageTick = 0;
        } else {
            livingEntity.f_21345_.m_25386_().filter(WrappedGoal::m_7620_).forEach(WrappedGoal::m_8041_);
            this.doNothingGoal = new DoNothingGoal(livingEntity, this);
            livingEntity.f_21345_.m_25352_(0, this.doNothingGoal);
        }
        this.entityliving = livingEntity;
        return true;
    }

    public Mob getTrappedEntity() {
        if (this.id != null && this.f_58857_ instanceof ServerLevel) {
            Entity entity = ((ServerLevel)this.f_58857_).m_8791_(this.id);
            this.id = null;
            if (entity instanceof Mob) {
                this.setTrappedEntity((Mob)entity);
            }
        }
        return this.entityliving;
    }

    public boolean hasTrappedEntity() {
        return this.getTrappedEntity() != null;
    }

    public boolean isEntityTrapped(Mob trappedEntity) {
        return this.getTrappedEntity() == trappedEntity;
    }

    class DoNothingGoal
    extends Goal {
        private Mob trappedEntity;
        private BearTrapTileEntity trap;

        public DoNothingGoal(Mob trappedEntity, BearTrapTileEntity trap) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.trappedEntity = trappedEntity;
            this.trap = trap;
        }

        public boolean m_8036_() {
            return this.trap.isEntityTrapped(this.trappedEntity);
        }
    }
}

