/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block.tileentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import trapcraft.TrapcraftTileEntityTypes;

public class MagneticChestTileEntity
extends ChestBlockEntity {
    public MagneticChestTileEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)TrapcraftTileEntityTypes.MAGNETIC_CHEST.get(), p_155229_, p_155230_);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        ChestBlockEntity.m_155343_((Level)level, (BlockPos)pos, (BlockState)state, (ChestBlockEntity)((MagneticChestTileEntity)entity));
        MagneticChestTileEntity.tick(level, pos, state, entity);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        BlockEntity blockEntity = entity;
        if (!(blockEntity instanceof MagneticChestTileEntity)) {
            return;
        }
        MagneticChestTileEntity chest = (MagneticChestTileEntity)blockEntity;
        if (level.f_46443_) {
            ChestBlockEntity.m_155343_((Level)level, (BlockPos)pos, (BlockState)state, (ChestBlockEntity)chest);
        }
        List entities = level.m_6443_(ItemEntity.class, new AABB(pos).m_82400_(50.0), item -> item.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 10.0);
        for (ItemEntity itemEntity : entities) {
            double centreX = (double)pos.m_123341_() + 0.5;
            double centreY = (double)pos.m_123342_() + 0.5;
            double centreZ = (double)pos.m_123343_() + 0.5;
            double diffX = -itemEntity.m_20185_() + centreX;
            double diffY = -itemEntity.m_20186_() + centreY;
            double diffZ = -itemEntity.m_20189_() + centreZ;
            double speedMultiper = 0.05;
            double d11 = itemEntity.m_20185_() - centreX;
            double d12 = itemEntity.m_20189_() - centreZ;
            double horizDiffSq = Mth.m_14116_((float)((float)(diffX * diffX + diffZ * diffZ)));
            double angle = Math.asin(diffX / horizDiffSq);
            double d15 = Math.abs((double)Mth.m_14031_((float)((float)angle)) * 0.05);
            double d16 = Math.abs((double)Mth.m_14089_((float)((float)angle)) * 0.05);
            d15 = diffX <= 0.0 ? -d15 : d15;
            double d = d16 = diffZ <= 0.0 ? -d16 : d16;
            if (itemEntity.m_20184_().m_82526_(itemEntity.m_20184_()) >= 0.2) continue;
            itemEntity.m_20334_(d15, diffY >= 0.7 ? 0.1 : itemEntity.m_20184_().m_7098_(), d16);
        }
    }

    public boolean insertStackFromEntity(ItemEntity entityItem) {
        boolean succesful = false;
        if (entityItem == null || !entityItem.m_6084_()) {
            return false;
        }
        ItemStack itemstack = entityItem.m_32055_().m_41777_();
        ItemStack itemstack1 = this.addItem(itemstack);
        if (!itemstack1.m_41619_()) {
            entityItem.m_32045_(itemstack1);
        } else {
            succesful = true;
            entityItem.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return succesful;
    }

    public ItemStack addItem(ItemStack stack) {
        ItemStack itemstack = stack.m_41777_();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemstack1 = this.m_8020_(i);
            if (itemstack1.m_41619_()) {
                this.m_6836_(i, itemstack);
                this.m_6596_();
                return ItemStack.f_41583_;
            }
            if (!ItemStack.m_41746_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            int j = Math.min(this.m_6893_(), itemstack1.m_41741_());
            int k = Math.min(itemstack.m_41613_(), j - itemstack1.m_41613_());
            if (k <= 0) continue;
            itemstack1.m_41769_(k);
            itemstack.m_41774_(k);
            if (!itemstack.m_41619_()) continue;
            this.m_6596_();
            return ItemStack.f_41583_;
        }
        if (itemstack.m_41613_() != stack.m_41613_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.trapcraft.magnetic_chest");
    }
}

