/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import trapcraft.api.ConfigValues;

public class ConfigHandler {
    private static ClientConfig CLIENT;
    private static ServerConfig SERVER;
    private static ForgeConfigSpec CONFIG_SERVER_SPEC;
    private static ForgeConfigSpec CONFIG_CLIENT_SPEC;

    public static void init(IEventBus eventBus) {
        Pair commonPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        CONFIG_SERVER_SPEC = (ForgeConfigSpec)commonPair.getRight();
        SERVER = (ServerConfig)commonPair.getLeft();
        Pair clientPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CONFIG_CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (ClientConfig)clientPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CONFIG_SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CONFIG_CLIENT_SPEC);
    }

    public static void refreshServer() {
        ConfigValues.FAN_RANGE = (Integer)ConfigHandler.SERVER.FAN_RANGE.get();
        ConfigValues.FAN_ACCELERATION = (Double)ConfigHandler.SERVER.FAN_ACCELERATION.get();
        ConfigValues.FAN_MAX_SPEED = (Double)ConfigHandler.SERVER.FAN_MAX_SPEED.get();
    }

    public static void refreshClient() {
    }

    static class ServerConfig {
        public ForgeConfigSpec.IntValue FAN_RANGE;
        public ForgeConfigSpec.DoubleValue FAN_ACCELERATION;
        public ForgeConfigSpec.DoubleValue FAN_MAX_SPEED;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            this.FAN_RANGE = builder.comment("The distance at which entities are pushed by the fan.").translation("trapcraft.config.fan_range").defineInRange("fan_range", 5, 0, 64);
            this.FAN_ACCELERATION = builder.comment("The rate at which velocity is added to entities.").translation("trapcraft.config.fan_acceleration").defineInRange("fan_acceleration", 0.05, 0.01, 1.0);
            this.FAN_MAX_SPEED = builder.comment("The max velocity entities can be given by a fan.").translation("trapcraft.config.fan_max_speed").defineInRange("fan_max_speed", 0.3, 0.01, 1.0);
        }
    }

    static class ClientConfig {
        public ClientConfig(ForgeConfigSpec.Builder builder) {
        }
    }
}

