/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.data;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import trapcraft.TrapcraftBlocks;
import trapcraft.TrapcraftItems;

public class TrapcraftItemModelProvider
extends ItemModelProvider {
    public TrapcraftItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "trapcraft", existingFileHelper);
    }

    @Nonnull
    public String m_6055_() {
        return "Trapcraft Item Models";
    }

    protected void registerModels() {
        this.generated((Supplier<? extends ItemLike>)TrapcraftItems.IGNITER_RANGE, "_upgrade");
        this.blockSprite((Supplier<? extends Block>)TrapcraftBlocks.SPIKES);
        this.blockItem((Supplier<? extends Block>)TrapcraftBlocks.FAN);
        this.blockItem((Supplier<? extends Block>)TrapcraftBlocks.IGNITER);
        this.blockItem((Supplier<? extends Block>)TrapcraftBlocks.BEAR_TRAP, "_open");
        this.blockItem((Supplier<? extends Block>)TrapcraftBlocks.GRASS_COVERING);
        this.chest((Supplier<? extends ItemLike>)TrapcraftBlocks.MAGNETIC_CHEST, (Supplier<? extends Block>)Blocks.f_50705_.delegate);
    }

    private ResourceLocation itemTexture(Supplier<? extends ItemLike> item) {
        return this.modLoc("item/" + this.name(item));
    }

    private ResourceLocation blockTexture(Supplier<? extends Block> block) {
        ResourceLocation base = block.get().getRegistryName();
        return new ResourceLocation(base.m_135827_(), "block/" + base.m_135815_());
    }

    private String name(Supplier<? extends ItemLike> item) {
        return item.get().m_5456_().getRegistryName().m_135815_();
    }

    private ItemModelBuilder blockSprite(Supplier<? extends Block> block) {
        return this.generated(block, this.blockTexture(block));
    }

    private ItemModelBuilder blockItem(Supplier<? extends Block> block) {
        return this.blockItem(block, "");
    }

    private ItemModelBuilder generated(Supplier<? extends ItemLike> item) {
        return this.generated(item, this.itemTexture(item));
    }

    private ItemModelBuilder generated(Supplier<? extends ItemLike> item, String suffix) {
        return this.generated(item, this.extend(this.itemTexture(item), suffix));
    }

    private ItemModelBuilder generated(Supplier<? extends ItemLike> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.name(item))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
    }

    private ItemModelBuilder chest(Supplier<? extends ItemLike> item, Supplier<? extends Block> particle) {
        return this.chest(item, this.blockTexture(particle));
    }

    private ItemModelBuilder chest(Supplier<? extends ItemLike> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.name(item))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/chest"))).texture("particle", texture);
    }

    private ItemModelBuilder blockItem(Supplier<? extends Block> block, String suffix) {
        return (ItemModelBuilder)this.withExistingParent(this.name(block), this.modLoc("block/" + this.name(block) + suffix));
    }

    private ResourceLocation extend(ResourceLocation rl, String suffix) {
        return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
    }
}

