/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import trapcraft.TrapcraftBlocks;
import trapcraft.TrapcraftEntityTypes;

public class TrapcraftLootTableProvider
extends LootTableProvider {
    public TrapcraftLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Nonnull
    public String m_6055_() {
        return "Trapcraft LootTables";
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(Entities::new, (Object)LootContextParamSets.f_81415_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationTracker) {
    }

    private static class Entities
    extends EntityLoot {
        private Entities() {
        }

        protected void addTables() {
            this.registerLootTable((Supplier<? extends EntityType<?>>)TrapcraftEntityTypes.DUMMY, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42748_)).m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.5f, (float)0.0625f))));
        }

        protected void registerLootTable(Supplier<? extends EntityType<?>> type, LootTable.Builder table) {
            this.m_124380_(type.get().m_20677_(), table);
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return TrapcraftEntityTypes.ENTITIES.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }

    private static class Blocks
    extends BlockLoot {
        private Blocks() {
        }

        protected void addTables() {
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.FAN);
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.MAGNETIC_CHEST);
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.BEAR_TRAP);
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.SPIKES);
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.IGNITER);
            this.droppingWithSilkTouchOrItemInRange((Supplier<? extends Block>)TrapcraftBlocks.GRASS_COVERING, (Supplier<? extends ItemLike>)Items.f_42398_.delegate, (NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f));
        }

        private void dropsSelf(Supplier<? extends Block> block) {
            this.m_124288_(block.get());
        }

        private void droppingWithSilkTouchOrItemInRange(Supplier<? extends Block> block, Supplier<? extends ItemLike> dropItem, NumberProvider range) {
            this.m_124175_(block.get(), b -> Blocks.m_176042_((Block)b, (ItemLike)((ItemLike)dropItem.get()), (NumberProvider)range));
        }

        protected Iterable<Block> getKnownBlocks() {
            return TrapcraftBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

