/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class BreakBlockMessage {
    public int targetX;
    public int targetY;
    public int targetZ;

    public BreakBlockMessage() {
    }

    public BreakBlockMessage(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public static BreakBlockMessage decode(PacketBuffer buf) {
        BreakBlockMessage msg = new BreakBlockMessage();
        msg.targetX = buf.readInt();
        msg.targetY = buf.readInt();
        msg.targetZ = buf.readInt();
        return msg;
    }

    public static void encode(BreakBlockMessage message, PacketBuffer buf) {
        buf.writeInt(message.targetX);
        buf.writeInt(message.targetY);
        buf.writeInt(message.targetZ);
    }

    public static class Handler {
        public static void handle(BreakBlockMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                player.field_70170_p.func_175655_b(new BlockPos(message.targetX, message.targetY, message.targetZ), true);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }
}

