/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="ultimate_unicorn_mod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public int knightVagabondSpawnChance;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final List<ConfigDefault> configDefaults;
    public static File downloadDir;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        Path p = event.getConfig().getFullPath();
        Path configDir = p.getParent();
        try {
            boolean success;
            Path downloadPath = configDir.resolve("ultimate_unicorn_download");
            downloadDir = downloadPath.toFile();
            if (!downloadDir.exists() && !(success = downloadDir.mkdir())) {
                downloadDir = configDir.toFile();
            }
        }
        catch (InvalidPathException e) {
            downloadDir = configDir.toFile();
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading event) {
    }

    static {
        configDefaults = Arrays.asList(new ConfigDefault("unicorn", 40, 2, 4, Biomes.field_76767_f.func_240901_a_().toString(), Biomes.field_150583_P.func_240901_a_().toString(), Biomes.field_150582_Q.func_240901_a_().toString(), Biomes.field_185448_Z.func_240901_a_().toString()), new ConfigDefault("unicorn_secondary", 15, 1, 2, Biomes.field_76772_c.func_240901_a_().toString(), Biomes.field_150585_R.func_240901_a_().toString(), Biomes.field_185430_ab.func_240901_a_().toString()), new ConfigDefault("pegasus", 20, 1, 4, Biomes.field_76787_r.func_240901_a_().toString(), Biomes.field_76786_s.func_240901_a_().toString(), Biomes.field_76770_e.func_240901_a_().toString(), Biomes.field_76783_v.func_240901_a_().toString()), new ConfigDefault("pegasus_secondary", 10, 1, 3, Biomes.field_76772_c.func_240901_a_().toString()), new ConfigDefault("destrier", 20, 1, 3, Biomes.field_76768_g.func_240901_a_().toString(), Biomes.field_150577_O.func_240901_a_().toString(), Biomes.field_150584_S.func_240901_a_().toString(), Biomes.field_76784_u.func_240901_a_().toString(), Biomes.field_150579_T.func_240901_a_().toString(), Biomes.field_76777_m.func_240901_a_().toString(), Biomes.field_76774_n.func_240901_a_().toString()), new ConfigDefault("destrier_secondary", 8, 1, 1, Biomes.field_150585_R.func_240901_a_().toString()), new ConfigDefault("nightmare", 20, 1, 3, Biomes.field_76769_d.func_240901_a_().toString(), Biomes.field_76786_s.func_240901_a_().toString(), Biomes.field_185442_R.func_240901_a_().toString()), new ConfigDefault("nightmare_secondary", 10, 1, 1, Biomes.field_76770_e.func_240901_a_().toString(), Biomes.field_185443_S.func_240901_a_().toString(), Biomes.field_150589_Z.func_240901_a_().toString()), new ConfigDefault("hippocamp", 20, 2, 5, Biomes.field_76771_b.func_240901_a_().toString(), Biomes.field_150575_M.func_240901_a_().toString(), Biomes.field_76787_r.func_240901_a_().toString()), new ConfigDefault("hippocamp_secondary", 10, 1, 2, Biomes.field_76781_i.func_240901_a_().toString(), Biomes.field_76780_h.func_240901_a_().toString(), Biomes.field_150599_m.func_240901_a_().toString(), Biomes.field_203614_T.func_240901_a_().toString(), Biomes.field_203615_U.func_240901_a_().toString(), Biomes.field_203616_V.func_240901_a_().toString()), new ConfigDefault("kirin", 8, 1, 2, Biomes.field_185445_W.func_240901_a_().toString(), Biomes.field_76770_e.func_240901_a_().toString(), Biomes.field_76783_v.func_240901_a_().toString(), Biomes.field_150587_Y.func_240901_a_().toString(), Biomes.field_76792_x.func_240901_a_().toString(), Biomes.field_185448_Z.func_240901_a_().toString()), new ConfigDefault("kirin_secondary", 6, 1, 1, Biomes.field_150589_Z.func_240901_a_().toString(), Biomes.field_76776_l.func_240901_a_().toString(), Biomes.field_185435_ag.func_240901_a_().toString(), Biomes.field_185436_ah.func_240901_a_().toString(), Biomes.field_185437_ai.func_240901_a_().toString(), Biomes.field_185442_R.func_240901_a_().toString()), new ConfigDefault("deer", 20, 2, 5, Biomes.field_150584_S.func_240901_a_().toString(), Biomes.field_150579_T.func_240901_a_().toString(), Biomes.field_76784_u.func_240901_a_().toString(), Biomes.field_76768_g.func_240901_a_().toString(), Biomes.field_76767_f.func_240901_a_().toString(), Biomes.field_185444_T.func_240901_a_().toString(), Biomes.field_150583_P.func_240901_a_().toString(), Biomes.field_150582_Q.func_240901_a_().toString()), new ConfigDefault("deer_secondary", 5, 1, 2, Biomes.field_76772_c.func_240901_a_().toString()), new ConfigDefault("hippogriff", 10, 1, 2, Biomes.field_150579_T.func_240901_a_().toString(), Biomes.field_76784_u.func_240901_a_().toString(), Biomes.field_150587_Y.func_240901_a_().toString(), Biomes.field_76770_e.func_240901_a_().toString(), Biomes.field_76783_v.func_240901_a_().toString(), Biomes.field_185430_ab.func_240901_a_().toString()), new ConfigDefault("hippogriff_secondary", 5, 1, 1, Biomes.field_222370_aw.func_240901_a_().toString(), Biomes.field_222371_ax.func_240901_a_().toString(), Biomes.field_150589_Z.func_240901_a_().toString()), new ConfigDefault("asmidiske", 1, 1, 1, Biomes.field_76770_e.func_240901_a_().toString(), Biomes.field_150608_ab.func_240901_a_().toString()), new ConfigDefault("asmidiske_secondary", 1, 1, 1, Biomes.field_185444_T.func_240901_a_().toString(), Biomes.field_185441_Q.func_240901_a_().toString()));
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    static class ConfigEntityData {
        ForgeConfigSpec.IntValue spawnWeight;
        ForgeConfigSpec.IntValue minInGroup;
        ForgeConfigSpec.IntValue maxInGroup;
        ForgeConfigSpec.ConfigValue<List<String>> biomes;

        ConfigEntityData() {
        }
    }

    static class ConfigDefault {
        final ArrayList<String> biomes;
        final String name;
        final int weight;
        final int min;
        final int max;

        public ConfigDefault(String name, int weight, int min, int max, String ... biomes) {
            this.name = name;
            this.weight = weight;
            this.min = min;
            this.max = max;
            this.biomes = new ArrayList<String>(Arrays.asList(biomes));
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue disable_notifications;
        public final ForgeConfigSpec.BooleanValue suppress_nightmare_fire;
        public final ForgeConfigSpec.BooleanValue gentle_nightmare_fire;
        public final ForgeConfigSpec.BooleanValue horses_cannot_suffocate;
        public final ForgeConfigSpec.BooleanValue disable_fire_wand;
        public final ForgeConfigSpec.BooleanValue disable_lightning_wand;
        public final ForgeConfigSpec.BooleanValue disable_dropsy_wand;
        public final ForgeConfigSpec.BooleanValue disable_all_custom_horse_powers;
        public final ForgeConfigSpec.BooleanValue suppress_kirin_fire;
        public final ForgeConfigSpec.BooleanValue suppress_bunnies;
        public final ForgeConfigSpec.BooleanValue suppress_auras;
        public final ForgeConfigSpec.BooleanValue unridden_horses_break_blocks;
        public final ForgeConfigSpec.BooleanValue unridden_destriers_break_leaves;
        public final ForgeConfigSpec.BooleanValue horse_rearing_hurts_friendlies;
        public final ForgeConfigSpec.BooleanValue use_old_horse_health_max;
        public final ForgeConfigSpec.BooleanValue horses_attack_monsters;
        public final ForgeConfigSpec.BooleanValue horses_attack_pigmen;
        public final ForgeConfigSpec.BooleanValue show_stirrups;
        public final ForgeConfigSpec.BooleanValue use_typhon_alternate_skin;
        public final ForgeConfigSpec.BooleanValue output_biomes;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> speech_texts;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> speech_urls;
        public final ForgeConfigSpec.IntValue max_bunnies;
        public final ForgeConfigSpec.IntValue region_id;
        public final HashMap<String, ConfigEntityData> entityConfigs = new HashMap();
        public final ForgeConfigSpec.IntValue max_zombie_minions;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Ultimate Unicorn Mod Configuration").push("ultimate_unicorn_mod");
            this.speech_texts = builder.comment("A set of file paths pointing to JSON files containing speech texts (like for the oracle)").worldRestart().define("speech_texts", new ArrayList());
            this.speech_urls = builder.comment("A set of URLs pointing to JSON-structured speech texts (like for the oracle) on the internet").worldRestart().define("speech_urls", new ArrayList());
            this.disable_notifications = builder.comment("This disables notifications.").translation("ultimate_unicorn.configgui.disable_notifications").worldRestart().define("disable_notifications", false);
            this.suppress_nightmare_fire = builder.comment("If true, Nightmares will not make fire where they walk.").translation("ultimate_unicorn.configgui.suppress_nightmare_fire").worldRestart().define("suppress_nightmare_fire", false);
            this.gentle_nightmare_fire = builder.comment("If true, fire made by Nightmares doesn't hurt or spread.").translation("ultimate_unicorn.configgui.gentle_nightmare_fire").worldRestart().define("gentle_nightmare_fire", true);
            this.horses_cannot_suffocate = builder.comment("If true, a magic horse won't suffocate when its head is in a wall. Set to true if you have this kind of problems.").translation("ultimate_unicorn.configgui.horses_cannot_suffocate").worldRestart().define("horses_cannot_suffocate", false);
            this.disable_fire_wand = builder.comment("If true, Wand of Fireball items do nothing.").translation("ultimate_unicorn.configgui.disable_fire_wand").worldRestart().define("disable_fire_wand", false);
            this.disable_lightning_wand = builder.comment("If true, Wand of Call Lightning items do nothing.").translation("ultimate_unicorn.configgui.disable_lightning_wand").worldRestart().define("disable_lightning_wand", false);
            this.disable_dropsy_wand = builder.comment("If true, Wand of Dropsies items do nothing.").translation("ultimate_unicorn.configgui.disable_dropsy_wand").worldRestart().define("disable_dropsy_wand", false);
            this.disable_all_custom_horse_powers = builder.comment("If true, custom horse powers cannot be used.").translation("ultimate_unicorn.configgui.disable_all_custom_horse_powers").worldRestart().define("disable_all_custom_horse_powers", false);
            this.suppress_kirin_fire = builder.comment("If true, Kirin will not be able to use their breath weapon.").translation("ultimate_unicorn.configgui.suppress_kirin_fire").worldRestart().define("suppress_kirin_fire", false);
            this.suppress_bunnies = builder.comment("If true, Velvet, Mystical Healer will be unable to summon bunnies.").translation("ultimate_unicorn.configgui.suppress_bunnies").worldRestart().define("suppress_bunnies", false);
            this.suppress_auras = builder.comment("Turns off aura sparkles for unicorns.").translation("ultimate_unicorn.configgui.suppress_auras").worldRestart().define("suppress_auras", false);
            this.unridden_horses_break_blocks = builder.comment("If true, unridden destriers and other big horses can break blocks when they rear (or Typhon charges).").translation("ultimate_unicorn.configgui.unridden_horses_break_blocks").worldRestart().define("unridden_horses_break_blocks", true);
            this.unridden_destriers_break_leaves = builder.comment("If true, unridden destriers and other big horses can break leaves (and other wimpy things) by walking into them.").translation("ultimate_unicorn.configgui.unridden_destriers_break_leaves").worldRestart().define("unridden_destriers_break_leaves", true);
            this.horse_rearing_hurts_friendlies = builder.comment("If true, rearing horses can hurt players and other nice creatures.").translation("ultimate_unicorn.configgui.horse_rearing_hurts_friendlies").worldRestart().define("horse_rearing_hurts_friendlies", true);
            this.use_old_horse_health_max = builder.comment("If true, magical horses will have higher max health, like in the old days.").translation("ultimate_unicorn.configgui.use_old_horse_health_max").worldRestart().define("use_old_horse_health_max", false);
            this.horses_attack_monsters = builder.comment("If true, horses will attack monsters they don't like when not ridden.").translation("ultimate_unicorn.configgui.horses_attack_monsters").worldRestart().define("horses_attack_monsters", true);
            this.horses_attack_pigmen = builder.comment("If true, horses will attack zombie pigmen when not ridden.").translation("ultimate_unicorn.configgui.horses_attack_pigmen").worldRestart().define("horses_attack_pigmen", true);
            this.show_stirrups = builder.comment("Show Stirrups on Magical Horses.").translation("ultimate_unicorn.configgui.show_stirrups").worldRestart().define("show_stirrups", false);
            this.use_typhon_alternate_skin = builder.comment("Use alternate \"fiery\" skin for Typhon.").translation("ultimate_unicorn.configgui.use_typhon_alternate_skin").worldRestart().define("use_typhon_alternate_skin", false);
            this.output_biomes = builder.comment("Output biomes names on startup.").translation("ultimate_unicorn.configgui.output_biomes").worldRestart().define("output_biomes", false);
            this.max_bunnies = builder.comment("Max bunnies allowed in Velvet 's entourage.").translation("ultimate_unicorn.configgui.max_bunnies").worldRestart().defineInRange("max_bunnies", 5, 0, 100);
            this.max_zombie_minions = builder.comment("Max zombie minions allowed for Typhon to have summoned at once.").translation("ultimate_unicorn.configgui.max_zombie_minions").worldRestart().defineInRange("max_zombie_minions", 5, 0, 100);
            this.region_id = builder.comment("Region ID").translation("ultimate_unicorn.configgui.region_id").worldRestart().defineInRange("region_id", MathHelper.func_76136_a((Random)new Random(), (int)0, (int)3), 0, 3);
            for (ConfigDefault cd : configDefaults) {
                ConfigEntityData data = new ConfigEntityData();
                builder.comment("entity: " + cd.name);
                builder.push(cd.name);
                data.spawnWeight = builder.comment("Weighted value that determines how often a group of this entity will spawn in its biome compared to other creatures.").translation("ultimate_unicorn.configgui." + cd.name + "_spawn_weight").worldRestart().defineInRange(cd.name + "_spawn_weight", cd.weight, 0, 500);
                data.minInGroup = builder.comment("Weighted percent probability the entity type will spawn in its biome.").translation("ultimate_unicorn.configgui." + cd.name + "_spawn_min_in_group").worldRestart().defineInRange(cd.name + "_spawn_min_in_group", cd.min, 0, 20);
                data.maxInGroup = builder.comment("Weighted percent probability the entity type will spawn in its biome.").translation("ultimate_unicorn.configgui." + cd.name + "_spawn_max_in_group").worldRestart().defineInRange(cd.name + "_spawn_max_in_group", cd.max, 0, 20);
                data.biomes = builder.comment("Biomes this entity type can spawn in.").translation("ultimate_unicorn.configgui." + cd.name + "_spawn_in_biomes").worldRestart().define(cd.name + "_spawn_in_biomes", cd.biomes);
                builder.pop();
                this.entityConfigs.put(cd.name, data);
            }
            builder.pop();
        }
    }
}

