/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn;

import com.hackshop.ultimate_unicorn.chat.ai.DialogAI;
import com.hackshop.ultimate_unicorn.chat.ai.StringPair;
import com.hackshop.ultimate_unicorn.gui.GuiAIChat;
import com.hackshop.ultimate_unicorn.network.PacketHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class DialogMessage {
    String aiName;
    String text;
    String tempToken;
    int npcUniqueId;
    boolean toClient;

    public DialogMessage(String text, String aiName, int npcUniqueId, String tempToken) {
        this.text = text;
        this.aiName = aiName;
        this.npcUniqueId = npcUniqueId;
        this.toClient = false;
        this.tempToken = tempToken == null ? "" : tempToken;
    }

    public DialogMessage(String text, String aiName, boolean toClient) {
        this.text = text;
        this.aiName = aiName;
        this.npcUniqueId = 0;
        this.toClient = toClient;
        this.tempToken = "";
    }

    public DialogMessage(String text, String aiName, int npcUniqueId, String tempToken, boolean toClient) {
        this.text = text;
        this.aiName = aiName;
        this.npcUniqueId = npcUniqueId;
        this.toClient = toClient;
        this.tempToken = tempToken == null ? "" : tempToken;
    }

    public static DialogMessage decode(PacketBuffer buf) {
        return new DialogMessage(buf.func_150789_c(1000), buf.func_150789_c(1000), buf.readInt(), buf.func_150789_c(1000), buf.readBoolean());
    }

    public static void encode(DialogMessage message, PacketBuffer buf) {
        buf.func_180714_a(message.text);
        buf.func_180714_a(message.aiName);
        buf.writeInt(message.npcUniqueId);
        buf.func_180714_a(message.tempToken);
        buf.writeBoolean(message.toClient);
    }

    public static class Handler {
        public static void handle(DialogMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (message.toClient) {
                    GuiAIChat gaic = (GuiAIChat)Minecraft.func_71410_x().field_71462_r;
                    gaic.receiveTextField.func_146180_a(message.text);
                    gaic.tempToken = message.tempToken;
                } else {
                    ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                    String name = message.aiName.toLowerCase();
                    DialogAI dialogAI = DialogAI.getDialogAI(name);
                    if (dialogAI != null) {
                        StringPair resp = dialogAI.getResponse(message.text, message.npcUniqueId, message.tempToken, null, (PlayerEntity)player);
                        PacketHandler.INSTANCE.sendTo((Object)new DialogMessage(resp.text, name, message.npcUniqueId, resp.token, true), ((NetworkEvent.Context)ctx.get()).getNetworkManager(), NetworkDirection.PLAY_TO_CLIENT);
                    }
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }
}

