/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.network.NetworkEvent;

public class MagicEffectMessage {
    public String text = "magic";
    public int entityId = -1;
    public BasicParticleType particleId1 = ParticleTypes.field_197590_A;
    public BasicParticleType particleId2 = null;
    public int amount1 = 1;
    public int amount2 = 1;
    public float val1 = 0.0f;
    public float val2 = 0.0f;
    public float val3 = 0.0f;
    public float val4 = 0.0f;
    public float val5 = 0.0f;
    public float val6 = 0.0f;

    public MagicEffectMessage() {
    }

    public MagicEffectMessage(int entityId, BasicParticleType particleId1, BasicParticleType particleId2) {
        this.entityId = entityId;
        this.particleId1 = particleId1;
        this.particleId2 = particleId2;
    }

    public MagicEffectMessage(int entityId, BasicParticleType particleId1) {
        this.entityId = entityId;
        this.particleId1 = particleId1;
    }

    public MagicEffectMessage(int entityId) {
        this.entityId = entityId;
    }

    public static MagicEffectMessage decode(PacketBuffer buf) {
        MagicEffectMessage msg = new MagicEffectMessage();
        msg.text = buf.func_150789_c(100);
        msg.entityId = buf.readInt();
        msg.particleId1 = MagicEffectMessage.getParticle(buf.func_150789_c(100));
        msg.particleId2 = MagicEffectMessage.getParticle(buf.func_150789_c(100));
        msg.amount1 = buf.func_150792_a();
        msg.amount2 = buf.func_150792_a();
        msg.val1 = buf.readFloat();
        msg.val2 = buf.readFloat();
        msg.val3 = buf.readFloat();
        msg.val4 = buf.readFloat();
        msg.val5 = buf.readFloat();
        msg.val6 = buf.readFloat();
        return msg;
    }

    private static BasicParticleType getParticle(String particleTypeKey) {
        if ("particalTypeKey".equals("null")) {
            return null;
        }
        Optional p = Registry.field_212632_u.func_241873_b(new ResourceLocation(particleTypeKey));
        return (BasicParticleType)p.get();
    }

    public static void encode(MagicEffectMessage message, PacketBuffer buf) {
        buf.func_180714_a(message.text);
        buf.writeInt(message.entityId);
        buf.func_180714_a(message.particleId1 != null ? message.particleId1.func_197555_a() : "null");
        buf.func_180714_a(message.particleId2 != null ? message.particleId2.func_197555_a() : "null");
        buf.func_150787_b(message.amount1);
        buf.func_150787_b(message.amount2);
        buf.writeFloat(message.val1);
        buf.writeFloat(message.val2);
        buf.writeFloat(message.val3);
        buf.writeFloat(message.val4);
        buf.writeFloat(message.val5);
        buf.writeFloat(message.val6);
    }

    public static class Handler {
        public static void handle(MagicEffectMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
                if (null != entity) {
                    int repeatNum1 = message.amount1 * 2;
                    int repeatNum2 = message.amount2 * 2;
                    if (message.particleId2 != null) {
                        int i;
                        for (i = 0; i < repeatNum1; ++i) {
                            entity.field_70170_p.func_195594_a((IParticleData)message.particleId1, entity.func_226277_ct_() + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213311_cf()) - (double)entity.func_213311_cf(), entity.func_226278_cu_() + 0.5 + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213302_cg()), entity.func_226281_cx_() + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213311_cf()) - (double)entity.func_213311_cf(), (double)message.val1, (double)message.val2, (double)message.val3);
                        }
                        for (i = 0; i < repeatNum2; ++i) {
                            entity.field_70170_p.func_195594_a((IParticleData)message.particleId2, entity.func_226277_ct_() + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213311_cf()) - (double)entity.func_213311_cf(), entity.func_226278_cu_() + 0.5 + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213302_cg()), entity.func_226281_cx_() + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213311_cf()) - (double)entity.func_213311_cf(), (double)message.val4, (double)message.val5, (double)message.val6);
                        }
                    } else {
                        for (int i = 0; i < repeatNum1; ++i) {
                            entity.field_70170_p.func_195594_a((IParticleData)message.particleId1, entity.func_226277_ct_() + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213311_cf()) - (double)entity.func_213311_cf(), entity.func_226278_cu_() + 0.5 + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213302_cg()), entity.func_226281_cx_() + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213311_cf()) - (double)entity.func_213311_cf(), (double)message.val1, (double)message.val2, (double)message.val3);
                        }
                    }
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }
}

