/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn;

import com.hackshop.ultimate_unicorn.init.ModItems;
import com.hackshop.ultimate_unicorn.items.ItemWandOfCallLightning;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ShootWandMessage {
    private String text;
    private BlockPos targetPos = null;

    public ShootWandMessage() {
        this.text = "shoot";
    }

    public ShootWandMessage(BlockPos targetPos) {
        this.text = null != targetPos ? "shoot" : "shoot_miss";
        this.targetPos = targetPos;
    }

    public static void encode(ShootWandMessage message, PacketBuffer buf) {
        buf.func_180714_a(message.text);
        buf.func_179255_a(message.targetPos);
    }

    public static ShootWandMessage decode(PacketBuffer buf) {
        ShootWandMessage msg = new ShootWandMessage();
        msg.text = buf.func_150789_c(100);
        msg.targetPos = buf.func_179259_c();
        return msg;
    }

    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public static class Handler {
        public static void handle(ShootWandMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ((ItemWandOfCallLightning)ModItems.WAND_OF_CALL_LIGHTNING.get()).shoot(player.func_184586_b(Hand.MAIN_HAND), player.field_70170_p, (LivingEntity)player, message.getTargetPos());
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }
}

