/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn;

import com.hackshop.ultimate_unicorn.CombinedClientProxy;
import com.hackshop.ultimate_unicorn.Config;
import com.hackshop.ultimate_unicorn.DedicatedServerProxy;
import com.hackshop.ultimate_unicorn.IProxy;
import com.hackshop.ultimate_unicorn.QuestConfig;
import com.hackshop.ultimate_unicorn.UpdateChecker;
import com.hackshop.ultimate_unicorn.blocks.ContainerMagicalHorseInventory;
import com.hackshop.ultimate_unicorn.commands.ChangeHorseCommand;
import com.hackshop.ultimate_unicorn.commands.DialogCommand;
import com.hackshop.ultimate_unicorn.commands.ModelCommand;
import com.hackshop.ultimate_unicorn.gui.ChatFormatting;
import com.hackshop.ultimate_unicorn.gui.TextUtil;
import com.hackshop.ultimate_unicorn.init.ModBlocks;
import com.hackshop.ultimate_unicorn.init.ModContainerTypes;
import com.hackshop.ultimate_unicorn.init.ModEntities;
import com.hackshop.ultimate_unicorn.init.ModItems;
import com.hackshop.ultimate_unicorn.init.ModTileEntityTypes;
import com.hackshop.ultimate_unicorn.mobs.EntityDeer;
import com.hackshop.ultimate_unicorn.mobs.EntityDestrier;
import com.hackshop.ultimate_unicorn.mobs.EntityFollowerBunny;
import com.hackshop.ultimate_unicorn.mobs.EntityHippocamp;
import com.hackshop.ultimate_unicorn.mobs.EntityHippogriff;
import com.hackshop.ultimate_unicorn.mobs.EntityKirin;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.EntityNightmare;
import com.hackshop.ultimate_unicorn.mobs.EntityPegasus;
import com.hackshop.ultimate_unicorn.mobs.EntityUnicorn;
import com.hackshop.ultimate_unicorn.mobs.EntityZombieMinion;
import com.hackshop.ultimate_unicorn.mobs.unique.EntityAleaBringerOfDawn;
import com.hackshop.ultimate_unicorn.mobs.unique.EntityAsmidiske;
import com.hackshop.ultimate_unicorn.mobs.unique.EntityTyphonTheDestroyer;
import com.hackshop.ultimate_unicorn.mobs.unique.EntityVelvetMysticalHealer;
import com.hackshop.ultimate_unicorn.network.PacketHandler;
import com.hackshop.ultimate_unicorn.util.OpenUnicornInventory;
import com.mojang.brigadier.CommandDispatcher;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ultimate_unicorn_mod")
public class UltimateUnicornMod {
    public static UltimateUnicornMod instance;
    private static String currentModVersion;
    private static String currentMinecraftVersion;
    public static final String MODID = "ultimate_unicorn_mod";
    public static IProxy proxy;
    public static boolean welcomeDone;
    public static final Logger LOGGER;

    public UltimateUnicornMod() {
        LOGGER.debug("The Ultimate Unicorn Mod!");
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_SPEC, "ultimate_unicorn_mod.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, QuestConfig.COMMON_SPEC, "uu_vars.toml");
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::processIMC);
        modEventBus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.addListener(this::doServerStuff);
        modEventBus.addListener(this::handleConfig);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModContainerTypes.CONTAINER_TYPES.register(modEventBus);
        ModTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
    }

    public static String getCurrentModVersion() {
        return currentModVersion;
    }

    public static String getCurrentMinecraftVersion() {
        return currentMinecraftVersion;
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
        LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.field_150346_d.getRegistryName());
        DeferredWorkQueue.runLater(() -> {
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.FOLLOWER_BUNNY.get()), (AttributeModifierMap)EntityFollowerBunny.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.ZOMBIE_MINION.get()), (AttributeModifierMap)EntityZombieMinion.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.MAGICAL_HORSE.get()), (AttributeModifierMap)EntityMagicalHorse.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.UNICORN.get()), (AttributeModifierMap)EntityUnicorn.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.PEGASUS.get()), (AttributeModifierMap)EntityPegasus.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.DESTRIER.get()), (AttributeModifierMap)EntityDestrier.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.NIGHTMARE.get()), (AttributeModifierMap)EntityNightmare.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.HIPPOCAMP.get()), (AttributeModifierMap)EntityHippocamp.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.KIRIN.get()), (AttributeModifierMap)EntityKirin.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.DEER.get()), (AttributeModifierMap)EntityDeer.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.HIPPOGRIFF.get()), (AttributeModifierMap)EntityHippogriff.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.TYPHON.get()), (AttributeModifierMap)EntityTyphonTheDestroyer.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.ALEA.get()), (AttributeModifierMap)EntityAleaBringerOfDawn.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.VELVET.get()), (AttributeModifierMap)EntityVelvetMysticalHealer.setCustomAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.ASMIDISKE.get()), (AttributeModifierMap)EntityAsmidiske.setCustomAttributes().func_233813_a_());
        });
        PacketHandler.register();
    }

    @SubscribeEvent
    public void handleConfig(ModConfig.ModConfigEvent event) {
        ModContainer container;
        Optional optContainer = ModList.get().getModContainerById(MODID);
        Optional mcOptContainer = ModList.get().getModContainerById("minecraft");
        if (optContainer.isPresent()) {
            container = (ModContainer)optContainer.get();
            currentModVersion = container.getModInfo().getVersion().toString();
            System.out.println("Ultimate Unicorn Mod version: " + currentModVersion);
        }
        if (mcOptContainer.isPresent()) {
            container = (ModContainer)mcOptContainer.get();
            currentMinecraftVersion = container.getModInfo().getVersion().toString();
            System.out.println("Minecraft version: " + currentMinecraftVersion);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        if (((Boolean)Config.COMMON.output_biomes.get()).booleanValue()) {
            System.out.println("Loading Biome: " + event.getName().toString());
        }
        Config.ConfigEntityData ced = Config.COMMON.entityConfigs.get("unicorn");
        this.addSpawn(event, (EntityType)ModEntities.UNICORN.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("unicorn_secondary");
        this.addSpawn(event, (EntityType)ModEntities.UNICORN.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("pegasus");
        this.addSpawn(event, (EntityType)ModEntities.PEGASUS.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("pegasus_secondary");
        this.addSpawn(event, (EntityType)ModEntities.PEGASUS.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("destrier");
        this.addSpawn(event, (EntityType)ModEntities.DESTRIER.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("destrier_secondary");
        this.addSpawn(event, (EntityType)ModEntities.DESTRIER.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("nightmare");
        this.addSpawn(event, (EntityType)ModEntities.NIGHTMARE.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("nightmare_secondary");
        this.addSpawn(event, (EntityType)ModEntities.NIGHTMARE.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("hippocamp");
        this.addSpawn(event, (EntityType)ModEntities.HIPPOCAMP.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("hippocamp_secondary");
        this.addSpawn(event, (EntityType)ModEntities.HIPPOCAMP.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("kirin");
        this.addSpawn(event, (EntityType)ModEntities.KIRIN.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("kirin_secondary");
        this.addSpawn(event, (EntityType)ModEntities.KIRIN.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("deer");
        this.addSpawn(event, (EntityType)ModEntities.DEER.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("deer_secondary");
        this.addSpawn(event, (EntityType)ModEntities.DEER.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("hippogriff");
        this.addSpawn(event, (EntityType)ModEntities.HIPPOGRIFF.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("hippogriff_secondary");
        this.addSpawn(event, (EntityType)ModEntities.HIPPOGRIFF.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("asmidiske");
        this.addSpawn(event, (EntityType)ModEntities.ASMIDISKE.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
        ced = Config.COMMON.entityConfigs.get("asmidiske_secondary");
        this.addSpawn(event, (EntityType)ModEntities.ASMIDISKE.get(), (Integer)ced.spawnWeight.get(), (Integer)ced.minInGroup.get(), (Integer)ced.maxInGroup.get(), (List)ced.biomes.get());
    }

    private void addSpawn(BiomeLoadingEvent event, EntityType<?> entityType, int weight, int minInGroup, int maxInGroup, List<String> biomeKeys) {
        if (weight > 0 && maxInGroup > 0) {
            MobSpawnInfoBuilder builder = event.getSpawns();
            if (biomeKeys.stream().anyMatch(x -> x.equals(event.getName().toString()))) {
                builder.getSpawner(entityType.func_220339_d()).add(new MobSpawnInfo.Spawners(entityType, weight, minInGroup, maxInGroup));
                if (EntitySpawnPlacementRegistry.func_209344_a(entityType) == EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS) {
                    EntitySpawnPlacementRegistry.func_209343_a(entityType, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
                }
            }
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        proxy.setup();
    }

    private void doServerStuff(FMLServerStartingEvent event) {
        if (proxy instanceof DedicatedServerProxy) {
            proxy.setup();
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
        CommandDispatcher commandDispatcher = event.getServer().func_195571_aL().func_197054_a();
        ChangeHorseCommand.register((CommandDispatcher<CommandSource>)commandDispatcher);
        ModelCommand.register((CommandDispatcher<CommandSource>)commandDispatcher);
        DialogCommand.register((CommandDispatcher<CommandSource>)commandDispatcher);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!welcomeDone && !((Boolean)Config.COMMON.disable_notifications.get()).booleanValue()) {
            welcomeDone = true;
            UpdateChecker.UpdateProperties props = UpdateChecker.getProperties();
            if (UpdateChecker.isNewVersionAvailable()) {
                TextUtil.FormattedUrlChatMessage fucMsg;
                int j;
                String[] rawMsgs;
                if (null != props && null != props.getNewVersionMessage()) {
                    rawMsgs = props.getNewVersionMessage();
                    for (j = 0; j < rawMsgs.length; ++j) {
                        fucMsg = TextUtil.formatUrlChatMessage(rawMsgs[j]);
                        this.sendMessage(fucMsg.formattedMessage, fucMsg.url);
                    }
                } else {
                    LanguageMap langMap = LanguageMap.func_74808_a();
                    String newVersion = LanguageMap.func_74808_a().func_230503_a_("inventoryUI.newVersion");
                    String newVersion2 = LanguageMap.func_74808_a().func_230503_a_("inventoryUI.newVersion2");
                    String newVersion3 = "http://hackshop.com/download";
                    this.sendMessage(newVersion, newVersion3);
                    this.sendMessage(newVersion2 + " " + (Object)((Object)ChatFormatting.RED) + newVersion3, newVersion3);
                }
                if (null != props && null != props.getWhatsNewMessage()) {
                    rawMsgs = props.getWhatsNewMessage();
                    for (j = 0; j < rawMsgs.length; ++j) {
                        fucMsg = TextUtil.formatUrlChatMessage(rawMsgs[j]);
                        this.sendMessage(fucMsg.formattedMessage, fucMsg.url);
                    }
                } else {
                    String hackshopAd = LanguageMap.func_74808_a().func_230503_a_("inventoryUI.whatsNew");
                    String hackshopAd2 = "http://hackshop.com/new";
                    this.sendMessage(hackshopAd + " " + (Object)((Object)ChatFormatting.RED) + hackshopAd2, hackshopAd2);
                }
            }
            if (null != props && props.getStartupMessageCount() > 0) {
                for (int i = 0; i < props.getStartupMessageCount(); ++i) {
                    String[] rawMsgs = props.getStartupMessage(i);
                    for (int j = 0; j < rawMsgs.length; ++j) {
                        TextUtil.FormattedUrlChatMessage fucMsg = TextUtil.formatUrlChatMessage(rawMsgs[j]);
                        this.sendMessage(fucMsg.formattedMessage, fucMsg.url);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void sendMessage(String message, String url) {
        StringTextComponent t = new StringTextComponent(message);
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)t);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openUrl(URI uri) {
        try {
            Util.func_110647_a().func_195642_a(uri);
        }
        catch (Throwable throwable) {
            LOGGER.error("Couldn't open link", throwable);
        }
    }

    static {
        currentModVersion = null;
        currentMinecraftVersion = null;
        proxy = (IProxy)DistExecutor.runForDist(() -> () -> new CombinedClientProxy(), () -> () -> new DedicatedServerProxy());
        welcomeDone = false;
        LOGGER = LogManager.getLogger((String)MODID);
    }

    @Mod.EventBusSubscriber
    public static class CommonEvents {
        @SubscribeEvent
        public static void containerOpen(OpenUnicornInventory event) {
            if (event.getContainer() instanceof ContainerMagicalHorseInventory) {
                LOGGER.info("Open Inventory");
                ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
                ContainerMagicalHorseInventory oldContainer = (ContainerMagicalHorseInventory)event.getContainer();
                EntityMagicalHorse unicorn = oldContainer.getUnicorn();
                IInventory horseInventory = oldContainer.getHorseInventory();
                if (player != null && unicorn != null && horseInventory != null) {
                    player.field_71070_bA = new ContainerMagicalHorseInventory(player.field_71139_cq, player.field_71071_by, horseInventory, unicorn);
                    player.field_71070_bA.func_75132_a((IContainerListener)player);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }
    }
}

