/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn;

import com.hackshop.ultimate_unicorn.CommonProxy;
import com.hackshop.ultimate_unicorn.Config;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import uushadoworg.joda.time.DateTime;

public class UpdateChecker {
    private static volatile boolean newVersionAvailable = false;
    private static volatile UpdateProperties props;

    public static boolean isNewVersionAvailable() {
        return newVersionAvailable;
    }

    public static UpdateProperties getProperties() {
        return props;
    }

    public static void checkVersion(String currMinecraftVersion, String currModVersion) {
        Thread checkThread = new Thread(new CheckRunnable(currMinecraftVersion, currModVersion));
        checkThread.start();
    }

    public static boolean isMd5Different(String firstLetter, String md5) {
        if (null == props) {
            return false;
        }
        String val = props.getProperty(firstLetter);
        return !md5.equals(val);
    }

    public static class UpdateProperties {
        private final Properties props;
        private int messageCount = 0;
        private int startupMessageCount = 0;
        private String[][] messageLines = new String[4][];
        private int[] messageOffsets = new int[]{0, 0, 0, 0};
        private String[][] startupLines = new String[2][];
        private String[] newVersionLines;
        private String[] whatsNewLines;

        public UpdateProperties(Properties props) {
            int i;
            this.props = props;
            for (i = 0; i < this.messageLines.length && this.assignMessage(i); ++i) {
            }
            for (i = 0; i < this.startupLines.length && this.assignStartupMessage(i); ++i) {
            }
            String tempMessage = props.getProperty("newVersionMessage");
            if (null != tempMessage && tempMessage.trim().length() > 0) {
                this.newVersionLines = tempMessage.split("\n");
            }
            if (null != (tempMessage = props.getProperty("whatsNewMessage")) && tempMessage.trim().length() > 0) {
                this.whatsNewLines = tempMessage.split("\n");
            }
        }

        private boolean assignMessage(int index) {
            String tempMessage = this.props.getProperty("message" + index);
            String tempOffset = this.props.getProperty("message" + index + "Offset");
            if (null != tempMessage && tempMessage.trim().length() > 0) {
                this.messageLines[index] = tempMessage.split("\n");
                try {
                    this.messageOffsets[index] = Integer.parseInt(tempOffset);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ++this.messageCount;
                return true;
            }
            return false;
        }

        private boolean assignStartupMessage(int index) {
            String tempMessage = this.props.getProperty("startupLine" + index);
            if (null != tempMessage && tempMessage.trim().length() > 0) {
                this.startupLines[index] = tempMessage.split("\n");
                ++this.startupMessageCount;
                return true;
            }
            return false;
        }

        public String getLatestVersion() {
            return this.props.getProperty("latest_version");
        }

        public int getMessageCount() {
            return this.messageCount;
        }

        public int getStartupMessageCount() {
            return this.startupMessageCount;
        }

        public String[] getMessage(int num) {
            return this.messageLines[num];
        }

        public int getMessageOffset(int num) {
            return this.messageOffsets[num];
        }

        public String[] getStartupMessage(int num) {
            return this.startupLines[num];
        }

        public String[] getNewVersionMessage() {
            return this.newVersionLines;
        }

        public String[] getWhatsNewMessage() {
            return this.whatsNewLines;
        }

        public String getProperty(String key) {
            return this.props.getProperty(key);
        }
    }

    static class CheckRunnable
    implements Runnable {
        public final String currMinecraftVer;
        public final String currModVer;

        public CheckRunnable(String currMinecraftVersion, String currModVersion) {
            this.currMinecraftVer = currMinecraftVersion;
            this.currModVer = currModVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("Getting properties for region " + Config.COMMON.region_id.get());
            String updateUrl = CommonProxy.updateInfoUrls[(Integer)Config.COMMON.region_id.get()];
            InputStream is = null;
            try {
                DateTime latestUpdateDate;
                URL url = new URL(updateUrl);
                is = url.openStream();
                Properties plainProps = new Properties();
                plainProps.load(is);
                props = new UpdateProperties(plainProps);
                String latestVer = plainProps.getProperty("latest_version_" + this.currMinecraftVer);
                String forceNotify = plainProps.getProperty("force_notify_" + this.currMinecraftVer);
                String latestUpdateDateStr = plainProps.getProperty("update_date_version_" + this.currMinecraftVer);
                boolean withinTime = false;
                if (latestUpdateDateStr != null && (latestUpdateDate = DateTime.parse(latestUpdateDateStr)) != null && latestUpdateDate.plusDays(7).isAfter(DateTime.now())) {
                    withinTime = true;
                }
                if (null != latestVer) {
                    if (withinTime || forceNotify != null && forceNotify.equals("true")) {
                        if (!this.currModVer.equals(latestVer.trim())) {
                            System.out.println("There is a new version of Wings, Horns, and Hooves, the Ultimate Unicorn Mod available.");
                            System.out.println("Current Ultimate Unicorn Version: " + this.currModVer);
                            System.out.println("Latest Version: " + latestVer);
                            newVersionAvailable = true;
                        } else {
                            System.out.println("Wings, Horns, and Hooves, the Ultimate Unicorn Mod is up to date.");
                        }
                    } else {
                        System.out.println("Wings, Horns, and Hooves, the Ultimate Unicorn Mod has an update, but is no longer notifying about that update.");
                    }
                } else {
                    System.out.println("latestVer = null, badly formatted update_info file?");
                }
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException mue) {}
            }
        }
    }
}

