/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.blocks;

import com.hackshop.ultimate_unicorn.Config;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FireBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockNightmareFire
extends FireBlock {
    public static final String name = "nightmare_fire_block";

    public BlockNightmareFire(AbstractBlock.Properties props) {
        super(props.func_200944_c().func_200942_a().func_200944_c().func_200943_b(0.0f).func_235838_a_(state -> 15).func_200947_a(SoundType.field_185854_g).func_222380_e());
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        int i;
        if (worldIn.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            if (!worldIn.isAreaLoaded(pos, 2)) {
                return;
            }
            if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
                worldIn.func_217377_a(pos, false);
            }
            Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
            BlockState other = worldIn.func_180495_p(pos.func_177977_b());
            boolean flag = other.isFireSource((IWorldReader)worldIn, pos.func_177977_b(), Direction.UP);
            int i2 = (Integer)state.func_177229_b((Property)field_176543_a);
            if (!flag && worldIn.func_72896_J() && this.func_176537_d((World)worldIn, pos) && rand.nextFloat() < 0.2f + (float)i2 * 0.07f) {
                worldIn.func_217377_a(pos, false);
            } else {
                boolean flag1;
                int k;
                int j = Math.min(15, i2 + rand.nextInt(3) / 2);
                if (i2 != j) {
                    state = (BlockState)state.func_206870_a((Property)field_176543_a, (Comparable)Integer.valueOf(j));
                    worldIn.func_180501_a(pos, state, 4);
                }
                if (!flag) {
                    worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 30 + rand.nextInt(10));
                    if (!this.areNeighborsFlammable((IBlockReader)worldIn, pos)) {
                        BlockPos blockpos = pos.func_177977_b();
                        if (!worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) && i2 > 1 || i2 > 2) {
                            worldIn.func_217377_a(pos, false);
                        }
                        return;
                    }
                    if (i2 > 5 && rand.nextInt(3) == 0 && !this.canCatchFire((IBlockReader)worldIn, pos.func_177977_b(), Direction.UP)) {
                        worldIn.func_217377_a(pos, false);
                        return;
                    }
                }
                int n = k = (flag1 = worldIn.func_180502_D(pos)) ? -50 : 0;
                if (!((Boolean)Config.COMMON.gentle_nightmare_fire.get()).booleanValue()) {
                    this.tryCatchFire((World)worldIn, pos.func_177974_f(), 300 + k, rand, i2, Direction.WEST);
                    this.tryCatchFire((World)worldIn, pos.func_177976_e(), 300 + k, rand, i2, Direction.EAST);
                    this.tryCatchFire((World)worldIn, pos.func_177977_b(), 250 + k, rand, i2, Direction.UP);
                    this.tryCatchFire((World)worldIn, pos.func_177984_a(), 250 + k, rand, i2, Direction.DOWN);
                    this.tryCatchFire((World)worldIn, pos.func_177978_c(), 300 + k, rand, i2, Direction.SOUTH);
                    this.tryCatchFire((World)worldIn, pos.func_177968_d(), 300 + k, rand, i2, Direction.NORTH);
                }
                BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
                for (int l = -1; l <= 1; ++l) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            if (l == 0 && j1 == 0 && i1 == 0) continue;
                            int k1 = 100;
                            if (j1 > 1) {
                                k1 += (j1 - 1) * 100;
                            }
                            blockpos$mutable.func_189533_g((Vector3i)pos).func_196234_d(l, j1, i1);
                            int l1 = this.getNeighborEncouragement((IWorldReader)worldIn, (BlockPos)blockpos$mutable);
                            if (l1 <= 0) continue;
                            int i22 = (l1 + 40 + worldIn.func_175659_aa().func_151525_a() * 7) / (i2 + 30);
                            if (flag1) {
                                i22 /= 2;
                            }
                            if (i22 <= 0 || rand.nextInt(k1) > i22 || worldIn.func_72896_J() && this.func_176537_d((World)worldIn, (BlockPos)blockpos$mutable)) continue;
                            int j2 = Math.min(15, i2 + rand.nextInt(5) / 4);
                            worldIn.func_180501_a((BlockPos)blockpos$mutable, (BlockState)this.func_196448_a((IBlockReader)worldIn, (BlockPos)blockpos$mutable).func_206870_a((Property)field_176543_a, (Comparable)Integer.valueOf(j2)), 3);
                        }
                    }
                }
            }
        }
        if ((i = ((Integer)state.func_177229_b((Property)field_176543_a)).intValue()) > 3) {
            worldIn.func_217377_a(pos, false);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 30 + worldIn.field_73012_v.nextInt(10));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return worldIn.func_180495_p(blockpos).isAir((IBlockReader)worldIn, blockpos) || worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) || this.areNeighborsFlammable((IBlockReader)worldIn, pos);
    }

    private void tryCatchFire(World worldIn, BlockPos pos, int chance, Random random, int age, Direction face) {
        int i = worldIn.func_180495_p(pos).getFlammability((IBlockReader)worldIn, pos, face);
        if (random.nextInt(chance) < i) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            if (random.nextInt(age + 10) < 5 && !worldIn.func_175727_C(pos)) {
                int j = Math.min(age + random.nextInt(5) / 4, 15);
                worldIn.func_180501_a(pos, (BlockState)this.func_196448_a((IBlockReader)worldIn, pos).func_206870_a((Property)field_176543_a, (Comparable)Integer.valueOf(j)), 3);
            } else {
                worldIn.func_217377_a(pos, false);
            }
            blockstate.catchFire(worldIn, pos, face, (LivingEntity)null);
        }
    }

    public void func_196262_a(BlockState blockState, World world, BlockPos blockPos, Entity entity) {
        EntityMagicalHorse horse;
        Entity vehicle = entity.func_184187_bx();
        if (vehicle != null && vehicle instanceof EntityMagicalHorse && (horse = (EntityMagicalHorse)vehicle).getIsImmuneToFire()) {
            return;
        }
        if (entity instanceof EntityMagicalHorse && (horse = (EntityMagicalHorse)entity).getIsImmuneToFire()) {
            return;
        }
        super.func_196262_a(blockState, world, blockPos, entity);
    }

    private boolean areNeighborsFlammable(IBlockReader worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(worldIn, pos.func_177972_a(direction), direction.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(IWorldReader worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
            i = Math.max(blockstate.getFlammability((IBlockReader)worldIn, pos.func_177972_a(direction), direction.func_176734_d()), i);
        }
        return i / 4;
    }

    public String getMyName() {
        return name;
    }

    public boolean isBurning(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)Config.COMMON.gentle_nightmare_fire.get() == false;
    }
}

