/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.chat.ai;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.hackshop.ultimate_unicorn.Config;
import com.hackshop.ultimate_unicorn.UltimateUnicornMod;
import com.hackshop.ultimate_unicorn.UpdateChecker;
import com.hackshop.ultimate_unicorn.chat.ai.DeserializeNullChecker;
import com.hackshop.ultimate_unicorn.chat.ai.Responses;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uushadowio.gsonfire.GsonFireBuilder;

public class AILoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String[] supportedLangs = new String[]{"en_us"};
    private static final Pattern mappingFilePattern = Pattern.compile("(.*)_(\\p{Alpha}{2}_\\p{Alpha}{2})(\\..*)?");
    private static final SimpleReloadableResourceManager resources = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA);
    private static volatile ConcurrentHashMap<String, HashMap<String, Responses>> langMappings = new ConcurrentHashMap<String, HashMap<String, Responses>>(){

        @Override
        public HashMap<String, Responses> get(Object key) {
            if (null == super.get(key)) {
                return (HashMap)super.get("en_us");
            }
            return (HashMap)super.get(key);
        }
    };
    static final GsonFireBuilder builder = new GsonFireBuilder().registerPostProcessor(Object.class, new DeserializeNullChecker());
    static final Gson SERIALIZER = builder.createGson();
    private static String ALL_LANGUAGES = "ALL_LANGUAGES";

    private static void load(String userText, HashMap<String, ArrayList<EntitySpeechMappings>> langToCustomMappings, Loader isLoader) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(isLoader.get(userText)));
            StringBuilder builder = AILoader.readFrom(reader);
            if (builder != null) {
                EntitySpeechMappings entitySpeechMappings = (EntitySpeechMappings)SERIALIZER.fromJson(builder.toString(), EntitySpeechMappings.class);
                Matcher m = mappingFilePattern.matcher(userText);
                String lang = ALL_LANGUAGES;
                if (entitySpeechMappings.language != null && !entitySpeechMappings.language.trim().equals("")) {
                    lang = entitySpeechMappings.language;
                } else if (m.matches()) {
                    lang = m.group(2).toLowerCase();
                }
                ArrayList speechMappings = langToCustomMappings.computeIfAbsent(lang, x -> new ArrayList());
                speechMappings.add(entitySpeechMappings);
            }
        }
        catch (JsonParseException | IOException e) {
            UltimateUnicornMod.LOGGER.error("Error loading speech file: " + userText + "\n Reason: " + e.getMessage());
        }
    }

    public static void loadAll() {
        Optional pack = ResourcePackLoader.getResourcePackFor((String)"ultimate_unicorn_mod");
        resources.func_199021_a((IResourcePack)pack.get());
        Thread loadThread = new Thread(new LoadRunner());
        loadThread.start();
    }

    private static StringBuilder readFrom(BufferedReader reader) {
        StringBuilder builder = new StringBuilder();
        try {
            String inputLine;
            while ((inputLine = reader.readLine()) != null) {
                builder.append(inputLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return builder;
    }

    public static Responses getResponsesFor(String name) {
        String lang = "en_us";
        HashMap<String, Responses> nameToResponses = langMappings.get(lang);
        if (nameToResponses != null) {
            return nameToResponses.get(name);
        }
        return null;
    }

    private static class LoadRunner
    implements Runnable {
        private LoadRunner() {
        }

        @Override
        public void run() {
            String speechProp;
            System.out.println("LoadRunner started");
            HashMap langToCustomMappings = new HashMap();
            ((ArrayList)Config.COMMON.speech_texts.get()).forEach(userText -> AILoader.load(userText, langToCustomMappings, x -> new FileInputStream(x)));
            ((ArrayList)Config.COMMON.speech_urls.get()).forEach(userText -> AILoader.load(userText, langToCustomMappings, x -> new URL(x).openStream()));
            UpdateChecker.UpdateProperties updateProps = UpdateChecker.getProperties();
            if (updateProps != null && (speechProp = updateProps.getProperty("speechUrls")) != null) {
                String[] speechUrls = speechProp.split(" ");
                Arrays.stream(speechUrls).forEach(speechUrl -> AILoader.load(speechUrl, langToCustomMappings, x -> new URL(x).openStream()));
            }
            for (String lang : supportedLangs) {
                ArrayList<Object> entitySpeechMappings = new ArrayList<Object>();
                ResourceLocation speechText = new ResourceLocation("ultimate_unicorn_mod", "texts/dialogs_" + lang + ".json");
                try {
                    IResource r = resources.func_199002_a(speechText);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(r.func_199027_b()));
                    StringBuilder builder = AILoader.readFrom(reader);
                    if (builder != null) {
                        entitySpeechMappings.add(SERIALIZER.fromJson(builder.toString(), EntitySpeechMappings.class));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ArrayList addThese = (ArrayList)langToCustomMappings.get(ALL_LANGUAGES);
                if (addThese != null) {
                    entitySpeechMappings.addAll(addThese);
                }
                if ((addThese = (ArrayList)langToCustomMappings.get(lang)) != null) {
                    entitySpeechMappings.addAll(addThese);
                }
                HashMap<String, ArrayList> nameToSpeechMappings = new HashMap<String, ArrayList>();
                HashMap nameToAliases = new HashMap();
                entitySpeechMappings.forEach((Consumer<Object>)((Consumer<EntitySpeechMappings>)entitySpeechMapping -> entitySpeechMapping.entityMappings.forEach((name, speechMapping) -> {
                    ArrayList storedMappings = nameToSpeechMappings.computeIfAbsent((String)name, x -> new ArrayList());
                    nameToAliases.put(name, speechMapping.aliases);
                    storedMappings.add(speechMapping);
                })));
                HashMap nameToResponses = new HashMap();
                try {
                    nameToSpeechMappings.forEach((name, speechMappings) -> {
                        Responses r = new Responses((ArrayList<SpeechMapping>)speechMappings);
                        nameToResponses.put(name, r);
                        String[] aliases = (String[])nameToAliases.get(name);
                        if (aliases != null) {
                            Arrays.stream(aliases).forEach(alias -> nameToResponses.put(alias, r));
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                langMappings.put(lang, nameToResponses);
            }
            System.out.println("LoadRunner ended");
        }
    }

    static interface Loader {
        public InputStream get(String var1) throws IOException;
    }

    static class EntitySpeechMappings {
        String language;
        @DeserializeNullChecker.DeserializeNonNull
        HashMap<String, SpeechMapping> entityMappings;

        EntitySpeechMappings() {
        }
    }

    static class SpeechMapping {
        String[] randomNames;
        String opener;
        String defaultResponse;
        LogicalResponse[] defaultLogicalChecks;
        String[] aliases;
        Mapping[] mappings;

        SpeechMapping() {
        }
    }

    static class LogicalResponse {
        VarPair[] requiresVars;
        LocPair[] requiresHolding;
        String requiresTempToken;
        VarPair[] setsVars;
        Action[] actions;
        String response;
        String setsTempToken;
        String negativeResponse;
        String negativeResponseVar;
        String negativeResponseHolding;

        LogicalResponse() {
        }
    }

    static class Mapping {
        LogicalResponse[] logicalResponses;
        String tieBreaker;
        String[] simple_keys;
        String[] logic_keys;
        String[] phrase_keys;
        String[] actions;

        Mapping() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Mapping: ");
            if (this.simple_keys != null) {
                builder.append("\nsimple keys: ");
                Arrays.stream(this.simple_keys).forEach(x -> builder.append(" \"").append((String)x).append("\""));
            }
            if (this.logic_keys != null) {
                builder.append("\nlogic keys: ");
                Arrays.stream(this.logic_keys).forEach(x -> builder.append(" \"").append((String)x).append("\""));
            }
            if (this.phrase_keys != null) {
                builder.append("\nphrase keys: ");
                Arrays.stream(this.phrase_keys).forEach(x -> builder.append(" \"").append((String)x).append("\""));
            }
            return builder.toString();
        }
    }

    public static class Action {
        public String name;
        public String[] args;
    }

    public static class LocPair {
        public String loc;
        public String item;
        public int amount = 1;
    }

    public static class VarPair {
        public String key;
        public String value;

        public VarPair personalize(String name) {
            VarPair newPair = new VarPair();
            newPair.key = this.key.startsWith("$") ? this.key : name + "." + this.key;
            newPair.value = this.value;
            return newPair;
        }
    }
}

