/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.chat.ai;

import com.hackshop.ultimate_unicorn.QuestConfig;
import com.hackshop.ultimate_unicorn.chat.ai.AILoader;
import com.hackshop.ultimate_unicorn.chat.ai.Responses;
import com.hackshop.ultimate_unicorn.chat.ai.StringPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;

public class DialogAI {
    final String name;
    final Random random = new Random();

    public static DialogAI getDialogAI(String n) {
        if (DialogAI.hasDialogAI(n)) {
            return new DialogAI(n);
        }
        return null;
    }

    public static boolean hasDialogAI(String n) {
        return AILoader.getResponsesFor(n) != null;
    }

    private DialogAI(String name) {
        this.name = name;
    }

    public String getDefaultResponse() {
        Responses r = AILoader.getResponsesFor(this.name);
        if (r != null) {
            return r.defaultResponse;
        }
        return "";
    }

    public String getConversationStarter() {
        Responses r = AILoader.getResponsesFor(this.name);
        if (r != null) {
            if (r.opener != null) {
                return r.opener;
            }
            return r.defaultResponse;
        }
        return "";
    }

    public String getConversationEnder() {
        return "";
    }

    public StringPair getResponse(String userSaid, int npcUniqueId, String tempToken, Container container, PlayerEntity player) {
        String[] actions;
        Responses responses = AILoader.getResponsesFor(this.name);
        if (responses == null) {
            return new StringPair("", "");
        }
        String lowercase = userSaid.toLowerCase();
        String[] words = lowercase.split("\\s+");
        StringPair logicalNegativeResponse = this.evaluateDefaultLogicalResponses(responses.defaultLogicalChecks, npcUniqueId, tempToken, container, player);
        for (Map.Entry<String, Responses.LogicalResponses> entry : responses.phrasesToResponses.entrySet()) {
            if (!lowercase.contains(entry.getKey())) continue;
            if (logicalNegativeResponse != null) {
                return logicalNegativeResponse;
            }
            return this.evaluateLogicalResponses(entry.getValue(), npcUniqueId, tempToken, container, player);
        }
        for (Map.Entry<String, Responses.LogicalResponses> entry : responses.setsToResponses.entrySet()) {
            boolean found = true;
            for (String k : (String[])entry.getKey()) {
                if (lowercase.contains(k)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            if (logicalNegativeResponse != null) {
                return logicalNegativeResponse;
            }
            return this.evaluateLogicalResponses(entry.getValue(), npcUniqueId, tempToken, container, player);
        }
        if (userSaid.endsWith("()") && (actions = responses.wordsToActions.get(userSaid.substring(0, userSaid.length() - 2))) != null) {
            Arrays.stream(actions).forEach(x -> {
                if (x.equals("reload")) {
                    AILoader.loadAll();
                }
                if (x.equals("set")) {
                    QuestConfig.setVar("magic_1", "blah");
                }
            });
            return new StringPair("Done.", "");
        }
        for (String word : words) {
            String trimmedWord = word.trim().toLowerCase();
            Responses.LogicalResponses logicalResponses = responses.wordsToResponses.get(trimmedWord);
            if (null != logicalResponses) {
                if (logicalNegativeResponse != null) {
                    return logicalNegativeResponse;
                }
                return this.evaluateLogicalResponses(logicalResponses, npcUniqueId, tempToken, container, player);
            }
            if (trimmedWord.endsWith("s") && null != (logicalResponses = responses.wordsToResponses.get(trimmedWord.substring(0, trimmedWord.length() - 1)))) {
                if (logicalNegativeResponse != null) {
                    return logicalNegativeResponse;
                }
                return this.evaluateLogicalResponses(logicalResponses, npcUniqueId, tempToken, container, player);
            }
            if (!trimmedWord.endsWith("es") || null == (logicalResponses = responses.wordsToResponses.get(trimmedWord.substring(0, trimmedWord.length() - 2)))) continue;
            if (logicalNegativeResponse != null) {
                return logicalNegativeResponse;
            }
            return this.evaluateLogicalResponses(logicalResponses, npcUniqueId, tempToken, container, player);
        }
        return new StringPair(responses.defaultResponse, "");
    }

    private StringPair evaluateDefaultLogicalResponses(Responses.LogicalResponses logicalResponses, int npcUniqueId, String tempToken, Container container, PlayerEntity player) {
        StringPair negativeResponse = null;
        if ("random".equals(logicalResponses.tieBreaker)) {
            ArrayList<StringPair> winners = new ArrayList<StringPair>();
            for (Responses.Response response : logicalResponses.responses) {
                Responses.BooleanText retText = response.getText(npcUniqueId, tempToken, container, player);
                if (retText.positive) continue;
                winners.add(retText.getNegativeText());
            }
            if (winners.size() > 0) {
                int choice = this.random.nextInt(winners.size());
                negativeResponse = (StringPair)winners.get(choice);
            }
        } else {
            for (Responses.Response response : logicalResponses.responses) {
                Responses.BooleanText retText = response.getText(npcUniqueId, tempToken, container, player);
                if (retText.positive || retText.getNegativeText() == null) continue;
                negativeResponse = retText.getNegativeText();
            }
        }
        return negativeResponse;
    }

    private StringPair evaluateLogicalResponses(Responses.LogicalResponses logicalResponses, int npcUniqueId, String tempToken, Container container, PlayerEntity player) {
        StringPair negativeResponse = new StringPair("I don't know about that....", "");
        if ("random".equals(logicalResponses.tieBreaker)) {
            ArrayList<Responses.BooleanText> winners = new ArrayList<Responses.BooleanText>();
            for (Responses.Response response : logicalResponses.responses) {
                Responses.BooleanText retText = response.getText(npcUniqueId, tempToken, container, player);
                if (retText.positive) {
                    winners.add(retText);
                    continue;
                }
                if (retText.getNegativeText() == null || retText.getNegativeText().text == null || retText.getNegativeText().text.equals("")) continue;
                negativeResponse = retText.getNegativeText();
            }
            if (winners.size() > 0) {
                int choice = this.random.nextInt(winners.size());
                Responses.BooleanText chosen = (Responses.BooleanText)winners.get(choice);
                return chosen.execute();
            }
        } else {
            for (Responses.Response response : logicalResponses.responses) {
                Responses.BooleanText retText = response.getText(npcUniqueId, tempToken, container, player);
                if (retText.positive) {
                    return retText.execute();
                }
                if (retText.getNegativeText() == null || retText.getNegativeText().text == null || retText.getNegativeText().text.equals("")) continue;
                negativeResponse = retText.getNegativeText();
            }
        }
        return negativeResponse;
    }
}

