/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.chat.ai;

import com.hackshop.ultimate_unicorn.chat.ai.Responses;
import java.util.HashMap;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DialogActions {
    public static HashMap<String, Action> actions = new HashMap();

    public static Result execute(String name, String[] args, Responses.InvPosition invPos, Container container, PlayerInventory playerInventory) {
        Action a = actions.get(name);
        if (a != null) {
            return a.execute(invPos, container, playerInventory, args);
        }
        return new Result("I did not know how to perform an action: " + name);
    }

    static {
        actions.put("give", (invPos, container, playerInventory, args) -> {
            boolean success;
            int amount = 1;
            String itemName = "";
            String hoverText = null;
            if (args != null) {
                if (args.length > 0) {
                    try {
                        itemName = args[0];
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                if (args.length > 1) {
                    try {
                        amount = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
                if (args.length > 2) {
                    try {
                        hoverText = args[2];
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            }
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("id", itemName);
            nbt.func_74774_a("Count", (byte)amount);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt);
            if (stack.func_190926_b()) {
                return new Result("Huh, I couldn't find the item I wanted to give you. Maybe it doesn't actually exist? Yeah, I'm confused, too. You should definitely report this to someone.");
            }
            if (hoverText != null) {
                stack.func_200302_a((ITextComponent)new StringTextComponent(hoverText));
            }
            if (!(success = playerInventory.func_70441_a(stack))) {
                return new Result("I could not give you an item. Maybe your inventory is full?");
            }
            return new Result();
        });
        actions.put("take", (invPos, container, playerInventory, args) -> {
            int amount = 1;
            if (args != null && args.length > 0) {
                try {
                    amount = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if (invPos != null) {
                ItemStack stack = null;
                switch (invPos.loc) {
                    case "selected": {
                        stack = playerInventory.func_70298_a(playerInventory.field_70461_c, amount);
                        if (stack.func_190926_b()) break;
                        return new Result();
                    }
                    case "offhand": {
                        stack = playerInventory.func_70298_a(playerInventory.func_70302_i_() - 1, amount);
                        if (stack.func_190926_b()) break;
                        return new Result();
                    }
                    case "inventory": {
                        stack = playerInventory.func_70298_a(invPos.pos, amount);
                        if (stack.func_190926_b()) break;
                        return new Result();
                    }
                }
            }
            return new Result("I could not take the selected item from your inventory...");
        });
        actions.put("findAndTake", (invPos, container, playerInventory, args) -> {
            ItemStack stack;
            int amount = 1;
            String itemType = "";
            if (args != null) {
                if (args.length > 0) {
                    itemType = args[0];
                }
                if (args.length > 1) {
                    try {
                        amount = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            }
            int total = 0;
            for (int i = 0; !(i >= playerInventory.field_70462_a.size() || (stack = (ItemStack)playerInventory.field_70462_a.get(i)).func_77977_a().equals(itemType) && (total += stack.func_190916_E()) >= amount); ++i) {
            }
            ItemStack stack2 = (ItemStack)playerInventory.field_184439_c.get(0);
            if (total < amount && stack2.func_77977_a().equals(itemType)) {
                total += stack2.func_190916_E();
            }
            if (total >= amount) {
                ItemStack removedStack;
                int totalTaken = 0;
                for (int i = 0; i < playerInventory.field_70462_a.size(); ++i) {
                    ItemStack removedStack2;
                    stack2 = (ItemStack)playerInventory.field_70462_a.get(i);
                    if (!stack2.func_77977_a().equals(itemType) || (removedStack2 = playerInventory.func_70298_a(i, amount - totalTaken)).func_190926_b() || (totalTaken += removedStack2.func_190916_E()) < amount) continue;
                    return new Result();
                }
                stack2 = (ItemStack)playerInventory.field_184439_c.get(0);
                if (stack2.func_77977_a().equals(itemType) && !(removedStack = playerInventory.func_70298_a(playerInventory.func_70302_i_() - 1, amount - totalTaken)).func_190926_b() && (totalTaken += removedStack.func_190916_E()) >= amount) {
                    return new Result();
                }
            }
            return new Result("I could not take the selected item from your inventory...");
        });
    }

    public static interface Action {
        public Result execute(Responses.InvPosition var1, Container var2, PlayerInventory var3, String ... var4);
    }

    public static class Result {
        public final boolean success;
        public final String failMessage;

        public Result(String failMessage) {
            this.success = false;
            this.failMessage = failMessage;
        }

        public Result() {
            this.success = true;
            this.failMessage = "";
        }
    }
}

