/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.chat.ai;

import com.hackshop.ultimate_unicorn.QuestConfig;
import com.hackshop.ultimate_unicorn.chat.ai.AILoader;
import com.hackshop.ultimate_unicorn.chat.ai.DialogActions;
import com.hackshop.ultimate_unicorn.chat.ai.StringPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;

class Responses {
    public final ArrayList<String> randomNames;
    public final String opener;
    public final String defaultResponse;
    public final LogicalResponses defaultLogicalChecks;
    public final HashMap<String, LogicalResponses> wordsToResponses = new HashMap();
    public final HashMap<String, String[]> wordsToActions = new HashMap();
    public final HashMap<String, LogicalResponses> phrasesToResponses = new HashMap();
    public final HashMap<String[], LogicalResponses> setsToResponses = new HashMap();

    Responses(ArrayList<AILoader.SpeechMapping> speechMappings) {
        String tempDefaultResponse = "";
        String tempOpener = null;
        this.randomNames = new ArrayList();
        LogicalResponses builtLogicalChecks = new LogicalResponses("ordered", new ArrayList<Response>());
        for (AILoader.SpeechMapping speechMapping : speechMappings) {
            if (speechMapping.defaultLogicalChecks != null) {
                for (AILoader.LogicalResponse lr : speechMapping.defaultLogicalChecks) {
                    Response response = new Response(this, lr.response, lr.requiresTempToken, lr.setsTempToken, lr.requiresVars, lr.requiresHolding, lr.negativeResponse, lr.negativeResponseVar, lr.negativeResponseHolding, lr.setsVars, lr.actions);
                    builtLogicalChecks.responses.add(response);
                }
            }
            if (speechMapping == null) continue;
            for (AILoader.Mapping m : speechMapping.mappings) {
                if (null == m) continue;
                if (null != m.actions) {
                    for (String s : m.actions) {
                        this.wordsToActions.put(s, m.actions);
                    }
                    continue;
                }
                ArrayList<Response> arrayList = new ArrayList<Response>();
                if (m.logicalResponses == null) {
                    System.out.println("Error: logicalResponses is null for mapping: " + m);
                } else {
                    for (AILoader.LogicalResponse lr : m.logicalResponses) {
                        Response response = new Response(this, lr.response, lr.requiresTempToken, lr.setsTempToken, lr.requiresVars, lr.requiresHolding, lr.negativeResponse, lr.negativeResponseVar, lr.negativeResponseHolding, lr.setsVars, lr.actions);
                        arrayList.add(response);
                    }
                }
                LogicalResponses logicalResponses = new LogicalResponses(m.tieBreaker, arrayList);
                if (null != m.simple_keys) {
                    for (String s : m.simple_keys) {
                        this.wordsToResponses.put(s, logicalResponses);
                    }
                }
                if (null != m.phrase_keys) {
                    for (String s : m.phrase_keys) {
                        this.phrasesToResponses.put(s, logicalResponses);
                    }
                }
                if (null == m.logic_keys) continue;
                for (String s : m.logic_keys) {
                    String[] strs = s.split("\\s*&&\\s*");
                    this.setsToResponses.put(strs, logicalResponses);
                }
            }
            if (speechMapping.randomNames != null) {
                this.randomNames.addAll(Arrays.asList(speechMapping.randomNames));
            }
            if (speechMapping.defaultResponse != null && !speechMapping.defaultResponse.trim().equals("")) {
                tempDefaultResponse = speechMapping.defaultResponse;
            }
            if (speechMapping.opener == null || speechMapping.opener.trim().equals("")) continue;
            tempOpener = speechMapping.opener;
        }
        if (this.randomNames.isEmpty()) {
            this.randomNames.add("... (I don't actually have a name)");
        }
        this.defaultLogicalChecks = builtLogicalChecks;
        this.defaultResponse = tempDefaultResponse;
        this.opener = tempOpener != null ? tempOpener : this.defaultResponse;
    }

    static class Response {
        public final String text;
        public final String requiresToken;
        public final String negativeText;
        public final String negativeTextVar;
        public final String negativeTextHolding;
        public final String setsToken;
        public final AILoader.VarPair[] requiresVars;
        public final AILoader.LocPair[] requiresHolding;
        public final AILoader.VarPair[] setsVars;
        public final AILoader.Action[] actions;
        private final Responses parent;
        private static final Pattern varRegex = Pattern.compile("\\$\\w+");

        Response(Responses parent, String text, String requiresToken, String setsToken, AILoader.VarPair[] requiresVars, AILoader.LocPair[] requiresHolding, String negativeText, String negativeTextVar, String negativeTextHolding, AILoader.VarPair[] setsVars, AILoader.Action[] actions) {
            this.parent = parent;
            this.text = text;
            this.requiresToken = requiresToken;
            this.setsToken = setsToken;
            this.requiresVars = requiresVars;
            this.requiresHolding = requiresHolding;
            this.negativeText = negativeText;
            this.negativeTextVar = negativeTextVar;
            this.negativeTextHolding = negativeTextHolding;
            this.setsVars = setsVars;
            this.actions = actions;
        }

        int getHashedVal(int npcUniqueId, int size) {
            return Math.abs(npcUniqueId % size);
        }

        String replaceVars(String template, int npcUniqueId) {
            int hashedIndex = this.getHashedVal(npcUniqueId, this.parent.randomNames.size());
            String chosenName = this.parent.randomNames.get(hashedIndex);
            return template.replaceAll("\\$name", chosenName);
        }

        BooleanText getText(int npcUniqueId, String tempToken, Container container, PlayerEntity player) {
            String name = player.func_200200_C_().getString();
            boolean varsMatch = true;
            if (this.requiresToken != null && !this.requiresToken.equals(tempToken)) {
                return new BooleanText(false, this.negativeText, "");
            }
            if (this.requiresVars != null) {
                for (AILoader.VarPair requiresVar : this.requiresVars) {
                    String npcName;
                    if (requiresVar.key.equals("$name")) {
                        npcName = this.replaceVars("$name", npcUniqueId);
                        varsMatch &= npcName.toLowerCase().equals(requiresVar.value.toLowerCase());
                        continue;
                    }
                    if (requiresVar.key.equals("$nameStartsWith")) {
                        npcName = this.replaceVars("$name", npcUniqueId);
                        varsMatch &= npcName.toLowerCase().startsWith(requiresVar.value.toLowerCase());
                        continue;
                    }
                    if (requiresVar.key.equals("$nameDoesNotStartWith")) {
                        npcName = this.replaceVars("$name", npcUniqueId);
                        varsMatch &= !npcName.toLowerCase().startsWith(requiresVar.value.toLowerCase());
                        continue;
                    }
                    AILoader.VarPair personalized = requiresVar.personalize(name);
                    if (!(varsMatch &= QuestConfig.matchesVar(personalized))) break;
                }
            }
            boolean holdingMatch = true;
            InvPosition invPosition = null;
            if (this.requiresHolding != null) {
                for (AILoader.LocPair rh : this.requiresHolding) {
                    String[] itemOptions = rh.item.split("\\|");
                    if (rh.loc.equals("any")) {
                        boolean anyMatch = false;
                        block2: for (ItemStack stack : player.field_71071_by.field_184439_c) {
                            for (String itemOption : itemOptions) {
                                if (stack.func_77977_a().equals(itemOption) && stack.func_190916_E() >= rh.amount) {
                                    anyMatch = true;
                                    invPosition = new InvPosition("offhand");
                                    continue block2;
                                }
                                if (anyMatch) continue block2;
                            }
                        }
                        if (!anyMatch) {
                            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                                ItemStack stack;
                                stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                                for (String itemOption : itemOptions) {
                                    if (!stack.func_77977_a().equals(itemOption) || stack.func_190916_E() < rh.amount) continue;
                                    anyMatch = true;
                                    invPosition = new InvPosition("inventory", i);
                                    break;
                                }
                                if (anyMatch) break;
                            }
                        }
                        holdingMatch &= anyMatch;
                    } else if (rh.loc.equals("selected")) {
                        ItemStack stack = player.field_71071_by.func_70448_g();
                        int n = 0;
                        String[] i = itemOptions;
                        int stack2 = i.length;
                        if (n < stack2) {
                            String itemOption = i[n];
                            holdingMatch &= stack.func_77977_a().equals(itemOption) && stack.func_190916_E() >= rh.amount;
                            invPosition = new InvPosition("selected");
                        }
                    } else if (rh.loc.equals("offhand")) {
                        boolean offhandMatch = false;
                        for (ItemStack stack : player.field_71071_by.field_184439_c) {
                            for (String itemOption : itemOptions) {
                                if (!stack.func_77977_a().equals(itemOption) || stack.func_190916_E() < rh.amount) continue;
                                invPosition = new InvPosition("offhand");
                                offhandMatch = true;
                                break;
                            }
                            if (!offhandMatch) continue;
                            break;
                        }
                        holdingMatch &= offhandMatch;
                    } else {
                        boolean offhandMatch = false;
                        for (ItemStack stack : player.field_71071_by.field_184439_c) {
                            for (String itemOption : itemOptions) {
                                if (!stack.func_77977_a().equals(itemOption) || stack.func_190916_E() < rh.amount) continue;
                                invPosition = new InvPosition("offhand");
                                offhandMatch = true;
                                break;
                            }
                            if (!offhandMatch) continue;
                            break;
                        }
                        boolean selectedMatch = false;
                        if (!offhandMatch) {
                            for (String itemOption : itemOptions) {
                                ItemStack stack = player.field_71071_by.func_70448_g();
                                boolean bl = selectedMatch = stack.func_77977_a().equals(itemOption) && stack.func_190916_E() >= rh.amount;
                                if (!selectedMatch) continue;
                                invPosition = new InvPosition("selected");
                                break;
                            }
                        }
                        holdingMatch &= selectedMatch || offhandMatch;
                    }
                    if (!holdingMatch) break;
                }
            }
            if (this.requiresVars != null && this.requiresHolding != null) {
                if (this.negativeText != null && !varsMatch && !holdingMatch) {
                    return new BooleanText(false, this.negativeText, "");
                }
                if (!varsMatch) {
                    if (this.negativeTextVar != null) {
                        return new BooleanText(false, this.negativeTextVar, "");
                    }
                    return new BooleanText(false, this.negativeText, "");
                }
                if (!holdingMatch) {
                    if (this.negativeTextHolding != null) {
                        return new BooleanText(false, this.negativeTextHolding, "");
                    }
                    return new BooleanText(false, this.negativeText, "");
                }
                return this.succeedAndReturnText(npcUniqueId, name, this.setsToken, invPosition, container, player.field_71071_by);
            }
            if (this.requiresVars != null) {
                if (!varsMatch) {
                    if (this.negativeTextVar != null) {
                        return new BooleanText(false, this.negativeTextVar, "");
                    }
                    return new BooleanText(false, this.negativeText, "");
                }
                return this.succeedAndReturnText(npcUniqueId, name, this.setsToken, invPosition, container, player.field_71071_by);
            }
            if (this.requiresHolding != null) {
                if (!holdingMatch) {
                    if (this.negativeTextHolding != null) {
                        return new BooleanText(false, this.negativeTextHolding, "");
                    }
                    return new BooleanText(false, this.negativeText, "");
                }
                return this.succeedAndReturnText(npcUniqueId, name, this.setsToken, invPosition, container, player.field_71071_by);
            }
            return this.succeedAndReturnText(npcUniqueId, name, this.setsToken, invPosition, container, player.field_71071_by);
        }

        private BooleanText succeedAndReturnText(int npcUniqueId, String name, String token, InvPosition invPos, Container container, PlayerInventory playerInventory) {
            String resolvedText = this.text != null ? this.replaceVars(this.text, npcUniqueId) : null;
            return new BooleanText(true, resolvedText, token, () -> {
                if (this.actions != null) {
                    for (AILoader.Action action : this.actions) {
                        DialogActions.Result result = DialogActions.execute(action.name, action.args, invPos, container, playerInventory);
                        if (result.success) continue;
                        return new StringPair(result.failMessage, "");
                    }
                }
                if (this.setsVars != null) {
                    for (AILoader.VarPair pair : this.setsVars) {
                        AILoader.VarPair personalized = pair.personalize(name);
                        QuestConfig.setVar(personalized.key, personalized.value);
                    }
                }
                return new StringPair(resolvedText, token);
            });
        }
    }

    static class BooleanText {
        boolean positive;
        Strategy strategy;
        StringPair pair;

        public BooleanText(boolean positive, String text, String token) {
            this.positive = positive;
            if (text == null) {
                text = "";
            }
            if (token == null) {
                token = "";
            }
            this.pair = new StringPair(text, token);
        }

        public BooleanText(boolean positive, String text, String token, Strategy strategy) {
            this.positive = positive;
            if (text == null) {
                text = "(There is no response.)";
            }
            if (token == null) {
                token = "";
            }
            this.pair = new StringPair(text, token);
            this.strategy = strategy;
        }

        public StringPair execute() {
            if (this.strategy != null) {
                return this.strategy.execute();
            }
            return this.pair;
        }

        public StringPair getNegativeText() {
            return this.pair;
        }
    }

    static class InvPosition {
        public final String loc;
        public final int pos;

        public InvPosition(String loc) {
            this.loc = loc;
            this.pos = -1;
        }

        public InvPosition(String loc, int pos) {
            this.loc = loc;
            this.pos = pos;
        }
    }

    static interface Strategy {
        public StringPair execute();
    }

    static class LogicalResponses {
        public String tieBreaker;
        public ArrayList<Response> responses;

        public LogicalResponses(String tieBreaker, ArrayList<Response> responses) {
            this.tieBreaker = tieBreaker;
            this.responses = responses;
        }
    }
}

