/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.commands;

import com.hackshop.ultimate_unicorn.QuestConfig;
import com.hackshop.ultimate_unicorn.chat.ai.AILoader;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.StringTextComponent;

public class DialogCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"dc").requires(commandSource -> commandSource.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"command", (ArgumentType)StringArgumentType.string()).executes(commandContext -> DialogCommand.execute((CommandContext<CommandSource>)commandContext, 1))).then(Commands.func_197056_a((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(commandContext -> DialogCommand.execute((CommandContext<CommandSource>)commandContext, 3)))));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"dialogCommand").redirect((CommandNode)node));
    }

    public static int execute(CommandContext<CommandSource> commandContext, int args) throws CommandSyntaxException {
        if (args == 0) {
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)new StringTextComponent("Invalid arguments 2")), (Message)new StringTextComponent("Invalid arguments"));
        }
        ServerPlayerEntity sender = ((CommandSource)commandContext.getSource()).func_197035_h();
        Entity e = sender.getEntity();
        String cmd = StringArgumentType.getString(commandContext, (String)"command");
        SubCommands command = SubCommands.find(cmd);
        if (command.minArgs == 0) {
            command.strat.doIt(cmd, new String[0]);
        } else {
            String newArgString = StringArgumentType.getString(commandContext, (String)"args");
            String[] newArgs = newArgString.split(" ");
            command.strat.doIt(cmd, newArgs);
        }
        return 1;
    }

    static enum SubCommands {
        RELOAD("reload", 0, new Strat(){

            @Override
            void doIt(String cmd, String ... args) {
                AILoader.loadAll();
            }
        }),
        SET("set", 2, new Strat(){

            @Override
            void doIt(String cmd, String ... args) {
                QuestConfig.setVar(args[0], args[1]);
            }
        }),
        UNSET("unset", 1, new Strat(){

            @Override
            void doIt(String cmd, String ... args) {
                QuestConfig.unsetVar(args[0]);
            }
        });

        public final String text;
        public final int minArgs;
        public final Strat strat;

        private SubCommands(String t, int minArgs, Strat s) {
            this.text = t;
            this.minArgs = minArgs;
            this.strat = s;
        }

        public String getText() {
            return this.text;
        }

        public boolean equals(String str) {
            return str.equals(this.text);
        }

        public static SubCommands find(String str) {
            for (SubCommands s : SubCommands.values()) {
                if (!s.getText().equals(str)) continue;
                return s;
            }
            return null;
        }

        static abstract class Strat {
            Strat() {
            }

            abstract void doIt(String var1, String ... var2);
        }
    }
}

