/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.google.common.collect.Lists;
import com.hackshop.ultimate_unicorn.custom.CustomHorseInfo;
import com.hackshop.ultimate_unicorn.custom.LayeredTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HorseLayeredTexture
extends Texture {
    private static final Logger LOGGER = LogManager.getLogger();
    public final List<String> layeredTextureNames;
    CustomHorseInfo chi;

    public HorseLayeredTexture(CustomHorseInfo chi, String ... textureNames) {
        this.chi = chi;
        this.layeredTextureNames = Lists.newArrayList((Object[])textureNames);
        if (this.layeredTextureNames.isEmpty()) {
            throw new IllegalStateException("Layered texture with no layers.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void func_195413_a(IResourceManager manager) throws IOException {
        Iterator<String> iterator = this.layeredTextureNames.iterator();
        String s = iterator.next();
        try (Object iresource = null;){
            ByteBuffer buf = this.chi.getByteBuffer().duplicate();
            buf.rewind();
            NativeImage nativeImage = NativeImage.func_195704_a((ByteBuffer)buf);
            block30: while (true) {
                if (!iterator.hasNext()) {
                    if (!RenderSystem.isOnRenderThreadOrInit()) {
                        RenderSystem.recordRenderCall(() -> this.loadImage(nativeImage));
                        return;
                    }
                    this.loadImage(nativeImage);
                    return;
                }
                String s1 = iterator.next();
                if (s1 == null) continue;
                IResource iresource1 = manager.func_199002_a(new ResourceLocation(s1));
                Throwable var9 = null;
                try {
                    NativeImage nativeimage1 = NativeImage.func_195713_a((InputStream)iresource1.func_199027_b());
                    Throwable var11 = null;
                    try {
                        int i = 0;
                        while (true) {
                            if (i >= nativeimage1.func_195714_b()) continue block30;
                            for (int j = 0; j < nativeimage1.func_195702_a(); ++j) {
                                LayeredTexture.blendPixel(nativeImage, j, i, nativeimage1.func_195709_a(j, i));
                            }
                            ++i;
                        }
                    }
                    catch (Throwable var59) {
                        var11 = var59;
                        throw var59;
                    }
                    finally {
                        if (nativeimage1 == null) continue;
                        if (var11 != null) {
                            try {
                                nativeimage1.close();
                            }
                            catch (Throwable var58) {
                                var11.addSuppressed(var58);
                            }
                            continue;
                        }
                        nativeimage1.close();
                        continue;
                    }
                }
                catch (Throwable var61) {
                    var9 = var61;
                    throw var61;
                }
                finally {
                    if (iresource1 == null) continue;
                    if (var9 != null) {
                        try {
                            iresource1.close();
                        }
                        catch (Throwable var57) {
                            var9.addSuppressed(var57);
                        }
                        continue;
                    }
                    iresource1.close();
                    continue;
                }
                break;
            }
        }
        catch (IOException var65) {
            LOGGER.error("Couldn't load layered image", (Throwable)var65);
            return;
        }
    }

    private void loadImage(NativeImage imageIn) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
        imageIn.func_195697_a(0, 0, 0, true);
    }
}

