/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.custom.AbstractPower;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.projectile.EntityIceBall;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.world.World;

public class IcyWingBuffet
extends AbstractPower {
    public static final float ext = 0.96f;
    public static final float ext2 = 0.35999998f;

    public IcyWingBuffet(boolean b) {
        super(b);
        this.name = LanguageMap.func_74808_a().func_230503_a_("power.icyWingBuffet");
    }

    @Override
    public EntityMagicalHorse.OrderedPower getOrderedPower() {
        return EntityMagicalHorse.OrderedPower.ICY_WING_BUFFET;
    }

    @Override
    public void doBuffetPower(EntityMagicalHorse horse, int buffetCooldownCounter, float forward, float sides, float up) {
        if (this.supercharged) {
            forward = (float)((double)forward * 1.2);
            sides = (float)((double)sides * 1.1);
        }
        int maxDir = (int)((double)forward * 3.5);
        int maxWidth = (int)sides;
        float v2 = -MathHelper.func_76126_a((float)(horse.field_70177_z * (float)Math.PI / 180.0f));
        float v3 = MathHelper.func_76134_b((float)(horse.field_70177_z * (float)Math.PI / 180.0f));
        Vector3d v = new Vector3d((double)v2, 0.0, (double)v3).func_72432_b();
        Vector3d vLeft = v.func_178785_b(0.5235988f);
        Vector3d vRight = v.func_178785_b(-0.5235988f);
        Vector3d vPerp = v.func_178785_b(-1.5707964f);
        Vector3d vPerpSide = new Vector3d(vPerp.field_72450_a * (double)maxWidth, vPerp.field_72448_b * (double)maxWidth, vPerp.field_72449_c * (double)maxWidth);
        Vector3d startPos = horse.func_213303_ch().func_178787_e(vPerpSide);
        Vector3d startPos2 = horse.func_213303_ch().func_178787_e(vPerpSide);
        Vector3d endPos = horse.func_213303_ch().func_178788_d(vPerpSide);
        int counter = 0;
        if (!horse.field_70170_p.field_72995_K) {
            Material m;
            BlockState bState;
            BlockPos bPos;
            int k;
            int i;
            Vector3d current;
            while (startPos.func_178788_d(endPos).func_72433_c() > 0.2 && counter < 100) {
                ++counter;
                current = new Vector3d(startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c);
                for (i = 0; i < maxDir; ++i) {
                    for (k = -1; k < 2; ++k) {
                        bPos = new BlockPos(current.func_178787_e(new Vector3d(0.0, (double)k, 0.0)));
                        bState = horse.field_70170_p.func_180495_p(bPos);
                        m = bState.func_185904_a();
                        if (m == Material.field_151586_h) {
                            horse.func_130014_f_().func_175656_a(bPos, Blocks.field_150432_aD.func_176223_P());
                            continue;
                        }
                        if (m == Material.field_151587_i) {
                            horse.func_130014_f_().func_175656_a(bPos, Blocks.field_150348_b.func_176223_P());
                            continue;
                        }
                        if (m != Material.field_151581_o) continue;
                        horse.func_130014_f_().func_175656_a(bPos, Blocks.field_150350_a.func_176223_P());
                    }
                    current = current.func_178787_e(vLeft);
                }
                startPos = startPos.func_178788_d(vPerp);
            }
            counter = 0;
            while (startPos2.func_178788_d(endPos).func_72433_c() > 1.0 && counter < 100) {
                ++counter;
                current = new Vector3d(endPos.field_72450_a, endPos.field_72448_b, endPos.field_72449_c);
                for (i = 0; i < maxDir; ++i) {
                    for (k = -1; k < 4; ++k) {
                        bPos = new BlockPos(current.func_178787_e(new Vector3d(0.0, (double)k, 0.0)));
                        bState = horse.field_70170_p.func_180495_p(bPos);
                        m = bState.func_185904_a();
                        if (m == Material.field_151586_h) {
                            horse.func_130014_f_().func_175656_a(bPos, Blocks.field_150432_aD.func_176223_P());
                            continue;
                        }
                        if (m == Material.field_151587_i) {
                            horse.func_130014_f_().func_175656_a(bPos, Blocks.field_150348_b.func_176223_P());
                            continue;
                        }
                        if (m != Material.field_151581_o) continue;
                        horse.func_130014_f_().func_175656_a(bPos, Blocks.field_150350_a.func_176223_P());
                    }
                    current = current.func_178787_e(vRight);
                }
                endPos = endPos.func_178787_e(vPerp);
            }
        }
        if (this.supercharged) {
            this.shootSnowballs(horse, buffetCooldownCounter);
        }
    }

    public void shootSnowballs(EntityMagicalHorse horse, int buffetCooldownCounter) {
        if (buffetCooldownCounter % 9 == 6 && this.isNearIce(horse.field_70170_p, horse.func_233580_cy_())) {
            Vector3d lookVec = null != horse.func_184179_bs() ? horse.func_184179_bs().func_70040_Z() : horse.func_70040_Z();
            float f2 = MathHelper.func_76126_a((float)(1.5707964f + horse.field_70177_z * (float)Math.PI / 180.0f));
            float f3 = MathHelper.func_76134_b((float)(1.5707964f + horse.field_70177_z * (float)Math.PI / 180.0f));
            double x = 0.96f * f2;
            double z = -0.96f * f3;
            if (horse.hasDestrierBody()) {
                x *= (double)1.6f;
                z *= (double)1.6f;
            }
            double x2 = 0.35999998f * f2;
            double z2 = -0.35999998f * f3;
            Vector3d horsePosVec = horse.func_213303_ch();
            Vector3d horseMotionVec = horse.func_213322_ci();
            for (int i = 0; i < 3; ++i) {
                EntityIceBall sfb = new EntityIceBall(horse.field_70170_p, (LivingEntity)horse);
                sfb.func_70107_b(horsePosVec.field_72450_a + lookVec.field_72450_a * (double)1.8f + x * (double)i, horsePosVec.field_72448_b + (double)horse.func_70047_e() + lookVec.field_72448_b * (double)1.8f, horsePosVec.field_72449_c + lookVec.field_72449_c * (double)1.8f + z * (double)i);
                sfb.func_213317_d(new Vector3d(lookVec.field_72450_a * 2.5 + horseMotionVec.field_72450_a + x2 * (double)i, lookVec.field_72448_b * 2.5 + horseMotionVec.field_72448_b, lookVec.field_72449_c * 2.5 + horseMotionVec.field_72449_c + z2 * (double)i));
                if (horse.field_70170_p.field_72995_K) {
                    sfb.func_70024_g(lookVec.field_72450_a * 2.5 + horseMotionVec.field_72450_a + x2 * (double)i, lookVec.field_72448_b * 2.5 + horseMotionVec.field_72448_b, lookVec.field_72449_c * 2.5 + horseMotionVec.field_72449_c + z2 * (double)i);
                }
                horse.field_70170_p.func_217376_c((Entity)sfb);
                EntityIceBall sfb2 = new EntityIceBall(horse.field_70170_p, (LivingEntity)horse);
                sfb2.func_70107_b(horsePosVec.field_72450_a + lookVec.field_72450_a * (double)1.8f - x * (double)i, horsePosVec.field_72448_b + (double)horse.func_70047_e() + lookVec.field_72448_b * (double)1.8f, horsePosVec.field_72449_c + lookVec.field_72449_c * (double)1.8f - z * (double)i);
                sfb2.func_213317_d(new Vector3d(lookVec.field_72450_a * 2.5 + horseMotionVec.field_72450_a - x2 * (double)i, lookVec.field_72448_b * 2.5 + horseMotionVec.field_72448_b, lookVec.field_72449_c * 2.5 + horseMotionVec.field_72449_c - z2 * (double)i));
                if (horse.field_70170_p.field_72995_K) {
                    sfb2.func_70024_g(lookVec.field_72450_a * 2.5 + horseMotionVec.field_72450_a - x2 * (double)i, lookVec.field_72448_b * 2.5 + horseMotionVec.field_72448_b, lookVec.field_72449_c * 2.5 + horseMotionVec.field_72449_c - z2 * (double)i);
                }
                horse.field_70170_p.func_217376_c((Entity)sfb2);
            }
        }
    }

    @Override
    public float getBuffetStrengthMultiplier() {
        if (this.supercharged) {
            return 1.18f;
        }
        return 1.09f;
    }

    @Override
    public float getBuffetForwardSizeMultiplier() {
        if (this.supercharged) {
            return 1.2f;
        }
        return 1.1f;
    }

    @Override
    public float getBuffetSideSizeMultiplier() {
        if (this.supercharged) {
            return 1.2f;
        }
        return 1.1f;
    }

    @Override
    public float getBuffetUpSizeMultiplier() {
        if (this.supercharged) {
            return 1.2f;
        }
        return 1.1f;
    }

    protected boolean isNearIce(World world, BlockPos position) {
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                for (int k = -1; k < 4; ++k) {
                    BlockPos bPos = position.func_177982_a(i, k, j);
                    Block block = world.func_180495_p(bPos).func_177230_c();
                    Material m = world.func_180495_p(bPos).func_185904_a();
                    if (block != Blocks.field_150433_aE && block != Blocks.field_196604_cC && block != Blocks.field_150432_aD && block != Blocks.field_150403_cj && Material.field_151588_w != m && Material.field_151598_x != m && Material.field_151596_z != m) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

