/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.custom.AbstractPower;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.util.WorldUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.FlowersFeature;

public class LifeAura
extends AbstractPower {
    public LifeAura() {
        this.name = LanguageMap.func_74808_a().func_230503_a_("power.lifeAura");
    }

    @Override
    public EntityMagicalHorse.OrderedPower getOrderedPower() {
        return EntityMagicalHorse.OrderedPower.LIFE_AURA;
    }

    @Override
    public void doAuraPower(EntityMagicalHorse horse, int auraCounter) {
        int healTime = 1;
        int modCount1 = 30;
        int amplifier = 0;
        int modCount2 = 100;
        int modCount3 = 200;
        double xExp = 5.5;
        double up = 2.6;
        double zExp = 5.5;
        int numParticles = 3;
        this.emitAura((Entity)horse, numParticles, xExp / 2.0, up / 2.0, zExp / 2.0);
        if (auraCounter % modCount1 == 0) {
            for (int i = 0; i < 3; ++i) {
                this.spreadGrass((Entity)horse);
            }
        }
        if (auraCounter % modCount2 == 0) {
            this.spreadFlowers((Entity)horse);
        }
        if (auraCounter % modCount3 == 0) {
            for (Object e : horse.field_70170_p.func_217357_a(LivingEntity.class, horse.func_174813_aQ().func_72314_b(xExp, up, zExp))) {
                LivingEntity targetEntity = (LivingEntity)e;
                if (targetEntity instanceof IMob) continue;
                targetEntity.func_195064_c(new EffectInstance(Effects.field_76432_h, healTime, amplifier, true, true));
                if (!(targetEntity instanceof AnimalEntity)) continue;
                targetEntity.func_195064_c(new EffectInstance(Effects.field_76429_m, 100, 3, true, true));
                targetEntity.func_195064_c(new EffectInstance(Effects.field_76432_h, 10, 2, true, true));
            }
        }
    }

    private void spreadGrass(Entity entity) {
        World world = entity.func_130014_f_();
        Random rand = world.field_73012_v;
        double x = rand.nextGaussian() * 3.0;
        double z = rand.nextGaussian() * 3.0;
        BlockPos entityPos = entity.func_233580_cy_();
        BlockPos pos = WorldUtil.getTopSolidOrLiquidBlock(new BlockPos((Vector3i)entityPos.func_177963_a(x, 0.0, z)), world).func_177977_b();
        if (pos.func_177956_o() > entity.func_233580_cy_().func_177956_o() + 5) {
            pos = new BlockPos(pos.func_177958_n(), entityPos.func_177956_o() - 1, pos.func_177952_p()).func_177977_b();
        }
        Block b = world.func_180495_p(pos).func_177230_c();
        BlockState upState = world.func_180495_p(pos.func_177984_a());
        Block up = upState.func_177230_c();
        if (!(Math.abs(pos.func_177956_o() - entityPos.func_177956_o()) >= 6 || Blocks.field_150346_d != b && Blocks.field_150354_m != b || upState.func_185904_a().func_76224_d() || upState.func_185904_a().func_76220_a())) {
            world.func_180501_a(pos, Blocks.field_196658_i.func_176223_P(), 3);
        }
    }

    private void spreadFlowers(Entity entity) {
        World world = entity.func_130014_f_();
        Random rand = world.field_73012_v;
        double x = rand.nextGaussian() * 3.0;
        double z = rand.nextGaussian() * 3.0;
        BlockPos entityPos = entity.func_233580_cy_();
        BlockPos pos = WorldUtil.getTopSolidOrLiquidBlock(new BlockPos((Vector3i)entityPos.func_177963_a(x, 0.0, z)), world).func_177977_b();
        if (pos.func_177956_o() > entity.func_233580_cy_().func_177956_o() + 5) {
            pos = new BlockPos(pos.func_177958_n(), entityPos.func_177956_o() - 1, pos.func_177952_p()).func_177977_b();
        }
        Block b = world.func_180495_p(pos).func_177230_c();
        BlockState upState = world.func_180495_p(pos.func_177984_a());
        Block up = upState.func_177230_c();
        if (Math.abs(pos.func_177956_o() - entityPos.func_177956_o()) < 6 && Blocks.field_196658_i == b && !upState.func_185904_a().func_76224_d() && !upState.func_185904_a().func_76220_a() && up != Blocks.field_196615_bk && up != Blocks.field_196609_bf) {
            List flowers;
            BlockState state = Blocks.field_196615_bk.func_176223_P();
            int r = rand.nextInt(5);
            if (0 == r) {
                state = Blocks.field_196609_bf.func_176223_P();
            } else if (r < 4 && !(flowers = world.func_226691_t_(pos).func_242440_e().func_242496_b()).isEmpty()) {
                int r2 = world.field_73012_v.nextInt(flowers.size());
                ConfiguredFeature configuredfeature = (ConfiguredFeature)flowers.get(0);
                FlowersFeature flowersfeature = (FlowersFeature)configuredfeature.field_222737_a;
                state = flowersfeature.func_225562_b_(rand, pos, configuredfeature.func_242767_c());
            }
            this.generateFlowers(world, rand, state, pos);
        }
    }

    public boolean generateFlowers(World worldIn, Random rand, BlockState state, BlockPos pos) {
        for (int i = 0; i < 5; ++i) {
            BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(6) - rand.nextInt(6), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(6) - rand.nextInt(6));
            if (!worldIn.func_175623_d(blockpos1) || !worldIn.func_230315_m_().func_218272_d() && blockpos1.func_177956_o() >= 255 || !state.func_196955_c((IWorldReader)worldIn, blockpos1)) continue;
            worldIn.func_180501_a(blockpos1, state, 2);
        }
        return true;
    }

    private void emitAura(Entity entity, int numParticles, double xDist, double yDist, double zDist) {
        World world = entity.func_130014_f_();
        Random rand = world.field_73012_v;
        for (int i = 0; i < numParticles; ++i) {
            double d0 = rand.nextGaussian() * 0.2;
            double d1 = rand.nextGaussian() * 0.2;
            double d2 = rand.nextGaussian() * 0.2;
            world.func_195594_a((IParticleData)ParticleTypes.field_197614_g, entity.func_226277_ct_() + (double)rand.nextFloat() * ((double)entity.func_213311_cf() + xDist) * 2.0 - ((double)entity.func_213311_cf() + xDist), entity.func_226278_cu_() + 0.5 + (double)rand.nextFloat() * ((double)entity.func_213302_cg() + yDist), entity.func_226281_cx_() + (double)rand.nextFloat() * ((double)entity.func_213311_cf() + zDist) * 2.0 - ((double)entity.func_213311_cf() + zDist), d0, d1, d2);
        }
    }
}

