/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.Config;
import com.hackshop.ultimate_unicorn.custom.Power;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.PowerSettings;

public class PowerAccessor
implements Power {
    private Power power;
    private PowerSettings powerSettings;

    public PowerAccessor(Power power, PowerSettings powerSettings) {
        this.power = power;
        this.powerSettings = powerSettings;
    }

    public void enable() {
        this.powerSettings.setEnabled(this.power.getOrderedPower());
    }

    public void disable() {
        this.powerSettings.setDisabled(this.power.getOrderedPower());
    }

    public boolean isEnabled() {
        return this.powerSettings.isEnabled(this.power.getOrderedPower()) && (Boolean)Config.COMMON.disable_all_custom_horse_powers.get() == false;
    }

    public static boolean isEnabled(Power power, PowerSettings powerSettings) {
        return powerSettings.isEnabled(power.getOrderedPower()) && (Boolean)Config.COMMON.disable_all_custom_horse_powers.get() == false;
    }

    @Override
    public void doAuraPower(EntityMagicalHorse horse, int auraCounter) {
        if (this.isEnabled()) {
            this.power.doAuraPower(horse, auraCounter);
        }
    }

    @Override
    public void doMovementPower(EntityMagicalHorse entityMagicalHorse) {
        if (this.isEnabled()) {
            this.power.doMovementPower(entityMagicalHorse);
        }
    }

    @Override
    public String getName() {
        return this.power.getName();
    }

    @Override
    public EntityMagicalHorse.OrderedPower getOrderedPower() {
        return this.power.getOrderedPower();
    }

    @Override
    public void doBuffetPower(EntityMagicalHorse horse, int buffetCooldownCounter, float forward, float sides, float up) {
        if (this.isEnabled()) {
            this.power.doBuffetPower(horse, buffetCooldownCounter, forward, sides, up);
        }
    }

    @Override
    public void doLandingPower(EntityMagicalHorse horse) {
        if (this.isEnabled()) {
            this.power.doLandingPower(horse);
        }
    }

    @Override
    public boolean doHornPower(EntityMagicalHorse horse) {
        if (this.isEnabled()) {
            return this.power.doHornPower(horse);
        }
        return false;
    }

    @Override
    public void doHornPowerOnClick(EntityMagicalHorse horse, Power.Counter counter) {
        if (this.isEnabled()) {
            this.power.doHornPowerOnClick(horse, counter);
        }
    }

    @Override
    public float getBuffetStrengthMultiplier() {
        return this.power.getBuffetStrengthMultiplier();
    }

    @Override
    public float getBuffetForwardSizeMultiplier() {
        return this.power.getBuffetForwardSizeMultiplier();
    }

    @Override
    public float getBuffetSideSizeMultiplier() {
        return this.power.getBuffetSideSizeMultiplier();
    }

    @Override
    public float getBuffetUpSizeMultiplier() {
        return this.power.getBuffetUpSizeMultiplier();
    }

    @Override
    public boolean satisfiesCondition() {
        return this.power.satisfiesCondition();
    }

    @Override
    public boolean isNonCombatant() {
        return this.power.isNonCombatant();
    }
}

