/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.custom.AbstractPower;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.world.World;

public class RainbowAura
extends AbstractPower {
    public RainbowAura(boolean b) {
        super(b);
        this.name = LanguageMap.func_74808_a().func_230503_a_("power.rainbowAura");
    }

    @Override
    public EntityMagicalHorse.OrderedPower getOrderedPower() {
        return EntityMagicalHorse.OrderedPower.RAINBOW_AURA;
    }

    @Override
    public void doAuraPower(EntityMagicalHorse horse, int auraCounter) {
        double auraWidth = 1.1;
        double auraHeight = 1.4;
        int fireTimeInSeconds = 2;
        int numParticles = 10;
        int activationPeriod = 40;
        if (this.supercharged) {
            auraWidth = 1.6;
            auraHeight = 2.1;
            fireTimeInSeconds = 5;
            numParticles = 20;
            activationPeriod = 30;
        }
        if (horse.field_70170_p.field_72995_K) {
            this.emitAura((Entity)horse, numParticles, auraWidth / 2.0, auraHeight / 2.0, auraWidth / 2.0);
        }
    }

    private void emitAura(Entity entity, int numParticles, double xDist, double yDist, double zDist) {
        World worldObj = entity.func_130014_f_();
        Random rand = worldObj.field_73012_v;
        Vector3d pos = entity.func_213303_ch();
        Vector3d heading = entity.func_70040_Z().func_186678_a(-1.0);
        for (int i = 0; i < numParticles; ++i) {
            double d0 = rand.nextGaussian();
            double d1 = rand.nextGaussian();
            double d2 = rand.nextGaussian();
            worldObj.func_195594_a((IParticleData)ParticleTypes.field_197625_r, pos.field_72450_a + heading.field_72450_a / 2.0, pos.field_72448_b + 1.0, pos.field_72449_c + heading.field_72449_c / 2.0, d0, d1, d2);
        }
    }
}

