/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.custom;

import com.hackshop.ultimate_unicorn.Config;
import com.hackshop.ultimate_unicorn.UpdateChecker;
import com.hackshop.ultimate_unicorn.custom.BetterDownloadingTexture;
import com.hackshop.ultimate_unicorn.custom.CustomHorseInfo;
import com.hackshop.ultimate_unicorn.gui.TextUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ThreadDownloadHorseImage
extends SimpleTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AtomicInteger TEXTURE_DOWNLOADER_THREAD_ID = new AtomicInteger(0);
    @Nullable
    private final File cacheFile;
    private String imageUrl;
    @Nullable
    private final File indexCacheFile;
    private final String indexUrl;
    @Nullable
    private Thread imageThread;
    private boolean textureUploaded;
    private CustomHorseInfo chi;
    private String name;
    private String firstLetter = null;
    private String title = null;
    private int[] powers = null;
    private NativeImage nativeImage;
    BetterDownloadingTexture downloadingTexture;
    private static final HashMap<String, String> indexUrls = new HashMap();

    public ThreadDownloadHorseImage(String nameIn, ResourceLocation textureResourceLocation, CustomHorseInfo chi) {
        super(textureResourceLocation);
        if (null == nameIn || nameIn.length() < 1) {
            this.firstLetter = "z";
        } else {
            this.firstLetter = nameIn.substring(0, 1);
            if (this.firstLetter.matches("[^a-z]")) {
                this.firstLetter = "z";
            }
        }
        this.indexUrl = indexUrls.get(this.firstLetter);
        this.indexCacheFile = new File(Config.downloadDir, this.firstLetter + ".txt");
        this.imageUrl = null;
        this.chi = chi;
        this.name = nameIn;
        this.cacheFile = new File(Config.downloadDir, TextUtil.getPathSafeName(this.name) + ".png");
    }

    public void func_195413_a(IResourceManager resourceManager) throws IOException {
        if (this.imageThread == null) {
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", new Object[]{this.cacheFile});
                try {
                    String def = this.loadIndex();
                    String deObDef = ThreadDownloadHorseImage.deOb(def);
                    if (null == deObDef) {
                        this.chi.setDefunct(true);
                        return;
                    }
                    this.loadTitleAndPowers(deObDef);
                    if (this.downloadingTexture != null) {
                        this.downloadingTexture.func_195413_a(resourceManager);
                    } else {
                        this.loadTextureFromServer(resourceManager);
                    }
                    this.chi.setTitle(this.title);
                    this.chi.setPowers(this.powers);
                }
                catch (IOException ioexception) {
                    LOGGER.error("Couldn't load skin {}", new Object[]{this.cacheFile, ioexception});
                    this.loadTextureFromServer(resourceManager);
                }
            } else {
                this.loadTextureFromServer(resourceManager);
            }
        }
    }

    private void loadTitleAndPowers(String def) {
        String[] parts = def.split(",");
        this.imageUrl = parts[0];
        int i = 1;
        if (parts.length > i && !Pattern.matches("^\\d+$", parts[i])) {
            this.title = parts[i];
            ++i;
        }
        int start = i;
        int[] powers = new int[parts.length - i];
        while (i < parts.length) {
            powers[i - start] = Integer.parseInt(parts[i]);
            ++i;
        }
        this.powers = powers;
    }

    private static String deOb(String ob) {
        if (null == ob) {
            return null;
        }
        try {
            String preamble = ob.substring(0, 3);
            String rest = ob.substring(3);
            String subbed = ThreadDownloadHorseImage.sub3(rest);
            String rotated = ThreadDownloadHorseImage.rot13(subbed);
            int check = Integer.parseInt(preamble);
            int sum = 0;
            for (char c : rotated.toCharArray()) {
                sum += c;
            }
            if (check == (sum %= 997)) {
                return rotated;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String sub3(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            c = (char)(c - 3);
            sb.append(c);
        }
        return sb.toString();
    }

    private static String rot13(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c >= 'a' && c <= 'm') {
                c = (char)(c + 13);
            } else if (c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z') {
                c = (char)(c - 13);
            } else if (c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected void loadTextureFromServer(final IResourceManager resourceManager) {
        this.imageThread = new Thread("Texture Downloader #" + TEXTURE_DOWNLOADER_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                LOGGER.debug("Downloading http texture from {} to {}", new Object[]{ThreadDownloadHorseImage.this.imageUrl, ThreadDownloadHorseImage.this.cacheFile});
                try {
                    String def = ThreadDownloadHorseImage.this.loadIndex();
                    String deObDef = ThreadDownloadHorseImage.deOb(def);
                    if (null == deObDef) {
                        ThreadDownloadHorseImage.this.chi.setDefunct(true);
                        return;
                    }
                    ThreadDownloadHorseImage.this.loadTitleAndPowers(deObDef);
                    ThreadDownloadHorseImage.this.downloadingTexture = new BetterDownloadingTexture(ThreadDownloadHorseImage.this.cacheFile, ThreadDownloadHorseImage.this.imageUrl, ThreadDownloadHorseImage.this.field_110568_b, () -> {
                        ThreadDownloadHorseImage.this.chi.setReady(true);
                        ThreadDownloadHorseImage.this.chi.setNativeImage(ThreadDownloadHorseImage.this.downloadingTexture.getNativeImage());
                        ThreadDownloadHorseImage.this.chi.setByteBuffer(ThreadDownloadHorseImage.this.downloadingTexture.getByteBuffer());
                    });
                    ThreadDownloadHorseImage.this.downloadingTexture.func_195413_a(resourceManager);
                    ThreadDownloadHorseImage.this.chi.setTitle(ThreadDownloadHorseImage.this.title);
                    ThreadDownloadHorseImage.this.chi.setPowers(ThreadDownloadHorseImage.this.powers);
                    return;
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't download http texture", (Throwable)exception);
                    ThreadDownloadHorseImage.this.chi.setDefunct(true);
                    return;
                }
            }
        };
        this.imageThread.setDaemon(true);
        this.imageThread.start();
    }

    public String loadIndex() throws IOException {
        if (this.indexCacheFile != null && this.indexCacheFile.isFile()) {
            LOGGER.debug("Loading index from local cache ({})", new Object[]{this.indexCacheFile});
            String md5 = DigestUtils.md5Hex((byte[])FileUtils.readFileToByteArray((File)this.indexCacheFile));
            if (UpdateChecker.isMd5Different(this.firstLetter, md5)) {
                return this.loadIndexFromServer();
            }
            try {
                Properties plainProps = new Properties();
                plainProps.load(new FileReader(this.indexCacheFile));
                return plainProps.getProperty(this.name);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't load index {}", new Object[]{this.indexCacheFile, ioexception});
                return this.loadIndexFromServer();
            }
        }
        return this.loadIndexFromServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadIndexFromServer() {
        HttpURLConnection httpurlconnection = null;
        LOGGER.debug("Downloading http index from {} to {}", new Object[]{this.indexUrl, this.indexCacheFile});
        try {
            httpurlconnection = (HttpURLConnection)new URL(this.indexUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
            httpurlconnection.setDoInput(true);
            httpurlconnection.setDoOutput(false);
            httpurlconnection.connect();
            if (httpurlconnection.getResponseCode() / 100 == 2) {
                if (this.indexCacheFile != null) {
                    FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)this.indexCacheFile);
                    Properties plainProps = new Properties();
                    plainProps.load(new FileReader(this.indexCacheFile));
                    String string = plainProps.getProperty(this.name);
                    return string;
                }
                Properties plainProps = new Properties();
                plainProps.load(new FileReader(this.indexCacheFile));
                String string = plainProps.getProperty(this.name);
                return string;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't download http index: " + this.indexUrl, (Throwable)exception);
        }
        finally {
            if (httpurlconnection != null) {
                httpurlconnection.disconnect();
            }
        }
        return null;
    }

    public void func_174937_a(boolean blurIn, boolean mipmapIn) {
        if (this.downloadingTexture != null) {
            this.downloadingTexture.func_174937_a(blurIn, mipmapIn);
        }
    }

    public void setBlurMipmap(boolean blur, boolean mipmap) {
        if (this.downloadingTexture != null) {
            this.downloadingTexture.setBlurMipmap(blur, mipmap);
        }
    }

    public void restoreLastBlurMipmap() {
        if (this.downloadingTexture != null) {
            this.downloadingTexture.restoreLastBlurMipmap();
        }
    }

    public int func_110552_b() {
        if (this.downloadingTexture != null) {
            return this.downloadingTexture.func_110552_b();
        }
        return 0;
    }

    public void func_147631_c() {
        if (this.downloadingTexture != null) {
            this.downloadingTexture.func_147631_c();
        }
    }

    public void func_229148_d_() {
        if (this.downloadingTexture != null) {
            this.downloadingTexture.func_229148_d_();
        }
    }

    public void func_215244_a(TextureManager textureManagerIn, IResourceManager resourceManagerIn, ResourceLocation resourceLocationIn, Executor executorIn) {
        this.downloadingTexture.func_215244_a(textureManagerIn, resourceManagerIn, resourceLocationIn, executorIn);
    }

    static {
        indexUrls.put("a", "https://drive.google.com/uc?id=0B9WcdoRq4rJWcEM3MURoSjR6TkE");
        indexUrls.put("b", "https://drive.google.com/uc?id=0B9WcdoRq4rJWbnFvSXlING1aREk");
        indexUrls.put("c", "https://drive.google.com/uc?id=0B9WcdoRq4rJWeHlDYU5UZzFhZjQ");
        indexUrls.put("d", "https://drive.google.com/uc?id=0B9WcdoRq4rJWUkltbEIydGpubG8");
        indexUrls.put("e", "https://drive.google.com/uc?id=0B9WcdoRq4rJWTG5xbkFuWkk2WHc");
        indexUrls.put("f", "https://drive.google.com/uc?id=0B9WcdoRq4rJWOGJxczBOZnJoYVU");
        indexUrls.put("g", "https://drive.google.com/uc?id=0B9WcdoRq4rJWVGM2Y0Jyd24wY0k");
        indexUrls.put("h", "https://drive.google.com/uc?id=0B9WcdoRq4rJWYUNNdEE1WEJZbG8");
        indexUrls.put("i", "https://drive.google.com/uc?id=0B9WcdoRq4rJWY0lNVDJsZkt5YUk");
        indexUrls.put("j", "https://drive.google.com/uc?id=0B9WcdoRq4rJWbFFVRl80eU5pX2M");
        indexUrls.put("k", "https://drive.google.com/uc?id=0B9WcdoRq4rJWUUxuWjVSdWdIS2c");
        indexUrls.put("l", "https://drive.google.com/uc?id=0B9WcdoRq4rJWb1l3S0NmalFsczg");
        indexUrls.put("m", "https://drive.google.com/uc?id=0B9WcdoRq4rJWbXl6eHpRcjdsMGs");
        indexUrls.put("n", "https://drive.google.com/uc?id=0B9WcdoRq4rJWbkl3aWk4QThWSzA");
        indexUrls.put("o", "https://drive.google.com/uc?id=0B9WcdoRq4rJWdmI0QU9pMGxVU28");
        indexUrls.put("p", "https://drive.google.com/uc?id=0B9WcdoRq4rJWZ3kyT2ZVYXN5dnc");
        indexUrls.put("q", "https://drive.google.com/uc?id=0B9WcdoRq4rJWOUxFTnUxSVBBU0U");
        indexUrls.put("r", "https://drive.google.com/uc?id=0B9WcdoRq4rJWZVkxcTFyVkE0S28");
        indexUrls.put("s", "https://drive.google.com/uc?id=0B9WcdoRq4rJWbXF0NEIySWRaMFk");
        indexUrls.put("t", "https://drive.google.com/uc?id=0B9WcdoRq4rJWbDhGMnRUZXAzeWc");
        indexUrls.put("u", "https://drive.google.com/uc?id=0B9WcdoRq4rJWZ1U2TFNnTU93QjQ");
        indexUrls.put("v", "https://drive.google.com/uc?id=0B9WcdoRq4rJWQlhJeE1YYTBkb28");
        indexUrls.put("w", "https://drive.google.com/uc?id=0B9WcdoRq4rJWMm5fMTl3X1RMdlU");
        indexUrls.put("x", "https://drive.google.com/uc?id=0B9WcdoRq4rJWQnU5NHBmY3ZZUWs");
        indexUrls.put("y", "https://drive.google.com/uc?id=0B9WcdoRq4rJWMUtoSjRtUk13b0U");
        indexUrls.put("z", "https://drive.google.com/uc?id=0B9WcdoRq4rJWVlptUzFQN19GUEU");
    }
}

