/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.input;

import com.hackshop.ultimate_unicorn.DescendPegasusMessage;
import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.network.PacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;

class DiveStateMachine {
    State state = State.START;
    int holdCount = 0;

    DiveStateMachine() {
    }

    public void transition(Event e) {
        ++this.holdCount;
        switch (this.state) {
            case START: {
                if (e != Event.DESCEND_KEY_DOWN) break;
                this.state = State.DESCEND_KEY_ON;
                this.holdCount = 0;
                break;
            }
            case DESCEND_KEY_ON: {
                if (e == Event.DESCEND_KEY_UP) {
                    this.state = State.DESCEND_KEY_OFF;
                    this.holdCount = 0;
                }
                if (e != Event.DESCEND_KEY_DOWN || this.holdCount <= 20) break;
                this.state = State.DESCENDING;
                this.holdCount = 0;
                break;
            }
            case DESCEND_KEY_OFF: {
                if (e == Event.DESCEND_KEY_DOWN) {
                    EntityMagicalHorse horse;
                    this.state = State.DIVING;
                    PacketHandler.sendToServer(new DescendPegasusMessage(true, false));
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    if (null != player.func_184187_bx() && player.func_184187_bx() instanceof EntityMagicalHorse && (horse = (EntityMagicalHorse)player.func_184187_bx()).canDive()) {
                        horse.startDive();
                    }
                    this.holdCount = 0;
                }
                if (e != Event.DESCEND_KEY_UP || this.holdCount <= 20) break;
                this.state = State.START;
                this.holdCount = 0;
                break;
            }
            case DIVING: {
                EntityMagicalHorse horse;
                if (e == Event.ASCEND_KEY_DOWN) {
                    EntityMagicalHorse horse2;
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    if (null != player.func_184187_bx() && player.func_184187_bx() instanceof EntityMagicalHorse && (horse2 = (EntityMagicalHorse)player.func_184187_bx()).canDive()) {
                        horse2.stopDive();
                    }
                    this.state = State.START;
                    this.holdCount = 0;
                    break;
                }
                if (e != Event.DESCEND_KEY_UP || this.holdCount <= 20) break;
                PacketHandler.sendToServer(new DescendPegasusMessage(false, true));
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (null != player.func_184187_bx() && player.func_184187_bx() instanceof EntityMagicalHorse && (horse = (EntityMagicalHorse)player.func_184187_bx()).canDive()) {
                    horse.stopDive();
                }
                this.state = State.START;
                this.holdCount = 0;
                break;
            }
            case DESCENDING: {
                if (e != Event.DESCEND_KEY_UP) break;
                this.state = State.START;
                this.holdCount = 0;
            }
        }
    }

    static enum Event {
        DESCEND_KEY_DOWN,
        DESCEND_KEY_UP,
        ASCEND_KEY_DOWN;

    }

    static enum State {
        START,
        DESCEND_KEY_ON,
        DESCEND_KEY_OFF,
        DIVING,
        DESCENDING,
        PULL_UP;

    }
}

