/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.input;

class DoubleClickStateMachine {
    State state = State.START;
    int holdCount = 0;
    Strategy triggerStrategy;
    Strategy endStrategy;
    final int maxHoldCount;
    public static int DEFAULT_MAX_HOLD_COUNT = 20;

    public DoubleClickStateMachine(Strategy triggerStrategy, Strategy endStrategy, int maxHoldCount) {
        this.triggerStrategy = triggerStrategy;
        this.endStrategy = endStrategy;
        this.maxHoldCount = maxHoldCount;
    }

    public DoubleClickStateMachine(Strategy triggerStrategy, Strategy endStrategy) {
        this(triggerStrategy, endStrategy, DEFAULT_MAX_HOLD_COUNT);
    }

    public void transition(Event e) {
        ++this.holdCount;
        switch (this.state) {
            case START: {
                if (e != Event.KEY_DOWN) break;
                this.state = State.KEY_ON;
                this.holdCount = 0;
                break;
            }
            case KEY_ON: {
                if (e == Event.KEY_UP) {
                    this.state = State.KEY_OFF;
                    this.holdCount = 0;
                }
                if (e != Event.KEY_DOWN || this.holdCount <= this.maxHoldCount) break;
                this.state = State.TOO_LATE_FOR_TRIGGER;
                this.holdCount = 0;
                break;
            }
            case KEY_OFF: {
                if (e == Event.KEY_DOWN) {
                    this.state = State.TRIGGER;
                    this.triggerStrategy.execute();
                    this.holdCount = 0;
                }
                if (e != Event.KEY_UP || this.holdCount <= this.maxHoldCount) break;
                this.state = State.START;
                this.holdCount = 0;
                break;
            }
            case TRIGGER: {
                if (e != Event.KEY_UP || this.holdCount <= this.maxHoldCount) break;
                this.endStrategy.execute();
                this.state = State.START;
                this.holdCount = 0;
                break;
            }
            case TOO_LATE_FOR_TRIGGER: {
                if (e != Event.KEY_UP) break;
                this.state = State.START;
                this.holdCount = 0;
            }
        }
    }

    public static interface Strategy {
        public void execute();
    }

    static enum Event {
        KEY_DOWN,
        KEY_UP;

    }

    static enum State {
        START,
        KEY_ON,
        KEY_OFF,
        TRIGGER,
        TOO_LATE_FOR_TRIGGER;

    }
}

