/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.items;

import com.hackshop.ultimate_unicorn.Config;
import com.hackshop.ultimate_unicorn.ShootWandMessage;
import com.hackshop.ultimate_unicorn.items.HornShootable;
import com.hackshop.ultimate_unicorn.items.ItemHelper;
import com.hackshop.ultimate_unicorn.network.PacketHandler;
import com.hackshop.ultimate_unicorn.util.WorldUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemWandOfCallLightning
extends Item
implements HornShootable {
    public ItemWandOfCallLightning(Item.Properties props) {
        super(props);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasEffect(ItemStack stack) {
        return true;
    }

    public boolean onDroppedByPlayer(ItemStack stack, PlayerEntity player) {
        if (player.func_184607_cu() == stack) {
            stack.func_222118_a(4, (LivingEntity)player, a -> a.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public float func_150893_a(ItemStack stack, BlockState block) {
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, a -> a.func_213361_c(EquipmentSlotType.MAINHAND));
        BlockPos targetPos = ItemWandOfCallLightning.getLightningStrikePosOnEntity(target.field_70170_p, (Entity)target);
        LightningBoltEntity lightning = new LightningBoltEntity(EntityType.field_200728_aG, target.field_70170_p);
        lightning.func_242277_a(new Vector3d((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p()));
        lightning.func_204809_d(attacker instanceof ServerPlayerEntity ? (ServerPlayerEntity)attacker : null);
        ((ServerWorld)target.field_70170_p).func_217376_c((Entity)lightning);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState blockIn, BlockPos pos, LivingEntity playerIn) {
        if ((double)blockIn.func_185887_b((IBlockReader)worldIn, pos) != 0.0) {
            stack.func_222118_a(2, playerIn, a -> a.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFull3D() {
        return true;
    }

    public UseAction getItemUseAction(ItemStack stack) {
        return UseAction.NONE;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 120;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        if (worldIn.field_72995_K) {
            this.clientShoot();
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (count % 8 == 0 && player.field_70170_p.field_72995_K && player == Minecraft.func_71410_x().field_71439_g) {
            this.clientShoot();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientShoot() {
        ClientPlayerEntity playerIn = Minecraft.func_71410_x().field_71439_g;
        World worldIn = playerIn.field_70170_p;
        BlockPos targetPos = null;
        RayTraceResult raytraceresult = ItemWandOfCallLightning.longRayTrace(worldIn, (PlayerEntity)playerIn, RayTraceContext.FluidMode.SOURCE_ONLY, 25.0);
        if (null != raytraceresult) {
            switch (raytraceresult.func_216346_c()) {
                case BLOCK: {
                    targetPos = WorldUtil.getTopSolidOrLiquidBlock(new BlockPos(raytraceresult.func_216347_e()), worldIn);
                    break;
                }
                case ENTITY: {
                    targetPos = ItemWandOfCallLightning.getLightningStrikePosOnEntity(worldIn, ((EntityRayTraceResult)raytraceresult).func_216348_a());
                    break;
                }
            }
        }
        if (targetPos != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new ShootWandMessage(targetPos));
        }
    }

    @Override
    public void shoot(ItemStack stack, World worldIn, LivingEntity shooter, BlockPos targetPos) {
        if (null != targetPos && !worldIn.field_72995_K && !((Boolean)Config.COMMON.disable_lightning_wand.get()).booleanValue()) {
            ItemHelper.horseDamageItem(stack, 1, shooter);
            LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(worldIn);
            lightningboltentity.func_242277_a(new Vector3d((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p()));
            lightningboltentity.func_70107_b((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p());
            lightningboltentity.func_204809_d(shooter instanceof ServerPlayerEntity ? (ServerPlayerEntity)shooter : null);
            ((ServerWorld)worldIn).func_217376_c((Entity)lightningboltentity);
        }
    }

    @Override
    public void shootTargetEntity(ItemStack stack, World worldIn, LivingEntity shooter, LivingEntity targetEntity) {
        if (null != targetEntity && !worldIn.field_72995_K) {
            stack.func_222118_a(1, shooter, a -> a.func_213361_c(EquipmentSlotType.MAINHAND));
            BlockPos targetPos = ItemWandOfCallLightning.getLightningStrikePosOnEntity(worldIn, (Entity)targetEntity);
            LightningBoltEntity lightningboltentity = new LightningBoltEntity(EntityType.field_200728_aG, worldIn);
            lightningboltentity.func_242277_a(new Vector3d((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p()));
            lightningboltentity.func_70107_b((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p());
            lightningboltentity.func_204809_d(shooter instanceof ServerPlayerEntity ? (ServerPlayerEntity)shooter : null);
            ((ServerWorld)worldIn).func_217376_c((Entity)lightningboltentity);
        }
    }

    public static BlockPos getLightningStrikePosOnEntity(World worldIn, Entity entityToStrike) {
        BlockPos targetPos = WorldUtil.getTopSolidOrLiquidBlock(new BlockPos(entityToStrike.func_226277_ct_(), entityToStrike.func_226278_cu_(), entityToStrike.func_226281_cx_()), worldIn);
        if ((double)targetPos.func_177956_o() > entityToStrike.func_226278_cu_()) {
            return targetPos;
        }
        return new BlockPos(entityToStrike.func_226277_ct_(), entityToStrike.func_226278_cu_(), entityToStrike.func_226281_cx_());
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity playerIn, int timeLeft) {
    }

    public boolean func_150897_b(BlockState blockIn) {
        return false;
    }

    public static RayTraceResult longRayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode, double distance) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vector3d vec3d1 = vec3d.func_72441_c((double)f6 * distance, (double)f5 * distance, (double)f7 * distance);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }
}

