/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.mobs;

import com.hackshop.ultimate_unicorn.mobs.EntityMagicalHorse;
import com.hackshop.ultimate_unicorn.mobs.GeneEnum;

public class BodyTypeTraits {
    public static boolean isTall(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.KIRIN.matches(gene) || BodyType.DEER.matches(gene);
    }

    public static boolean hasWhiskers(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.KIRIN.matches(gene);
    }

    public static boolean hasNeckFringe(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.KIRIN.matches(gene);
    }

    public static boolean hasBodyHair(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.KIRIN.matches(gene);
    }

    public static boolean hasHorseTail(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.HORSE.matches(gene);
    }

    public static boolean hasHorseFace(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.HORSE.matches(gene) && GeneEnum.HEAD_TYPE.getHorseValue(horse.getDnaArray()) == 0;
    }

    public static boolean hasDragonTail(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.KIRIN.matches(gene);
    }

    public static boolean hasRoosterTail(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.HIPPALECTRYON.matches(gene);
    }

    public static boolean hasDeerTail(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.DEER.matches(gene);
    }

    public static boolean hasFancyMane(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.KIRIN.matches(gene) || BodyType.HIPPALECTRYON.matches(gene);
    }

    public static boolean hasNoMane(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.DEER.matches(gene);
    }

    public static boolean hasBeard(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.KIRIN.matches(gene);
    }

    public static boolean hasLegHair(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.KIRIN.matches(gene);
    }

    public static boolean hasSmallMouth(EntityMagicalHorse horse) {
        int gene = GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray());
        return BodyType.KIRIN.matches(gene) || BodyType.DEER.matches(gene);
    }

    public static boolean hasBackClaws(EntityMagicalHorse horse) {
        return BodyType.HIPPALECTRYON.matches(GeneEnum.ALT_BODY_TYPE.getHorseValue(horse.getDnaArray())) || GeneEnum.BACK_CLAWS.getHorseValue(horse.getDnaArray()) == 1 || GeneEnum.BACK_CLAWS.getHorseValue(horse.getDnaArray()) == 3;
    }

    public static boolean hasBackLionLegs(EntityMagicalHorse horse) {
        return GeneEnum.BACK_CLAWS.getHorseValue(horse.getDnaArray()) == 2;
    }

    public static boolean hasFrontClaws(EntityMagicalHorse horse) {
        return GeneEnum.FRONT_CLAWS.getHorseValue(horse.getDnaArray()) == 1;
    }

    public static boolean hasFrontLionLegs(EntityMagicalHorse horse) {
        return GeneEnum.FRONT_CLAWS.getHorseValue(horse.getDnaArray()) == 2;
    }

    public static HeadType getHeadType(EntityMagicalHorse horse) {
        int val = GeneEnum.HEAD_TYPE.getHorseValue(horse.getDnaArray());
        if (val == 1) {
            return HeadType.EAGLE;
        }
        return HeadType.HORSE;
    }

    public static enum HeadType {
        HORSE,
        EAGLE;

    }

    public static enum BodyType {
        HORSE(0),
        KIRIN(15),
        DEER(1),
        HIPPALECTRYON(2);

        public final int gene;

        private BodyType(int gene) {
            this.gene = gene;
        }

        public boolean matches(int g) {
            return g == this.gene;
        }
    }
}

