/*
 * Decompiled with CFR 0.152.
 */
package com.hackshop.ultimate_unicorn.mobs;

import com.hackshop.ultimate_unicorn.mobs.DnaIncr;

public enum GeneEnum {
    HORN(0, 2, '0', 'H', 'H', 'H'),
    WINGS(0, 2, '0', 'T', 'B', 'B'),
    AURA(0, 2, '0', 'A', 'A', 'A'),
    BODY_SIZE(0, 2, '0', 'D', 'D', 'D'),
    HOOF_EFFECT(0, 2, '0', 'F', 'F', 'F'),
    HIDE(0, 5, 'z', 'u', 'n', 'p', 'd', 'U', 'P', 'N', 'D', 'h', 'C', 'k', 'K', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'e', 'f', 'g'),
    WATER_BREATHING(1, 1, '0', 'G'),
    BACK_FIN(1, 2, '0', 'F', 'F', 'F'),
    LONG_TAIL(1, 1, '0', 'T'),
    ANTLERS(1, 2, '0', 'N', 'N', 'N'),
    ALT_BODY_TYPE(1, 4, '0', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O'),
    MAGIC_POWERS(1, 4, '0', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O'),
    DONKEY_EARS(1, 1, '0', 'd'),
    FRONT_CLAWS(2, 2, 'H', 'C', 'L', 'C'),
    BACK_CLAWS(2, 2, 'H', 'C', 'L', 'C'),
    HEAD_TYPE(2, 3, true, 'H', 'E', 'H', 'H', 'H', 'H', 'H', 'H');

    public final int strand;
    public final int size;
    public final int offset;
    public final int offset2;
    public final int singleGeneBottomMask;
    public final int mask;
    public final int oppMask;
    public final char[] labels;
    private static final int[] bitMasks;

    private GeneEnum(int strand, int size, char ... labels) {
        this.strand = strand;
        this.size = size;
        this.offset = DnaIncr.getAndIncOffset(strand, size);
        this.offset2 = this.offset + this.size;
        this.singleGeneBottomMask = (1 << size) - 1;
        this.mask = (1 << size * 2) - 1 << this.offset;
        this.oppMask = ~this.mask;
        this.labels = labels;
    }

    private GeneEnum(int strand, int size, boolean clearDnaIncr, char ... labels) {
        this.strand = strand;
        this.size = size;
        this.offset = DnaIncr.getAndIncOffset(strand, size);
        this.offset2 = this.offset + this.size;
        this.singleGeneBottomMask = (1 << size) - 1;
        this.mask = (1 << size * 2) - 1 << this.offset;
        this.oppMask = ~this.mask;
        this.labels = labels;
        if (clearDnaIncr) {
            DnaIncr.clear();
        }
    }

    public char getLabelFor(int dna, boolean pos1) {
        int specDna = pos1 ? dna >> this.offset : dna >> this.offset + this.size;
        return this.labels[specDna & bitMasks[this.size]];
    }

    public int getHorseValue(int[] dnaArray) {
        int dnaOfNote = dnaArray[this.strand];
        return this.getHorseValue(dnaOfNote);
    }

    public int getHorseValue(int dnaOfNote) {
        int shiftedDna = (dnaOfNote & this.mask) >> this.offset;
        int dna1 = shiftedDna & this.singleGeneBottomMask;
        int dna2 = shiftedDna >> this.size & this.singleGeneBottomMask;
        return dna1 > dna2 ? dna1 : dna2;
    }

    static {
        bitMasks = new int[]{0, 1, 3, 7, 15, 31, 63, 127};
    }
}

